/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.MetadataPlan;
import oracle.kv.impl.admin.plan.TablePlanGenerator;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;

@Persistent
public class StartAddIndex
extends UpdateMetadata<TableMetadata> {
    private static final long serialVersionUID = 1L;
    private String indexName;
    private String tableName;
    private String[] indexedFields;
    private String description;

    public StartAddIndex(MetadataPlan<TableMetadata> plan, String indexName, String tableName, String[] indexedFields, String description) {
        super(plan);
        this.indexName = indexName;
        this.tableName = tableName;
        this.indexedFields = indexedFields;
        this.description = description;
        TableMetadata md = plan.getMetadata();
        if (md == null) {
            throw new IllegalStateException("Table metadata not found");
        }
        TableImpl table = md.getTable(tableName);
        if (table == null) {
            throw new IllegalCommandException("AddIndex: table does not exist: " + tableName);
        }
        if (table.getIndex(indexName) != null) {
            throw new IllegalCommandException("AddIndex: index: " + indexName + " already exists in table: " + tableName);
        }
        new IndexImpl(indexName, table, new ArrayList<String>(Arrays.asList(indexedFields)), description);
    }

    private StartAddIndex() {
    }

    @Override
    protected TableMetadata updateMetadata() {
        TableMetadata md = (TableMetadata)this.plan.getMetadata();
        if (md == null) {
            throw new IllegalStateException("Table metadata not found");
        }
        TableImpl table = md.getTable(this.tableName);
        if (table == null) {
            throw new IllegalStateException("Table " + this.tableName + " is missing from " + md);
        }
        if (table.getIndex(this.indexName) == null) {
            md.addIndex(this.indexName, this.tableName, new ArrayList<String>(Arrays.asList(this.indexedFields)), this.description);
            this.plan.getAdmin().saveMetadata(md, this.plan);
        }
        return md;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public String toString() {
        return TablePlanGenerator.makeName("StartAddIndex", this.tableName, this.indexName);
    }
}

