/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.Collection;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMetadata;

@Persistent
public class RemoveUser
extends UpdateMetadata<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private String userName;

    public RemoveUser(SecurityMetadataPlan plan, String userName) {
        super(plan);
        SecurityMetadata secMd = (SecurityMetadata)plan.getMetadata();
        RemoveUser.ensureNotDropLastAdmin(userName, secMd);
        this.userName = userName;
    }

    private RemoveUser() {
    }

    private static void ensureNotDropLastAdmin(String userToDrop, SecurityMetadata secMd) {
        if (secMd == null) {
            return;
        }
        KVStoreUser existUser = secMd.getUser(userToDrop);
        if (existUser != null && existUser.isAdmin()) {
            Collection<KVStoreUser> users = secMd.getAllUsers();
            for (KVStoreUser user : users) {
                if (user.getName().equals(userToDrop) || !user.isAdmin() || !user.isEnabled()) continue;
                return;
            }
            throw new IllegalCommandException("Cannot drop the only enabled Admin of: " + userToDrop);
        }
    }

    @Override
    protected SecurityMetadata updateMetadata() {
        SecurityMetadata secMd = (SecurityMetadata)this.plan.getMetadata();
        RemoveUser.ensureNotDropLastAdmin(this.userName, secMd);
        if (secMd != null && secMd.getUser(this.userName) != null) {
            secMd.removeUser(secMd.getUser(this.userName).getElementId());
            this.plan.getAdmin().saveMetadata(secMd, this.plan);
        }
        return secMd;
    }
}

