/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.MetadataPlan;
import oracle.kv.impl.admin.plan.TablePlanGenerator;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;

@Persistent
public class RemoveIndex
extends UpdateMetadata<TableMetadata> {
    private static final long serialVersionUID = 1L;
    private String indexName;
    private String tableName;

    public RemoveIndex(MetadataPlan<TableMetadata> plan, String indexName, String tableName) {
        super(plan);
        this.indexName = indexName;
        this.tableName = tableName;
        TableMetadata md = plan.getMetadata();
        if (md == null) {
            throw new IllegalCommandException("Table metadata not found");
        }
        TableImpl table = md.getTable(tableName);
        if (table == null || table.getIndex(indexName) == null) {
            throw new IllegalCommandException("RemoveIndex: index: " + indexName + " does not exists in table: " + tableName);
        }
    }

    private RemoveIndex() {
    }

    @Override
    protected TableMetadata updateMetadata() {
        TableMetadata md = (TableMetadata)this.plan.getMetadata();
        if (md == null) {
            throw new IllegalStateException("Table metadata not found");
        }
        TableImpl table = md.getTable(this.tableName);
        if (table != null && table.getIndex(this.indexName) != null) {
            md.dropIndex(this.indexName, this.tableName);
            this.plan.getAdmin().saveMetadata(md, this.plan);
        }
        return md;
    }

    @Override
    public String toString() {
        return TablePlanGenerator.makeName("RemoveIndex", this.tableName, this.indexName);
    }
}

