/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent
public class NewRNGlobalParameters
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private RepNodeId targetNodeId;
    private AbstractPlan plan;

    public NewRNGlobalParameters(AbstractPlan plan, RepNodeId targetNodeId) {
        this.plan = plan;
        this.targetNodeId = targetNodeId;
    }

    private NewRNGlobalParameters() {
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public Task.State doWork() throws Exception {
        this.plan.getLogger().log(Level.FINE, "Sending newGlobalParameters to {0}", this.targetNodeId);
        try {
            RegistryUtils registry = new RegistryUtils(this.plan.getAdmin().getCurrentTopology(), this.plan.getAdmin().getLoginManager());
            RepNodeAdminAPI rnAdmin = registry.getRepNodeAdmin(this.targetNodeId);
            rnAdmin.newGlobalParameters();
        }
        catch (NotBoundException notbound) {
            this.plan.getLogger().info(this.targetNodeId + " cannot be contacted when updating its global parameters: " + notbound);
            throw notbound;
        }
        catch (RemoteException e) {
            this.plan.getLogger().severe("Attempting to update global parameters for targetNodeId:" + e);
            throw e;
        }
        return Task.State.SUCCEEDED;
    }

    @Override
    public String toString() {
        return super.toString() + this.targetNodeId + " to refresh its global parameter state without restarting";
    }
}

