/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.List;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.DeployTopoPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent
public class NewNthRNParameters
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private int nthRN;
    private int planShardIdx;
    private DeployTopoPlan plan;

    public NewNthRNParameters() {
    }

    public NewNthRNParameters(DeployTopoPlan plan, int planShardIdx, int nthRN) {
        this.plan = plan;
        this.planShardIdx = planShardIdx;
        this.nthRN = nthRN;
    }

    @Override
    public Task.State doWork() throws Exception {
        Topology topo = this.plan.getAdmin().getCurrentTopology();
        RepGroupId rgId = this.plan.getShardId(this.planShardIdx);
        List<RepNodeId> rnList = topo.getSortedRepNodeIds(rgId);
        RepNodeId targetRNId = rnList.get(this.nthRN);
        StorageNodeId hostSNId = topo.get(targetRNId).getStorageNodeId();
        this.plan.getLogger().fine("Sending newParameters to " + targetRNId);
        GlobalParams gp = this.plan.getAdmin().getParams().getGlobalParams();
        StorageNodeParams snp = this.plan.getAdmin().getStorageNodeParams(hostSNId);
        RepNodeAdminAPI rnai = RegistryUtils.getRepNodeAdmin(gp.getKVStoreName(), snp.getHostname(), snp.getRegistryPort(), targetRNId, this.plan.getLoginManager());
        rnai.newParameters();
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }
}

