/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.MetadataPlan;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;

@Persistent
public class EvolveTable
extends UpdateMetadata<TableMetadata> {
    private static final long serialVersionUID = 1L;
    private String tableName;
    private int tableVersion;
    private FieldMap fieldMap;

    public EvolveTable(MetadataPlan<TableMetadata> plan, String tableName, int tableVersion, FieldMap fieldMap) {
        super(plan);
        this.tableName = tableName;
        this.fieldMap = fieldMap;
        this.tableVersion = tableVersion;
        TableMetadata md = plan.getMetadata();
        if (md == null || md.getTable(tableName) == null) {
            throw new IllegalCommandException("Table does not exist: " + tableName);
        }
    }

    private EvolveTable() {
    }

    @Override
    protected TableMetadata updateMetadata() {
        TableMetadata md = (TableMetadata)this.plan.getMetadata();
        if (md == null) {
            throw new IllegalStateException("Table metadata not found");
        }
        TableImpl table = md.getTable(this.tableName);
        if (table == null) {
            throw new IllegalStateException("Cannot find table to evolve: " + this.tableName);
        }
        if (md.evolveTable(table, this.tableVersion, this.fieldMap)) {
            this.plan.getAdmin().saveMetadata(md, this.plan);
        }
        return md;
    }
}

