/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.persist.model.Persistent;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.topo.AdminId;

@Persistent(version=0)
public class EnsureAdminNotMaster
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private AbstractPlan plan;
    private AdminId adminId;

    public EnsureAdminNotMaster(AbstractPlan plan, AdminId adminId) {
        this.plan = plan;
        this.adminId = adminId;
    }

    EnsureAdminNotMaster() {
    }

    @Override
    public Task.State doWork() throws Exception {
        final PlannerAdmin admin = this.plan.getAdmin();
        if (this.adminId.equals(admin.getParams().getAdminParams().getAdminId())) {
            if (admin.getAdminCount() <= 1) {
                throw new IllegalStateException("Can't change Admin mastership if there are no replicas.");
            }
            new StoppableThread("EnsureAdminNotMasterThread"){

                @Override
                public void run() {
                    admin.awaitPlan(EnsureAdminNotMaster.this.plan.getId(), 10000, TimeUnit.SECONDS);
                    admin.transferMaster();
                }

                @Override
                protected Logger getLogger() {
                    return EnsureAdminNotMaster.this.plan.getLogger();
                }
            }.start();
            return Task.State.INTERRUPTED;
        }
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " ensure admin is not the master " + this.adminId;
    }
}

