/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.je.rep.NodeType;
import com.sleepycat.persist.model.Persistent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.TopologyCheck;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.DeployTopoPlan;
import oracle.kv.impl.admin.plan.PortTracker;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.TopologyPrinter;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.server.LoggerUtils;

@Persistent
public class DeployNewRN
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private DeployTopoPlan plan;
    private StorageNodeId snId;
    private String snDescriptor;
    private String mountPoint;
    private RepNodeId displayRNId;
    private int planShardIdx;
    private RepGroupId specifiedShard;
    public static TestHook<String> FAULT_HOOK;

    public DeployNewRN(DeployTopoPlan plan, StorageNodeId snId, int planShardIdx, String mountPoint) {
        this.planShardIdx = planShardIdx;
        this.init(plan, snId, mountPoint);
    }

    public DeployNewRN(DeployTopoPlan plan, StorageNodeId snId, RepGroupId specifiedShard, String mountPoint) {
        this.specifiedShard = specifiedShard;
        this.init(plan, snId, mountPoint);
    }

    private void init(DeployTopoPlan plan1, StorageNodeId snId1, String mountPoint1) {
        this.plan = plan1;
        this.mountPoint = mountPoint1;
        this.snId = snId1;
        StorageNodeParams snp = plan1.getAdmin().getStorageNodeParams(snId1);
        this.snDescriptor = snp.displaySNIdAndHost();
    }

    DeployNewRN() {
    }

    private RepNodeParams makeRepNodeParams(Topology current, RepGroupId rgId, RepNodeId rnId) {
        String helperHosts;
        Parameters params = this.plan.getAdmin().getCurrentParameters();
        ParameterMap pMap = params.copyPolicies();
        String haHostname = params.get(this.snId).getHAHostname();
        PortTracker portTracker = new PortTracker(current, params, this.snId);
        int haPort = portTracker.getNextPort(this.snId);
        String otherHelpers = this.findHelperHosts(current.get(rgId), rnId, params);
        NodeType nodeType = this.computeNodeType(current);
        if (otherHelpers.length() == 0) {
            if (!nodeType.isElectable()) {
                throw new IllegalStateException("The self-electing node must be electable");
            }
            helperHosts = haHostname + ":" + haPort;
        } else {
            helperHosts = otherHelpers;
        }
        RepNodeParams rnp = new RepNodeParams(pMap, this.snId, rnId, false, haHostname, haPort, helperHosts, this.mountPoint, nodeType);
        StorageNodeParams snp = params.get(this.snId);
        int numRNsOnSN = current.getHostedRepNodeIds(this.snId).size();
        StorageNodeParams.RNHeapAndCacheSize heapAndCache = snp.calculateRNHeapAndCache(pMap, numRNsOnSN, rnp.getRNCachePercent());
        long heapMB = heapAndCache.getHeapMB();
        long cacheBytes = heapAndCache.getCacheBytes();
        int gcThreads = snp.calcGCThreads();
        this.plan.getLogger().log(Level.INFO, "Creating {0} on {1} haPort={2}:{3} helpers={4} storage directory={5} heapMB={6} cacheSize={7} -XX:ParallelGCThreads={8}", new Object[]{rnId, this.snId, haHostname, haPort, helperHosts, this.mountPoint, heapMB == 0L ? "unspecified" : Long.valueOf(heapMB), cacheBytes == 0L ? "unspecified" : Long.valueOf(cacheBytes), gcThreads == 0 ? "unspecified" : Integer.valueOf(gcThreads)});
        rnp.setRNHeapAndJECache(heapAndCache);
        rnp.setParallelGCThreads(gcThreads);
        return rnp;
    }

    private String findHelperHosts(RepGroup shard, RepNodeId targetRNId, Parameters params) {
        StringBuilder helperHosts = new StringBuilder();
        for (RepNode rn : shard.getRepNodes()) {
            RepNodeId rId = (RepNodeId)rn.getResourceId();
            if (rId.equals(targetRNId)) continue;
            if (helperHosts.length() != 0) {
                helperHosts.append(",");
            }
            helperHosts.append(params.get(rId).getJENodeHostPort());
        }
        return helperHosts.toString();
    }

    private NodeType computeNodeType(Topology current) {
        Datacenter datacenter = current.getDatacenter(this.snId);
        DatacenterType datacenterType = datacenter.getDatacenterType();
        switch (datacenterType) {
            case PRIMARY: {
                return NodeType.ELECTABLE;
            }
            case SECONDARY: {
                return NodeType.SECONDARY;
            }
        }
        throw new AssertionError();
    }

    @Override
    public Task.State doWork() throws Exception {
        RepGroupId shardId = null;
        shardId = this.specifiedShard == null ? this.plan.getShardId(this.planShardIdx) : this.specifiedShard;
        PlannerAdmin admin = this.plan.getAdmin();
        Topology current = admin.getCurrentTopology();
        RepGroup rg = current.get(shardId);
        if (rg == null) {
            throw new IllegalStateException("Expectedly can't find shard " + shardId + " current topology=" + TopologyPrinter.printTopology(current));
        }
        Topology.Component rn = null;
        RepNodeParams rnp = null;
        for (RepNode existing : rg.getRepNodes()) {
            if (!existing.getStorageNodeId().equals(this.snId)) continue;
            rn = existing;
            rnp = admin.getRepNodeParams((RepNodeId)rn.getResourceId());
        }
        if (rn == null) {
            rn = new RepNode(this.snId);
            rg.add((RepNode)rn);
            this.displayRNId = (RepNodeId)rn.getResourceId();
            assert (TestHookExecute.doHookIfSet(FAULT_HOOK, this.makeHookTag("1")));
            rnp = this.makeRepNodeParams(current, (RepGroupId)rg.getResourceId(), (RepNodeId)rn.getResourceId());
            admin.saveTopoAndRNParam(current, this.plan.getDeployedInfo(), rnp, this.plan);
        } else {
            this.displayRNId = (RepNodeId)rn.getResourceId();
        }
        assert (TestHookExecute.doHookIfSet(FAULT_HOOK, this.makeHookTag("2")));
        LoginManager loginMgr = admin.getLoginManager();
        RegistryUtils regUtils = new RegistryUtils(current, loginMgr);
        StorageNodeAgentAPI sna = regUtils.getStorageNodeAgent(this.snId);
        if (rnp == null) {
            throw new IllegalStateException("RepNodeParams null for " + rn);
        }
        sna.createRepNode(rnp.getMap(), Utils.getMetadataSet(current, this.plan));
        StorageNode sn = current.get(this.snId);
        admin.getMonitor().registerAgent(sn.getHostname(), sn.getRegistryPort(), (ResourceId)rn.getResourceId());
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public String toString() {
        if (this.displayRNId == null) {
            return super.toString() + " on " + this.snDescriptor;
        }
        return super.toString() + " " + this.displayRNId + " on " + this.snDescriptor;
    }

    @Override
    public String getName() {
        if (this.displayRNId == null) {
            return super.getName() + " on " + this.snDescriptor;
        }
        return super.getName() + " " + this.displayRNId + " on " + this.snDescriptor;
    }

    @Override
    public Runnable getCleanupJob() {
        return new Runnable(){

            @Override
            public void run() {
                boolean done = false;
                int numAttempts = 0;
                while (!done && !DeployNewRN.this.plan.cleanupInterrupted()) {
                    try {
                        done = DeployNewRN.this.cleanupAllocation();
                        ++numAttempts;
                    }
                    catch (Exception e) {
                        DeployNewRN.this.plan.getLogger().log(Level.SEVERE, "{0}: problem when cancelling deployment of RN {1}", new Object[]{this, LoggerUtils.getStackTrace(e)});
                        throw new RuntimeException(e);
                    }
                    if (done) continue;
                    if (numAttempts > 5) {
                        return;
                    }
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        };
    }

    private boolean cleanupAllocation() throws RemoteException, NotBoundException {
        Logger logger = this.plan.getLogger();
        assert (TestHookExecute.doHookIfSet(FAULT_HOOK, this.makeHookTag("cleanup")));
        if (this.displayRNId == null) {
            logger.info("DeployNewRN cleanup: RN not created.");
            return true;
        }
        Admin admin = (Admin)this.plan.getAdmin();
        TopologyCheck checker = new TopologyCheck(logger, admin.getCurrentTopology(), admin.getCurrentParameters());
        TopologyCheck.Remedy remedy = checker.checkRNLocation(admin, this.snId, this.displayRNId, true, true);
        logger.info("DeployNewRN cleanup: " + remedy);
        return checker.applyRemedy(remedy, this.plan, this.plan.getDeployedInfo(), null, null);
    }

    private String makeHookTag(String pointName) {
        return "DeployNewRN/" + this.snId + "_pt" + pointName;
    }
}

