/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.PortTracker;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent(version=1)
public class DeployAdmin
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    public static TestHook<Integer> FAULT_HOOK;
    private AbstractPlan plan;
    private AdminId adminId;
    private StorageNodeId snId;

    public DeployAdmin(AbstractPlan plan, StorageNodeId snId, AdminId adminId) {
        this.plan = plan;
        this.snId = snId;
        this.adminId = adminId;
    }

    public DeployAdmin() {
    }

    @Override
    public Task.State doWork() throws Exception {
        PlannerAdmin admin = this.plan.getAdmin();
        Topology topology = admin.getCurrentTopology();
        Parameters parameters = admin.getCurrentParameters();
        AdminParams ap = parameters.get(this.adminId);
        if (ap.getHelperHosts() == null) {
            this.initParams(topology, parameters, admin, ap);
        }
        assert (TestHookExecute.doHookIfSet(FAULT_HOOK, 1));
        LoginManager loginMgr = admin.getLoginManager();
        RegistryUtils registryUtils = new RegistryUtils(topology, loginMgr);
        StorageNodeAgentAPI sna = registryUtils.getStorageNodeAgent(this.snId);
        sna.createAdmin(ap.getMap());
        assert (TestHookExecute.doHookIfSet(FAULT_HOOK, 2));
        return Task.State.SUCCEEDED;
    }

    private void initParams(Topology topology, Parameters parameters, PlannerAdmin admin, AdminParams ap) {
        String helperHost;
        String nodeHostPort;
        if (this.adminId.getAdminInstanceId() == 1) {
            helperHost = nodeHostPort = admin.getParams().getAdminParams().getNodeHostPort();
        } else {
            PortTracker portTracker = new PortTracker(topology, parameters, this.snId);
            String haHostName = parameters.get(this.snId).getHAHostname();
            int haPort = portTracker.getNextPort(this.snId);
            nodeHostPort = haHostName + ":" + haPort;
            helperHost = Utils.findAdminHelpers(parameters, this.adminId);
        }
        ap.setJEInfo(nodeHostPort, helperHost);
        this.plan.getAdmin().updateParams(ap);
    }

    @Override
    public String toString() {
        return super.toString() + " AdminId[" + this.adminId + "] on SNId[" + this.snId + "]";
    }

    public StorageNodeId getSnId() {
        return this.snId;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }
}

