/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent
public class DeleteRepNode
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private StorageNodeId snId;
    private RepNodeId rnId;
    private AbstractPlan plan;

    public DeleteRepNode() {
    }

    public DeleteRepNode(AbstractPlan plan, StorageNodeId snId, RepNodeId rnId) {
        this.plan = plan;
        this.snId = snId;
        this.rnId = rnId;
    }

    @Override
    public Task.State doWork() throws Exception {
        try {
            RegistryUtils registry = new RegistryUtils(this.plan.getAdmin().getCurrentTopology(), this.plan.getAdmin().getLoginManager());
            StorageNodeAgentAPI sna = registry.getStorageNodeAgent(this.snId);
            sna.destroyRepNode(this.rnId, true);
            return Task.State.SUCCEEDED;
        }
        catch (NotBoundException notbound) {
            this.plan.getLogger().info(this.snId + " cannot be contacted to delete " + this.rnId + ":" + notbound);
        }
        catch (RemoteException e) {
            this.plan.getLogger().severe("Attempting to delete " + this.rnId + " from " + this.snId + ": " + e);
        }
        return Task.State.ERROR;
    }

    @Override
    public String toString() {
        StorageNodeParams snp = this.plan.getAdmin() != null ? this.plan.getAdmin().getStorageNodeParams(this.snId) : null;
        return super.toString() + " remove " + this.rnId + " from " + (snp != null ? snp.displaySNIdAndHost() : this.snId);
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public void lockTopoComponents(Planner planner) {
        planner.lockRN(this.plan.getId(), this.plan.getName(), this.rnId);
    }
}

