/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.plan.MetadataPlan;
import oracle.kv.impl.admin.plan.TablePlanGenerator;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.TableMetadata;

@Persistent
public class CompleteAddIndex
extends UpdateMetadata<TableMetadata> {
    private static final long serialVersionUID = 1L;
    private String indexName;
    private String tableName;

    public CompleteAddIndex(MetadataPlan<TableMetadata> plan, String indexName, String tableName) {
        super(plan);
        this.indexName = indexName;
        this.tableName = tableName;
    }

    private CompleteAddIndex() {
    }

    @Override
    protected TableMetadata updateMetadata() {
        TableMetadata md = (TableMetadata)this.plan.getMetadata();
        if (md == null) {
            throw new IllegalStateException("Table metadata not found");
        }
        if (!md.updateIndexStatus(this.indexName, this.tableName, IndexImpl.IndexStatus.READY)) {
            throw new IllegalStateException("CompleteAddIndex: index does not exists: " + this.indexName + " in table: " + this.tableName);
        }
        this.plan.getAdmin().saveMetadata(md, this.plan);
        return md;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public String toString() {
        return TablePlanGenerator.makeName("CompleteAddIndex", this.tableName, this.indexName);
    }
}

