/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;

@Persistent
public class BroadcastMetadata<T extends Metadata<? extends MetadataInfo>>
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    protected AbstractPlan plan;
    protected T md;

    public BroadcastMetadata(AbstractPlan plan, T md) {
        this.plan = plan;
        this.md = md;
    }

    private BroadcastMetadata() {
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public Task.State doWork() throws Exception {
        if (this.md != null) {
            PlannerAdmin pa = this.plan.getAdmin();
            if (!Utils.broadcastMetadataChangesToRNs(this.plan.getLogger(), this.md, pa.getCurrentTopology(), this.toString(), pa.getParams().getAdminParams(), this.plan)) {
                return Task.State.INTERRUPTED;
            }
        }
        return Task.State.SUCCEEDED;
    }
}

