/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.Arrays;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.security.util.SecurityUtils;

@Persistent
public class AddUser
extends UpdateMetadata<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private String userName;
    private boolean isEnabled;
    private boolean isAdmin;
    private char[] plainPassword;

    public AddUser(SecurityMetadataPlan plan, String userName, boolean isEnabled, boolean isAdmin, char[] plainPassword) {
        super(plan);
        KVStoreUser preExistUser;
        SecurityMetadata secMd = (SecurityMetadata)plan.getMetadata();
        if (!(secMd != null && !secMd.getAllUsers().isEmpty() || isAdmin && isEnabled)) {
            throw new IllegalCommandException("The first user in the store must be -admin and enabled.");
        }
        this.userName = userName;
        this.isAdmin = isAdmin;
        this.isEnabled = isEnabled;
        this.plainPassword = Arrays.copyOf(plainPassword, plainPassword.length);
        if (secMd != null && (preExistUser = secMd.getUser(userName)) != null) {
            this.checkPreExistingUser(preExistUser);
        }
    }

    private AddUser() {
    }

    private void checkPreExistingUser(KVStoreUser user) {
        if (user.isEnabled() != this.isEnabled) {
            throw new IllegalCommandException("User with name " + this.userName + " already exists but has enabled state of " + user.isEnabled() + " rather than the requested enabled state of " + this.isEnabled);
        }
        if (user.isAdmin() != this.isAdmin) {
            throw new IllegalCommandException("User with name " + this.userName + " already exists but has admin setting of " + user.isAdmin() + " rather than the requested admin setting of " + this.isAdmin);
        }
        if (!user.verifyPassword(this.plainPassword)) {
            throw new IllegalCommandException("User with name " + this.userName + " already exists but has different password with the" + " requested one.");
        }
    }

    @Override
    protected SecurityMetadata updateMetadata() {
        SecurityMetadata md = (SecurityMetadata)this.plan.getMetadata();
        if (md == null) {
            String storeName = this.plan.getAdmin().getParams().getGlobalParams().getKVStoreName();
            md = new SecurityMetadata(storeName);
        }
        if (md.getUser(this.userName) == null) {
            KVStoreUser newUser = new KVStoreUser(this.userName);
            newUser.setEnabled(this.isEnabled).setAdmin(this.isAdmin).setPassword(((SecurityMetadataPlan)this.plan).makeDefaultHashDigest(this.plainPassword));
            md.addUser(newUser);
            this.plan.getAdmin().saveMetadata(md, this.plan);
        }
        SecurityUtils.clearPassword(this.plainPassword);
        return md;
    }
}

