/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.List;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.MetadataPlan;
import oracle.kv.impl.admin.plan.TablePlanGenerator;
import oracle.kv.impl.admin.plan.task.UpdateMetadata;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.TableMetadata;

@Persistent
public class AddTable
extends UpdateMetadata<TableMetadata> {
    private static final long serialVersionUID = 1L;
    private String tableName;
    private String parentName;
    private List<String> primaryKey;
    private List<String> majorKey;
    private FieldMap fieldMap;
    private boolean r2compat;
    private int schemaId;
    private String description;

    public AddTable(MetadataPlan<TableMetadata> plan, String tableName, String parentName, FieldMap fieldMap, List<String> primaryKey, List<String> majorKey, boolean r2compat, int schemaId, String description) {
        super(plan);
        this.tableName = tableName;
        this.parentName = parentName;
        this.primaryKey = primaryKey;
        this.majorKey = majorKey;
        this.fieldMap = fieldMap;
        this.r2compat = r2compat;
        this.schemaId = schemaId;
        this.description = description;
        TableMetadata md = plan.getMetadata();
        if (md != null && md.tableExists(tableName, parentName)) {
            throw new IllegalCommandException("Table already exists: " + TableMetadata.makeQualifiedName(tableName, parentName));
        }
    }

    private AddTable() {
    }

    @Override
    protected TableMetadata updateMetadata() {
        TableMetadata md = (TableMetadata)this.plan.getMetadata();
        if (md == null) {
            md = new TableMetadata(true);
        }
        if (!md.tableExists(this.tableName, this.parentName)) {
            md.addTable(this.tableName, this.parentName, this.primaryKey, this.majorKey, this.fieldMap, this.r2compat, this.schemaId, this.description);
            this.plan.getAdmin().saveMetadata(md, this.plan);
        }
        return md;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public String toString() {
        String name = TableMetadata.makeQualifiedName(this.tableName, this.parentName);
        return TablePlanGenerator.makeName("AddTable", name, null);
    }
}

