/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.BasicPlannerImpl;
import oracle.kv.impl.admin.plan.DeployTableMetadataPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.AddTable;
import oracle.kv.impl.admin.plan.task.CompleteAddIndex;
import oracle.kv.impl.admin.plan.task.EvolveTable;
import oracle.kv.impl.admin.plan.task.ParallelBundle;
import oracle.kv.impl.admin.plan.task.RemoveIndex;
import oracle.kv.impl.admin.plan.task.RemoveTable;
import oracle.kv.impl.admin.plan.task.StartAddIndex;
import oracle.kv.impl.admin.plan.task.WaitForAddIndex;
import oracle.kv.impl.admin.plan.task.WaitForRemoveTableData;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.Topology;

public class TablePlanGenerator {
    private TablePlanGenerator() {
    }

    static DeployTableMetadataPlan createAddTablePlan(AtomicInteger idGen, String planName, Planner planner, String tableName, String parentName, FieldMap fieldMap, List<String> primaryKey, List<String> majorKey, boolean r2compat, int schemaId, String description) {
        if (tableName == null) {
            throw new IllegalCommandException("Table name cannot be null");
        }
        if (fieldMap == null || fieldMap.isEmpty()) {
            throw new IllegalCommandException("Table has no defined fields");
        }
        DeployTableMetadataPlan plan = new DeployTableMetadataPlan(idGen, TablePlanGenerator.makeName(planName, tableName, null), planner);
        tableName = plan.getRealTableName(tableName);
        try {
            plan.addTask(new AddTable(plan, tableName, parentName, fieldMap, primaryKey, majorKey, r2compat, schemaId, description));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalCommandException("Failed to add table: " + iae.getMessage(), iae);
        }
        return plan;
    }

    static DeployTableMetadataPlan createEvolveTablePlan(AtomicInteger idGen, String planName, Planner planner, String tableName, int tableVersion, FieldMap fieldMap) {
        TablePlanGenerator.checkTable(tableName);
        if (fieldMap == null || fieldMap.isEmpty()) {
            throw new IllegalCommandException("Fields cannot be null or empty");
        }
        DeployTableMetadataPlan plan = new DeployTableMetadataPlan(idGen, TablePlanGenerator.makeName(planName, tableName, null), planner);
        tableName = plan.getRealTableName(tableName);
        try {
            plan.addTask(new EvolveTable(plan, tableName, tableVersion, fieldMap));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalCommandException("Failed to evolve table: " + iae.getMessage(), iae);
        }
        return plan;
    }

    static DeployTableMetadataPlan createRemoveTablePlan(AtomicInteger idGen, String planName, Planner planner, Topology topology, String tableName, boolean removeData) {
        TablePlanGenerator.checkTable(tableName);
        DeployTableMetadataPlan plan = new DeployTableMetadataPlan(idGen, TablePlanGenerator.makeName(planName, tableName, null), planner);
        tableName = plan.getRealTableName(tableName);
        try {
            TablePlanGenerator.addRemoveIndexTasks(plan, tableName);
            if (removeData) {
                plan.addTask(new RemoveTable(plan, tableName, true));
                ParallelBundle bundle = new ParallelBundle();
                for (RepGroupId id : topology.getRepGroupIds()) {
                    bundle.addTask(new WaitForRemoveTableData(plan, id, tableName));
                }
                if (!bundle.isEmpty()) {
                    plan.addTask(bundle);
                }
            }
            plan.addTask(new RemoveTable(plan, tableName, false));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalCommandException("Failed to remove table: " + iae.getMessage(), iae);
        }
        return plan;
    }

    private static void addRemoveIndexTasks(DeployTableMetadataPlan plan, String tableName) {
        TableMetadata md = (TableMetadata)plan.getMetadata();
        if (md != null) {
            TableImpl table = md.checkForRemove(tableName, true);
            for (String indexName : table.getIndexes().keySet()) {
                try {
                    plan.addTask(new RemoveIndex(plan, indexName, tableName));
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalCommandException("Failed to remove index: " + iae.getMessage(), iae);
                }
            }
        }
    }

    static DeployTableMetadataPlan createAddIndexPlan(AtomicInteger idGen, String planName, Planner planner, Topology topology, String indexName, String tableName, String[] indexedFields, String description) {
        TablePlanGenerator.checkTable(tableName);
        TablePlanGenerator.checkIndex(indexName);
        if (indexedFields == null) {
            throw new IllegalCommandException("Indexed fields cannot be null");
        }
        DeployTableMetadataPlan plan = new DeployTableMetadataPlan(idGen, TablePlanGenerator.makeName(planName, tableName, indexName), planner);
        tableName = plan.getRealTableName(tableName);
        try {
            plan.addTask(new StartAddIndex(plan, indexName, tableName, indexedFields, description));
            ParallelBundle bundle = new ParallelBundle();
            for (RepGroupId id : topology.getRepGroupIds()) {
                bundle.addTask(new WaitForAddIndex(plan, id, indexName, tableName));
            }
            if (!bundle.isEmpty()) {
                plan.addTask(bundle);
            }
            plan.addTask(new CompleteAddIndex(plan, indexName, tableName));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalCommandException("Failed to add index: " + iae.getMessage(), iae);
        }
        return plan;
    }

    static DeployTableMetadataPlan createRemoveIndexPlan(AtomicInteger idGen, String planName, BasicPlannerImpl planner, Topology topology, String indexName, String tableName) {
        TablePlanGenerator.checkTable(tableName);
        TablePlanGenerator.checkIndex(indexName);
        DeployTableMetadataPlan plan = new DeployTableMetadataPlan(idGen, TablePlanGenerator.makeName(planName, tableName, indexName), planner);
        tableName = plan.getRealTableName(tableName);
        try {
            plan.addTask(new RemoveIndex(plan, indexName, tableName));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalCommandException("Failed to remove index: " + iae.getMessage(), iae);
        }
        return plan;
    }

    private static void checkTable(String tableName) {
        if (tableName == null) {
            throw new IllegalCommandException("Table path cannot be null");
        }
    }

    private static void checkIndex(String indexName) {
        if (indexName == null) {
            throw new IllegalCommandException("Index name cannot be null");
        }
    }

    public static String makeName(String name, String tableName, String indexName) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(":");
        sb.append(tableName);
        if (indexName != null) {
            sb.append(":");
            sb.append(indexName);
        }
        return sb.toString();
    }
}

