/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.StopRepNode;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class StopRepNodesPlan
extends AbstractPlan {
    private static final long serialVersionUID = 1L;
    private Set<RepNodeId> repNodeIds;

    StopRepNodesPlan(AtomicInteger idGen, String name, Planner planner, Topology topology, Set<RepNodeId> rnids) {
        super(idGen, name, planner);
        this.repNodeIds = rnids;
        for (RepNodeId rnid : rnids) {
            RepNode rn = topology.get(rnid);
            if (rn == null) {
                throw new IllegalCommandException("There is no RepNode with id " + rnid + ". Please provide the id of an existing RepNode.");
            }
            this.addTask(new StopRepNode(this, rn.getStorageNodeId(), rnid, true));
        }
    }

    protected StopRepNodesPlan() {
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    public Set<RepNodeId> getRepNodeIds() {
        return this.repNodeIds;
    }

    @Override
    void preExecutionSave() {
    }

    @Override
    public String getDefaultName() {
        return "Stop RepNodes";
    }

    @Override
    void stripForDisplay() {
        this.repNodeIds = null;
    }
}

