/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.PlanExecutor;
import oracle.kv.impl.admin.plan.PlanRun;
import oracle.kv.impl.admin.plan.TaskRun;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.util.FormatUtils;

public class StatusReport {
    public static final int VERBOSE_BIT = 1;
    public static final int SHOW_FINISHED_BIT = 2;
    private final List<TaskRun> finished;
    private final List<TaskRun> running;
    private final List<Task> pending;
    private final boolean verbose;
    private final boolean showFinished;
    private final Plan plan;
    private final PlanRun planRun;
    private static String NUM_LABEL = "%-22s %-30d\n";
    static String STRING_LABEL = "%-22s %-30s\n";

    public StatusReport(Plan plan, long optionFlags) {
        this.plan = plan;
        this.planRun = plan.getExecutionState().getLatestPlanRun();
        this.finished = new ArrayList<TaskRun>();
        this.running = new ArrayList<TaskRun>();
        int nStarted = 0;
        if (this.planRun != null) {
            List<TaskRun> allStarted = this.planRun.getTaskRuns();
            nStarted = allStarted.size();
            for (TaskRun tRun : allStarted) {
                if (tRun.getState().equals((Object)Task.State.RUNNING)) {
                    this.running.add(tRun);
                    continue;
                }
                this.finished.add(tRun);
            }
        }
        this.pending = PlanExecutor.getFlatTaskList(plan, nStarted);
        this.verbose = (optionFlags & 1L) != 0L;
        this.showFinished = (optionFlags & 2L) != 0L;
    }

    public String display() {
        StringBuilder sb = new StringBuilder();
        Formatter fm = new Formatter(sb);
        if (this.planRun == null) {
            fm.format("Plan %s has not been started\n", this.plan.getName());
            return sb.toString();
        }
        fm.format("Plan %s\n", this.plan.getName());
        fm.format(STRING_LABEL, new Object[]{"State:", this.plan.getState()});
        fm.format(NUM_LABEL, "Attempt number:", this.planRun.getAttempt());
        fm.format(STRING_LABEL, "Started:", FormatUtils.formatDateAndTime(this.planRun.getStartTime()));
        if (this.planRun.getInterruptTime() != 0L) {
            fm.format(STRING_LABEL, "Interrupt requested:", FormatUtils.formatDateAndTime(this.planRun.getInterruptTime()));
        }
        if (this.planRun.getEndTime() != 0L) {
            fm.format(STRING_LABEL, "Ended:", FormatUtils.formatDateAndTime(this.planRun.getEndTime()));
            String failure = this.planRun.getFailureDescription(this.verbose);
            if (failure != null) {
                fm.format(STRING_LABEL, "Plan failures:", failure);
            }
        }
        int successCount = 0;
        int errorCount = 0;
        int interruptCount = 0;
        for (TaskRun tRun : this.finished) {
            if (tRun.getState() == Task.State.SUCCEEDED) {
                ++successCount;
                continue;
            }
            if (tRun.getState() == Task.State.ERROR) {
                ++errorCount;
                continue;
            }
            if (tRun.getState() != Task.State.INTERRUPTED) continue;
            ++interruptCount;
        }
        fm.format(NUM_LABEL, "Total tasks:", this.plan.getTotalTaskCount());
        if (successCount > 0) {
            fm.format(NUM_LABEL, " Successful:", successCount);
        }
        if (errorCount > 0) {
            fm.format(NUM_LABEL, " Failed:", errorCount);
        }
        if (interruptCount > 0) {
            fm.format(NUM_LABEL, " Interrupted:", interruptCount);
        }
        if (this.running.size() > 0) {
            fm.format(NUM_LABEL, " Incomplete:", this.running.size());
        }
        if (this.pending.size() > 0) {
            fm.format(NUM_LABEL, " Not started:", this.pending.size());
        }
        if (this.showFinished) {
            this.plan.describeFinished(fm, this.finished, errorCount, this.verbose);
        }
        if (this.running.size() > 0) {
            fm.format("Incomplete tasks\n", new Object[0]);
            this.plan.describeRunning(fm, this.running, this.verbose);
        }
        if (this.pending.size() > 0) {
            fm.format("Tasks not started\n", new Object[0]);
            this.plan.describeNotStarted(fm, this.pending, this.verbose);
        }
        return sb.toString();
    }
}

