/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.plan.MetadataPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.AddUser;
import oracle.kv.impl.admin.plan.task.ChangeUser;
import oracle.kv.impl.admin.plan.task.RemoveUser;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.PasswordHash;
import oracle.kv.impl.security.metadata.PasswordHashDigest;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.util.VersionUtil;

@Persistent
public class SecurityMetadataPlan
extends MetadataPlan<SecurityMetadata> {
    private static final long serialVersionUID = 1L;
    private static final SecureRandom random = new SecureRandom();
    private static final KVVersion SECURITY_VERSION = KVVersion.R3_0;

    public SecurityMetadataPlan(AtomicInteger idGen, String planName, Planner planner) {
        super(idGen, planName, planner);
        PlannerAdmin admin = planner.getAdmin();
        KVVersion storeVersion = admin.getStoreVersion();
        if (VersionUtil.compareMinorVersion(storeVersion, SECURITY_VERSION) < 0) {
            throw new IllegalCommandException("Cannot perform security metadata related operations when not all nodes in the store support security feature. The highest version supported by all nodes is " + storeVersion.getNumericVersionString() + ", but security metadata operations require version " + SECURITY_VERSION.getNumericVersionString() + " or later.");
        }
    }

    private SecurityMetadataPlan() {
    }

    private static void ensureNotSelfDrop(String droppedUserName) {
        KVStoreUserPrincipal currentUserPrincipal = KVStoreUserPrincipal.getCurrentUser();
        if (currentUserPrincipal == null) {
            throw new IllegalCommandException("Could not identify current user");
        }
        if (droppedUserName.equals(currentUserPrincipal.getName())) {
            throw new IllegalCommandException("A current online user cannot drop itself.");
        }
    }

    @Override
    protected Metadata.MetadataType getMetadataType() {
        return Metadata.MetadataType.SECURITY;
    }

    @Override
    protected Class<SecurityMetadata> getMetadataClass() {
        return SecurityMetadata.class;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    void preExecutionSave() {
    }

    @Override
    public String getDefaultName() {
        return "Change SecurityMetadata";
    }

    @Override
    public void getCatalogLocks() {
        this.planner.lockElasticity(this.getId(), this.getName());
        this.getPerTaskLocks();
    }

    public PasswordHashDigest makeDefaultHashDigest(char[] plainPassword) {
        byte[] saltValue = PasswordHash.generateSalt(random, 16);
        return PasswordHashDigest.getHashDigest("PBKDF2WithHmacSHA1", 5000, 16, saltValue, plainPassword);
    }

    public static SecurityMetadataPlan createCreateUserPlan(AtomicInteger idGen, String planName, Planner planner, String userName, boolean isEnabled, boolean isAdmin, char[] plainPassword) {
        String subPlanName = planName != null ? planName : "Create User";
        SecurityMetadataPlan plan = new SecurityMetadataPlan(idGen, subPlanName, planner);
        plan.addTask(new AddUser(plan, userName, isEnabled, isAdmin, plainPassword));
        return plan;
    }

    public static SecurityMetadataPlan createChangeUserPlan(AtomicInteger idGen, String planName, Planner planner, String userName, Boolean isEnabled, char[] plainPassword, boolean retainPassword, boolean clearRetainedPassword) {
        String subPlanName = planName != null ? planName : "Change User";
        SecurityMetadataPlan plan = new SecurityMetadataPlan(idGen, subPlanName, planner);
        plan.addTask(new ChangeUser(plan, userName, isEnabled, plainPassword, retainPassword, clearRetainedPassword));
        return plan;
    }

    public static SecurityMetadataPlan createDropUserPlan(AtomicInteger idGen, String planName, Planner planner, String userName) {
        SecurityMetadataPlan.ensureNotSelfDrop(userName);
        String subPlanName = planName != null ? planName : "Drop User";
        SecurityMetadataPlan plan = new SecurityMetadataPlan(idGen, subPlanName, planner);
        plan.addTask(new RemoveUser(plan, userName));
        return plan;
    }

    @Override
    void stripForDisplay() {
    }
}

