/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.DestroyAdmin;
import oracle.kv.impl.admin.plan.task.EnsureAdminNotMaster;
import oracle.kv.impl.admin.plan.task.NewAdminParameters;
import oracle.kv.impl.admin.plan.task.RemoveAdminRefs;
import oracle.kv.impl.admin.plan.task.UpdateAdminHelperHost;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.StorageNodeId;

@Persistent(version=0)
public class RemoveAdminPlan
extends AbstractPlan {
    private static final long serialVersionUID = 1L;
    @Deprecated
    AdminId victim;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RemoveAdminPlan(AtomicInteger idGen, String name, Planner planner, DatacenterId dcid, AdminId victim) {
        super(idGen, name, planner);
        PlannerAdmin admin = planner.getAdmin();
        Parameters parameters = admin.getCurrentParameters();
        Set<Object> victimIds = new HashSet<AdminId>();
        if (victim == null) {
            if (dcid == null) throw new IllegalArgumentException("null specified for both DatacenterId and AdminId parameters");
            victimIds = parameters.getAdminIds(dcid, admin.getCurrentTopology());
        } else {
            victimIds.add(victim);
        }
        for (AdminId adminId : victimIds) {
            AdminParams ap = parameters.get(adminId);
            StorageNodeId snid = ap.getStorageNodeId();
            this.addTask(new EnsureAdminNotMaster(this, adminId));
            this.addTask(new RemoveAdminRefs(this, adminId));
            for (AdminParams oap : parameters.getAdminParams()) {
                AdminId aid = oap.getAdminId();
                if (victimIds.contains(aid)) continue;
                StorageNodeParams osnp = parameters.get(oap.getStorageNodeId());
                String hostname = osnp.getHostname();
                int registryPort = osnp.getRegistryPort();
                this.addTask(new UpdateAdminHelperHost(this, aid));
                this.addTask(new NewAdminParameters(this, hostname, registryPort, aid));
            }
            this.addTask(new DestroyAdmin(this, snid, adminId));
        }
    }

    private RemoveAdminPlan() {
    }

    @Override
    public void preExecutionSave() {
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public String getDefaultName() {
        return "Remove Admin Replica";
    }

    @Override
    void stripForDisplay() {
    }
}

