/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.admin.plan.ExecutionListener;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.TaskRun;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.util.server.LoggerUtils;

public class PlanTracker
implements ExecutionListener {
    private final Logger logger;

    public PlanTracker(AdminServiceParams adminParams) {
        this.logger = LoggerUtils.getLogger(this.getClass(), adminParams);
    }

    private String header(Plan plan) {
        return plan + ":";
    }

    @Override
    public void planStart(Plan plan) {
        int numTasks = plan.getTotalTaskCount();
        this.logger.log(Level.INFO, "{0} started, {1} tasks", new Object[]{this.header(plan), numTasks});
    }

    @Override
    public void planEnd(Plan plan) {
        this.logger.log(Level.INFO, "{0} ended, state={1}", new Object[]{this.header(plan), plan.getState()});
    }

    @Override
    public void taskStart(Plan plan, Task task, int taskNum, int totalTasks) {
        this.logger.log(Level.INFO, "{0} task {1} [{2}] started", new Object[]{this.header(plan), taskNum, task});
    }

    @Override
    public void taskEnd(Plan plan, Task task, TaskRun taskRun, int taskNum, int totalTasks) {
        this.logger.log(Level.INFO, "{0} task {1} [{2}] ended, state={3}", new Object[]{this.header(plan), taskNum, task, taskRun.getState()});
    }
}

