/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.kv.impl.admin.plan.ExecutionState;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.TaskRun;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.util.FormatUtils;

@Persistent(version=1)
public class PlanRun
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Plan.State state;
    private List<TaskRun> taskRuns;
    private long startTime;
    private long interruptTime;
    private long endTime;
    private int attemptNumber;
    @Deprecated
    private ExecutionState.ExceptionTransfer transfer;
    private List<ExecutionState.ExceptionTransfer> transferList;
    private ExecutionState executionState;
    private transient AtomicInteger interruptedTasks;
    private transient AtomicInteger errorTasks;
    private transient AtomicInteger finishedTasks;
    private transient AtomicInteger taskNumCounter;
    private transient boolean interruptRequested;
    private transient boolean cleanupInterrupted;
    private transient boolean cleanupStarted;

    PlanRun(int attemptNumber, ExecutionState executionState) {
        this.startTime = System.currentTimeMillis();
        this.taskRuns = new ArrayList<TaskRun>();
        this.attemptNumber = attemptNumber;
        this.errorTasks = new AtomicInteger(0);
        this.interruptedTasks = new AtomicInteger(0);
        this.finishedTasks = new AtomicInteger(0);
        this.taskNumCounter = new AtomicInteger(0);
        this.executionState = executionState;
        this.state = Plan.State.APPROVED;
        this.transferList = new ArrayList<ExecutionState.ExceptionTransfer>();
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    PlanRun() {
    }

    boolean isTerminated() {
        return this.state.isTerminal();
    }

    void requestInterrupt() {
        if (this.interruptTime == 0L) {
            this.interruptTime = System.currentTimeMillis();
        }
        this.interruptRequested = true;
        if (this.cleanupStarted) {
            this.cleanupInterrupted = true;
        }
    }

    boolean isInterruptRequested() {
        return this.interruptRequested;
    }

    void setCleanupStarted() {
        this.cleanupStarted = true;
    }

    boolean cleanupInterrupted() {
        return this.cleanupInterrupted;
    }

    void setState(Planner planner, Plan plan, Plan.State newState, String msg) {
        this.state = this.executionState.changeState(planner, plan, this.state, newState, this.attemptNumber, msg);
    }

    void saveFailure(Throwable t, String problem, Logger logger) {
        this.transferList.add(new ExecutionState.ExceptionTransfer(t, problem));
        logger.severe("Plan [" + this.executionState.getPlanName() + "] failed. " + this);
    }

    Plan.State getState() {
        return this.state;
    }

    TaskRun startTask(Task task, Logger logger) {
        TaskRun run = new TaskRun(task, logger, this.taskNumCounter.incrementAndGet());
        this.taskRuns.add(run);
        return run;
    }

    void setEndTime() {
        long now = System.currentTimeMillis();
        if (now > this.endTime) {
            this.endTime = now;
        }
    }

    void incrementEndCount(Task.State tState) {
        this.finishedTasks.incrementAndGet();
        if (tState == Task.State.ERROR) {
            this.errorTasks.incrementAndGet();
        } else if (tState == Task.State.INTERRUPTED) {
            this.interruptedTasks.incrementAndGet();
        }
    }

    int getNumErrorTasks() {
        return this.errorTasks.get();
    }

    int getNumInterruptedTasks() {
        return this.interruptedTasks.get();
    }

    int getNumFinishedTasks() {
        return this.finishedTasks.get();
    }

    ExecutionState.ExceptionTransfer getExceptionTransfer() {
        if (this.transferList.size() > 0 && this.transferList.get(0) != null) {
            return this.transferList.get(0);
        }
        for (TaskRun oneTask : this.taskRuns) {
            if (oneTask.getTransfer() == null) continue;
            return oneTask.getTransfer();
        }
        return null;
    }

    public String getFailureDescription(boolean verbose) {
        if (this.transferList.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (ExecutionState.ExceptionTransfer et : this.transferList) {
            sb.append("\n\tFailure ").append(i).append(": ");
            sb.append(et.getDescription());
            if (verbose && et.getStackTrace() != null) {
                sb.append("\n").append(et.getStackTrace());
            }
            ++i;
        }
        return sb.toString();
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public String toString() {
        String ret = "Attempt " + this.attemptNumber + " [" + (Object)((Object)this.state) + "] start=" + FormatUtils.formatDateAndTime(this.startTime) + " end=" + FormatUtils.formatDateAndTime(this.endTime);
        String failure = this.getFailureDescription(true);
        if (failure != null) {
            ret = ret + " " + failure;
        }
        return ret;
    }

    void upgradeToV3(List<Task> tasks) {
        if (this.transferList == null) {
            this.transferList = new ArrayList<ExecutionState.ExceptionTransfer>();
        }
        if (this.transfer != null) {
            this.transferList.add(this.transfer);
        }
        int tasknum = 0;
        for (TaskRun oneTask : this.taskRuns) {
            oneTask.upgradeToV3(++tasknum, tasks.get(tasknum - 1));
        }
    }

    int getAttempt() {
        return this.attemptNumber;
    }

    long getInterruptTime() {
        return this.interruptTime;
    }

    List<TaskRun> getTaskRuns() {
        return this.taskRuns;
    }
}

