/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityStore;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.PlanWaiter;
import oracle.kv.impl.admin.plan.ExecutionState;
import oracle.kv.impl.admin.plan.PlanRun;
import oracle.kv.impl.admin.plan.TaskRun;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.TaskList;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.metadata.Metadata;

public interface Plan {
    public static final String NO_NAME = "none";

    public int getId();

    public boolean isExclusive();

    public State getState();

    public void addTask(Task var1);

    public TaskList getTaskList();

    public String getName();

    public String getDefaultName();

    public void persist(EntityStore var1, Transaction var2);

    public String getLatestRunFailureDescription();

    public PlanRun addWaiter(PlanWaiter var1);

    public void removeWaiter(PlanWaiter var1);

    public Date getCreateTime();

    public Date getStartTime();

    public Date getEndTime();

    public void markAsInterrupted();

    public String showRuns();

    public ExecutionState getExecutionState();

    public int getTotalTaskCount();

    public void describeFinished(Formatter var1, List<TaskRun> var2, int var3, boolean var4);

    public void describeRunning(Formatter var1, List<TaskRun> var2, boolean var3);

    public void describeNotStarted(Formatter var1, List<Task> var2, boolean var3);

    public void getCatalogLocks();

    public void preExecuteCheck(boolean var1, Logger var2);

    public void saveFailure(PlanRun var1, Throwable var2, String var3, Logger var4);

    public ExecutionState.ExceptionTransfer getLatestRunExceptionTransfer();

    public boolean updatingMetadata(Metadata<?> var1);

    public static enum State {
        PENDING(false),
        APPROVED(false),
        CANCELED(true),
        RUNNING(false),
        INTERRUPTED(false),
        SUCCEEDED(true),
        ERROR(false),
        INTERRUPT_REQUESTED(false);

        private final boolean isTerminal;

        private State(boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        public static void validateTransition(State oldState, State nextState) {
            if (!oldState.checkTransition(nextState)) {
                throw new IllegalCommandException("Plan cannot transition from " + (Object)((Object)oldState) + " to " + (Object)((Object)nextState));
            }
        }

        boolean checkTransition(State nextState) {
            boolean isValid = false;
            switch (this) {
                case PENDING: {
                    if (nextState != APPROVED && nextState != CANCELED) break;
                    isValid = true;
                    break;
                }
                case APPROVED: {
                    if (nextState != CANCELED && nextState != RUNNING && nextState != APPROVED) break;
                    isValid = true;
                    break;
                }
                case CANCELED: {
                    break;
                }
                case RUNNING: {
                    if (nextState != SUCCEEDED && nextState != ERROR && nextState != INTERRUPT_REQUESTED) break;
                    isValid = true;
                    break;
                }
                case SUCCEEDED: {
                    break;
                }
                case ERROR: 
                case INTERRUPTED: {
                    if (nextState != RUNNING && nextState != CANCELED) break;
                    isValid = true;
                    break;
                }
                case INTERRUPT_REQUESTED: {
                    if (nextState != ERROR && nextState != INTERRUPTED) break;
                    isValid = true;
                    break;
                }
                default: {
                    throw new OperationFaultException("Plan state transition for " + (Object)((Object)this) + " not defined. Attempting to transition to " + (Object)((Object)nextState));
                }
            }
            return isValid;
        }

        public boolean isTerminal() {
            return this.isTerminal;
        }

        public String getWaitMessage(int planId) {
            switch (this) {
                case PENDING: {
                    return "Plan " + planId + " is pending.";
                }
                case APPROVED: {
                    return "Plan " + planId + " is approved, please execute.";
                }
                case CANCELED: {
                    return "Plan " + planId + " has been canceled";
                }
                case RUNNING: {
                    return "Plan " + planId + " is running";
                }
                case SUCCEEDED: {
                    return "Plan " + planId + " ended successfully";
                }
                case ERROR: {
                    return "Plan " + planId + " ended with errors." + " Use \"show plan -id " + planId + "\" for more information";
                }
                case INTERRUPTED: {
                    return "Plan " + planId + " has been interrupted. Please " + "cancel or retry the plan.";
                }
                case INTERRUPT_REQUESTED: {
                    return "Plan " + planId + " is processing a request " + "to interrupt the plan. Use \"show plan -id " + planId + "\" for more information";
                }
            }
            throw new OperationFaultException("Message for " + (Object)((Object)this) + " not defined.");
        }

        boolean planExecutionFinished() {
            switch (this) {
                case PENDING: 
                case APPROVED: 
                case RUNNING: 
                case INTERRUPT_REQUESTED: {
                    return false;
                }
                case CANCELED: 
                case SUCCEEDED: 
                case ERROR: 
                case INTERRUPTED: {
                    return true;
                }
            }
            return false;
        }

        boolean approvedAndCanExecute() {
            switch (this) {
                case APPROVED: 
                case RUNNING: 
                case ERROR: 
                case INTERRUPTED: 
                case INTERRUPT_REQUESTED: {
                    return true;
                }
            }
            return false;
        }
    }
}

