/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.TopologyPlan;
import oracle.kv.impl.admin.plan.task.ChangeServiceAddresses;
import oracle.kv.impl.admin.plan.task.ConfirmSNStatus;
import oracle.kv.impl.admin.plan.task.DeployAdmin;
import oracle.kv.impl.admin.plan.task.DeployMultipleRNs;
import oracle.kv.impl.admin.plan.task.MigrateParamsAndTopo;
import oracle.kv.impl.admin.plan.task.NewAdminParameters;
import oracle.kv.impl.admin.plan.task.NewRepNodeParameters;
import oracle.kv.impl.admin.plan.task.UpdateAdminHelperHost;
import oracle.kv.impl.admin.plan.task.UpdateHelperHost;
import oracle.kv.impl.admin.plan.task.VerifyBeforeMigrate;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class MigrateSNPlan
extends TopologyPlan {
    private static final long serialVersionUID = 1L;
    private AdminId foundAdminId;
    StorageNodeId oldNode;
    StorageNodeId newNode;
    int httpPort;

    public MigrateSNPlan(AtomicInteger idGen, String name, Planner planner, Topology topology, StorageNodeId oldNode, StorageNodeId newNode, int httpPort) {
        super(idGen, name, planner, topology);
        this.oldNode = oldNode;
        this.newNode = newNode;
        this.httpPort = httpPort;
        this.addTask(new VerifyBeforeMigrate(this, oldNode, newNode));
        this.validate(topology, oldNode, newNode);
        this.addTask(new ConfirmSNStatus(this, newNode, true, "Please ensure that " + newNode + " is deployed and running before " + "attempting a node migration."));
        this.addTask(new ConfirmSNStatus(this, oldNode, false, "Please ensure that " + oldNode + " is stopped before attempting a node " + "migration."));
        this.addTask(new MigrateParamsAndTopo(this, oldNode, newNode, httpPort));
        this.addTask(new ChangeServiceAddresses(this, oldNode, newNode));
        if (this.foundAdminId != null) {
            this.addTask(new DeployAdmin(this, newNode, this.foundAdminId));
        }
        this.addTask(new DeployMultipleRNs(this, newNode));
        HashSet<RepGroup> affectedRGs = new HashSet<RepGroup>();
        block0: for (RepGroup rg : topology.getRepGroupMap().getAll()) {
            for (RepNode rn : rg.getRepNodes()) {
                if (!rn.getStorageNodeId().equals(oldNode)) continue;
                affectedRGs.add(rg);
                continue block0;
            }
        }
        for (RepGroup rg : affectedRGs) {
            for (RepNode rn : rg.getRepNodes()) {
                if (rn.getStorageNodeId().equals(oldNode)) continue;
                this.addTask(new UpdateHelperHost(this, (RepNodeId)rn.getResourceId(), (RepGroupId)rg.getResourceId()));
                this.addTask(new NewRepNodeParameters(this, (RepNodeId)rn.getResourceId()));
            }
        }
        if (this.foundAdminId != null) {
            PlannerAdmin admin = planner.getAdmin();
            Parameters parameters = admin.getCurrentParameters();
            for (AdminParams ap : parameters.getAdminParams()) {
                AdminId aid = ap.getAdminId();
                if (aid.equals(this.foundAdminId)) continue;
                StorageNodeParams snp = parameters.get(ap.getStorageNodeId());
                String hostname = snp.getHostname();
                int registryPort = snp.getRegistryPort();
                this.addTask(new UpdateAdminHelperHost(this, aid));
                this.addTask(new NewAdminParameters(this, hostname, registryPort, aid));
            }
        }
    }

    private void validate(Topology topology, StorageNodeId oldNode1, StorageNodeId newNode1) {
        Datacenter newDC;
        Parameters parameters = this.planner.getAdmin().getCurrentParameters();
        if (topology.get(oldNode1) == null) {
            throw new IllegalCommandException(oldNode1 + " does not exist in the topology and cannot " + "be migrated");
        }
        if (parameters.get(oldNode1) == null) {
            throw new IllegalCommandException(oldNode1 + " does not exist in the parameters and cannot " + "be migrated");
        }
        if (topology.get(newNode1) == null) {
            throw new IllegalCommandException(newNode1 + " is not in the topology and must be deployed " + "before migrating " + oldNode1);
        }
        if (parameters.get(newNode1) == null) {
            throw new IllegalCommandException(newNode1 + " is not in the parameters and must be deployed " + "before migrating " + oldNode1);
        }
        boolean oldNodeAdminsExist = false;
        boolean newNodeAdminsExist = false;
        boolean oldNodeRNsExist = false;
        boolean newNodeRNsExist = false;
        for (AdminParams ap : parameters.getAdminParams()) {
            if (ap.getStorageNodeId().equals(oldNode1)) {
                oldNodeAdminsExist = true;
                this.foundAdminId = ap.getAdminId();
            }
            if (!ap.getStorageNodeId().equals(newNode1)) continue;
            newNodeAdminsExist = true;
            this.foundAdminId = ap.getAdminId();
        }
        for (RepNodeParams rnp : parameters.getRepNodeParams()) {
            if (rnp.getStorageNodeId().equals(oldNode1)) {
                oldNodeRNsExist = true;
            }
            if (!rnp.getStorageNodeId().equals(newNode1)) continue;
            newNodeRNsExist = true;
        }
        if (oldNodeRNsExist && newNodeRNsExist) {
            throw new IllegalCommandException("Cannot migrate services from " + oldNode1 + " to " + newNode1 + " because " + newNode1 + " is already in use");
        }
        if (oldNodeAdminsExist && newNodeAdminsExist) {
            throw new IllegalCommandException("Cannot migrate services from " + oldNode1 + " to " + newNode1 + " because " + newNode1 + " is already in use");
        }
        if (!(oldNodeAdminsExist || oldNodeRNsExist || newNodeAdminsExist || newNodeRNsExist)) {
            throw new IllegalCommandException("No services on " + oldNode1 + " or " + newNode1 + ", nothing to migrate");
        }
        Datacenter oldDC = topology.getDatacenter(oldNode1);
        if (!oldDC.equals(newDC = topology.getDatacenter(newNode1))) {
            throw new IllegalCommandException("Cannot migrate services from " + oldNode1 + " to " + newNode1 + " because they belong to different zones." + " Node " + oldNode1 + " belongs to zone: " + oldDC + ". Node " + newNode1 + " belongs to zone: " + newDC + ".");
        }
    }

    private MigrateSNPlan() {
    }

    public StorageNodeId getOldNode() {
        return this.oldNode;
    }

    public StorageNodeId getNewNode() {
        return this.newNode;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    @Override
    void preExecutionSave() {
    }

    @Override
    public String getDefaultName() {
        return "Migrate Storage Node";
    }
}

