/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import oracle.kv.impl.admin.plan.AbstractPlan;

public class DeploymentInfo {
    private long deployStartTime;
    private final String planName;
    private final int planId;
    private final String candidateName;

    public static DeploymentInfo makeDeploymentInfo(AbstractPlan plan, String candidateName) {
        DeploymentInfo info = new DeploymentInfo(plan.getName(), plan.getId(), candidateName);
        long validatedTime = plan.getAdmin().validateStartTime(info.getDeployStartTime());
        info.setDeployStartTime(validatedTime);
        return info;
    }

    public static DeploymentInfo makeStartupDeploymentInfo() {
        return new DeploymentInfo("none", 0, "none");
    }

    private DeploymentInfo(String planName, int planId, String candidateName) {
        this.planName = planName;
        this.planId = planId;
        this.candidateName = candidateName;
        this.deployStartTime = System.currentTimeMillis();
    }

    public long getDeployStartTime() {
        return this.deployStartTime;
    }

    public void setDeployStartTime(long validatedTime) {
        this.deployStartTime = validatedTime;
    }

    public String getPlanName() {
        return this.planName;
    }

    public int getPlanId() {
        return this.planId;
    }

    public String getCandidateName() {
        return this.candidateName;
    }
}

