/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.plan.MetadataPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.metadata.Metadata;

@Persistent
public class DeployTableMetadataPlan
extends MetadataPlan<TableMetadata> {
    private static final long serialVersionUID = 1L;

    DeployTableMetadataPlan(AtomicInteger idGen, String planName, Planner planner) {
        super(idGen, planName, planner);
    }

    private DeployTableMetadataPlan() {
    }

    @Override
    protected Class<TableMetadata> getMetadataClass() {
        return TableMetadata.class;
    }

    @Override
    public Metadata.MetadataType getMetadataType() {
        return Metadata.MetadataType.TABLE;
    }

    @Override
    public void preExecutionSave() {
    }

    @Override
    public String getDefaultName() {
        return "Deploy Table Metadata";
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public void getCatalogLocks() {
        this.planner.lockElasticity(this.getId(), this.getName());
        this.getPerTaskLocks();
    }

    @Override
    void stripForDisplay() {
    }

    String getRealTableName(String tableName) {
        TableImpl table;
        TableMetadata md = (TableMetadata)this.getMetadata();
        if (md != null && (table = md.getTable(tableName, false)) != null) {
            return table.getFullName();
        }
        return tableName;
    }
}

