/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.DeployAdmin;
import oracle.kv.impl.admin.plan.task.NewAdminParameters;
import oracle.kv.impl.admin.plan.task.UpdateAdminHelperHost;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;

@Persistent(version=1)
public class DeployAdminPlan
extends AbstractPlan {
    private static final long serialVersionUID = 1L;
    private int httpPort;
    AdminParams targetAP;

    public DeployAdminPlan(AtomicInteger idGen, String name, Planner planner, StorageNodeId snid, int httpPort) {
        super(idGen, name, planner);
        PlannerAdmin admin = planner.getAdmin();
        this.httpPort = httpPort;
        StorageNode sn = admin.getCurrentTopology().get(snid);
        if (sn == null) {
            throw new IllegalCommandException(snid + " is not a valid Storage Node id.  " + "Please provide the id of an existing Storage Node.");
        }
        this.targetAP = this.findExistingParams(admin, snid);
        AdminId newAdminId = null;
        if (this.targetAP == null) {
            newAdminId = admin.generateAdminId();
            ParameterMap pMap = admin.copyPolicy();
            this.targetAP = new AdminParams(pMap, newAdminId, snid, httpPort);
            this.removeSomePolicyParams(this.targetAP.getMap());
        } else {
            newAdminId = this.targetAP.getAdminId();
        }
        this.addTask(new DeployAdmin(this, snid, newAdminId));
        Parameters parameters = admin.getCurrentParameters();
        for (AdminParams ap : parameters.getAdminParams()) {
            AdminId aid = ap.getAdminId();
            StorageNodeParams snp = parameters.get(ap.getStorageNodeId());
            String hostname = snp.getHostname();
            int registryPort = snp.getRegistryPort();
            this.addTask(new UpdateAdminHelperHost(this, aid));
            this.addTask(new NewAdminParameters(this, hostname, registryPort, aid));
        }
    }

    private AdminParams findExistingParams(PlannerAdmin admin, StorageNodeId snid) {
        Parameters parameters = admin.getCurrentParameters();
        AdminParams existingAP = null;
        for (AdminId aid : parameters.getAdminIds()) {
            AdminParams ap = parameters.get(aid);
            if (!snid.equals(ap.getStorageNodeId())) continue;
            if (existingAP != null) {
                throw new NonfatalAssertionException("More than one admin service exists on " + snid + ". " + existingAP.getAdminId() + "[" + existingAP.getHttpPort() + "] and " + ap.getAdminId() + " [" + ap.getHttpPort() + "]");
            }
            if (this.httpPort != ap.getHttpPort()) {
                throw new IllegalCommandException(ap.getAdminId() + " is already configured with " + "httpPort" + ap.getHttpPort() + " and cannot be " + "configured for " + this.httpPort);
            }
            existingAP = ap;
        }
        return existingAP;
    }

    private void removeSomePolicyParams(ParameterMap map) {
        map.remove("cacheSize");
        map.remove("configProperties");
        map.remove("javaMiscParams");
    }

    private DeployAdminPlan() {
    }

    @Override
    public void preExecutionSave() {
        PlannerAdmin admin = this.getAdmin();
        Parameters p = admin.getCurrentParameters();
        if (p.get(this.targetAP.getAdminId()) == null) {
            admin.addAdminParams(this.targetAP);
        }
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public String getDefaultName() {
        return "Deploy Admin Service";
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    @Override
    void stripForDisplay() {
        this.targetAP = null;
    }
}

