/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.NewRepNodeParameters;
import oracle.kv.impl.admin.plan.task.StartRepNode;
import oracle.kv.impl.admin.plan.task.StopRepNode;
import oracle.kv.impl.admin.plan.task.WaitForRepNodeState;
import oracle.kv.impl.admin.plan.task.WriteNewParams;
import oracle.kv.impl.admin.plan.task.WriteNewSNParams;
import oracle.kv.impl.mgmt.MgmtUtil;
import oracle.kv.impl.param.Parameter;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.ConfigurableService;

@Persistent
public class ChangeSNParamsPlan
extends AbstractPlan {
    private static final long serialVersionUID = 1L;
    protected ParameterMap newParams;

    public ChangeSNParamsPlan(AtomicInteger idGenerator, String name, Planner planner, StorageNodeId snId, ParameterMap newParams) {
        super(idGenerator, name, planner);
        this.newParams = newParams;
        newParams.setParameter("storageNodeId", Integer.toString(snId.getStorageNodeId()));
        this.validateParams(planner, snId);
        this.addTask(new WriteNewSNParams(this, snId, newParams));
        if (newParams.exists("memoryMB") || newParams.exists("rnHeapPercent") || newParams.exists("capacity") || newParams.exists("numCPUs")) {
            this.updateRNParams(snId, newParams);
        }
    }

    protected ChangeSNParamsPlan() {
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    void preExecutionSave() {
    }

    @Override
    public String getDefaultName() {
        return "Change Storage Node Params";
    }

    private void validateParams(Planner p, StorageNodeId snId) {
        PlannerAdmin admin;
        Parameters parameters;
        String error;
        if (this.newParams.getName().equals("mountPoints") && (error = StorageNodeParams.validateMountMap(this.newParams, parameters = (admin = p.getAdmin()).getCurrentParameters(), snId)) != null) {
            throw new IllegalArgumentException(error);
        }
        if (this.newParams.getName().equals("storageNodeParams")) {
            String error2 = ChangeSNParamsPlan.validateMgmtParams(this.newParams);
            if (error2 != null) {
                throw new IllegalArgumentException(error2);
            }
            new StorageNodeParams(this.newParams).validate();
        }
    }

    public static String validateMgmtParams(ParameterMap aParams) {
        Parameter pollPort;
        if (!aParams.exists("mgmtClass")) {
            return null;
        }
        Parameter mgmtClass = aParams.get("mgmtClass");
        if (!MgmtUtil.verifyImplClassName(mgmtClass.asString())) {
            return "The given value " + mgmtClass.asString() + " is not allowed for the parameter " + mgmtClass.getName();
        }
        if ("oracle.kv.impl.mgmt.snmp.SnmpAgent".equals(mgmtClass.asString()) && ((pollPort = aParams.get("mgmtPollPort")) == null || pollPort.asInt() == 0)) {
            return "The parameter mgmtPollPort must be given when choosing snmp monitoring.";
        }
        return null;
    }

    public StorageNodeParams getNewParams() {
        return new StorageNodeParams(this.newParams);
    }

    private void updateRNParams(StorageNodeId snId, ParameterMap newMap) {
        PlannerAdmin admin = this.planner.getAdmin();
        StorageNodeParams snp = admin.getStorageNodeParams(snId);
        ParameterMap policyMap = admin.getCurrentParameters().copyPolicies();
        int capacity = snp.getCapacity();
        if (newMap.exists("capacity")) {
            capacity = newMap.get("capacity").asInt();
        }
        int numHostedRNs = admin.getCurrentTopology().getHostedRepNodeIds(snId).size();
        int rnHeapPercent = snp.getRNHeapPercent();
        if (newMap.exists("rnHeapPercent")) {
            rnHeapPercent = newMap.get("rnHeapPercent").asInt();
        }
        int memoryMB = snp.getMemoryMB();
        if (newMap.exists("memoryMB")) {
            memoryMB = newMap.get("memoryMB").asInt();
        }
        int numCPUs = snp.getNumCPUs();
        if (newMap.exists("numCPUs")) {
            numCPUs = newMap.get("numCPUs").asInt();
        }
        int gcThreads = StorageNodeParams.calcGCThreads(numCPUs, capacity, snp.getGCThreadFloor(), snp.getGCThreadThreshold(), snp.getGCThreadPercent());
        for (RepNodeParams rnp : admin.getCurrentParameters().getRepNodeParams()) {
            String oldGc;
            if (!rnp.getStorageNodeId().equals(snId)) continue;
            StorageNodeParams.RNHeapAndCacheSize heapAndCache = StorageNodeParams.calculateRNHeapAndCache(policyMap, capacity, numHostedRNs, memoryMB, rnHeapPercent, rnp.getRNCachePercent());
            ParameterMap rnMap = new ParameterMap("repNodeParams", "repNodeParams");
            String currentJavaMisc = rnp.getJavaMiscParams();
            if (rnp.getMaxHeapMB() != heapAndCache.getHeapMB()) {
                currentJavaMisc = rnp.replaceOrRemoveJVMArg(currentJavaMisc, "-Xms", heapAndCache.getHeapValAndUnit());
                currentJavaMisc = rnp.replaceOrRemoveJVMArg(currentJavaMisc, "-Xmx", heapAndCache.getHeapValAndUnit());
                rnMap.setParameter("javaMiscParams", currentJavaMisc);
            }
            if (rnp.getJECacheSize() != heapAndCache.getCacheBytes()) {
                rnMap.setParameter("cacheSize", Long.toString(heapAndCache.getCacheBytes()));
            }
            if (gcThreads != 0 && (oldGc = RepNodeParams.parseJVMArgsForPrefix("-XX:ParallelGCThreads=", currentJavaMisc)) != null && Integer.parseInt(oldGc) != gcThreads) {
                currentJavaMisc = rnp.replaceOrRemoveJVMArg(currentJavaMisc, "-XX:ParallelGCThreads=", Integer.toString(gcThreads));
                rnMap.setParameter("javaMiscParams", currentJavaMisc);
            }
            if (rnMap.size() == 0) continue;
            RepNodeId rnId = rnp.getRepNodeId();
            this.addTask(new WriteNewParams(this, rnMap, rnId, snId, true));
            if (rnMap.hasRestartRequired()) {
                this.addTask(new StopRepNode(this, snId, rnId, false));
                this.addTask(new StartRepNode(this, snId, rnId, false));
                this.addTask(new WaitForRepNodeState(this, rnId, ConfigurableService.ServiceStatus.RUNNING));
                continue;
            }
            this.addTask(new NewRepNodeParameters(this, rnp.getRepNodeId()));
        }
    }

    @Override
    void stripForDisplay() {
        this.newParams = null;
    }
}

