/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.NewRepNodeParameters;
import oracle.kv.impl.admin.plan.task.StartRepNode;
import oracle.kv.impl.admin.plan.task.StopRepNode;
import oracle.kv.impl.admin.plan.task.WaitForRepNodeState;
import oracle.kv.impl.admin.plan.task.WriteNewParams;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterUtils;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigurableService;

@Persistent
public class ChangeParamsPlan
extends AbstractPlan {
    private static final long serialVersionUID = 1L;
    protected ParameterMap newParams;

    public ChangeParamsPlan(AtomicInteger idGenerator, String name, Planner planner, Topology topology, Set<RepNodeId> rnids, ParameterMap map) {
        super(idGenerator, name, planner);
        this.newParams = map;
        this.validateParams(this.newParams);
        HashSet<RepNodeId> restartIds = new HashSet<RepNodeId>();
        for (RepNodeId rnid : rnids) {
            StorageNodeId snid = topology.get(rnid).getStorageNodeId();
            ParameterMap filtered = this.newParams.readOnlyFilter();
            this.addTask(new WriteNewParams(this, filtered, rnid, snid, false));
            RepNodeParams current = planner.getAdmin().getRepNodeParams(rnid);
            if (filtered.hasRestartRequiredDiff(current.getMap())) {
                restartIds.add(rnid);
                continue;
            }
            this.addTask(new NewRepNodeParameters(this, rnid));
        }
        if (!restartIds.isEmpty()) {
            List<RepNodeId> restart = this.sort(restartIds, topology);
            for (RepNodeId rnid : restart) {
                StorageNodeId snid = topology.get(rnid).getStorageNodeId();
                this.addTask(new StopRepNode(this, snid, rnid, false));
                this.addTask(new StartRepNode(this, snid, rnid, false));
                this.addTask(new WaitForRepNodeState(this, rnid, ConfigurableService.ServiceStatus.RUNNING));
            }
        }
    }

    protected List<RepNodeId> sort(Set<RepNodeId> ids, Topology topology) {
        ArrayList<RepNodeId> list = new ArrayList<RepNodeId>();
        for (RepNodeId id : ids) {
            list.add(id);
        }
        return list;
    }

    protected void validateParams(ParameterMap map) {
        ParameterUtils.validateParams(map);
    }

    protected ChangeParamsPlan() {
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    void preExecutionSave() {
    }

    @Override
    public String getDefaultName() {
        return "Change RepNode Params";
    }

    public RepNodeParams getNewParams() {
        return new RepNodeParams(this.newParams);
    }

    @Override
    void stripForDisplay() {
        this.newParams = null;
    }
}

