/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import com.sleepycat.persist.model.Persistent;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.task.NewAdminParameters;
import oracle.kv.impl.admin.plan.task.StartAdmin;
import oracle.kv.impl.admin.plan.task.StopAdmin;
import oracle.kv.impl.admin.plan.task.WaitForAdminState;
import oracle.kv.impl.admin.plan.task.WriteNewAdminParams;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterUtils;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigurableService;

@Persistent
public class ChangeAdminParamsPlan
extends AbstractPlan {
    private static final long serialVersionUID = 1L;
    private ParameterMap newParams;
    private transient Set<AdminId> needsAction = new HashSet<AdminId>();

    public ChangeAdminParamsPlan(AtomicInteger idGenerator, String name, Planner planner, AdminId givenId, ParameterMap map) {
        this(idGenerator, name, planner, givenId, null, null, map);
    }

    public ChangeAdminParamsPlan(AtomicInteger idGenerator, String name, Planner planner, AdminId givenId, DatacenterId dcid, Topology topology, ParameterMap map) {
        super(idGenerator, name, planner);
        Set<Object> allAdmins;
        this.newParams = map;
        this.validateParams(this.newParams);
        PlannerAdmin admin = planner.getAdmin();
        Parameters parameters = admin.getCurrentParameters();
        if (givenId == null) {
            allAdmins = parameters.getAdminIds(dcid, topology);
        } else {
            allAdmins = new HashSet();
            allAdmins.add(givenId);
        }
        HashSet<AdminId> restartIds = new HashSet<AdminId>();
        ParameterMap filtered = this.newParams.readOnlyFilter();
        for (AdminId adminId : allAdmins) {
            AdminParams current = parameters.get(adminId);
            StorageNodeId snid = current.getStorageNodeId();
            StorageNodeParams snp = parameters.get(snid);
            String hostname = snp.getHostname();
            int registryPort = snp.getRegistryPort();
            this.addTask(new WriteNewAdminParams(this, filtered, adminId, snid));
            if (filtered.hasRestartRequiredDiff(current.getMap())) {
                restartIds.add(adminId);
                continue;
            }
            this.addTask(new NewAdminParameters(this, hostname, registryPort, adminId));
        }
        if (!restartIds.isEmpty()) {
            boolean bl;
            AdminId self = admin.getParams().getAdminParams().getAdminId();
            boolean bl2 = false;
            for (AdminId aid : restartIds) {
                if (aid.equals(self)) {
                    bl = true;
                    continue;
                }
                this.addRestartTasks(aid, parameters);
            }
            if (bl) {
                this.addRestartTasks(self, parameters);
            }
        }
    }

    private void addRestartTasks(AdminId aid, Parameters parameters) {
        AdminParams current = parameters.get(aid);
        StorageNodeId snid = current.getStorageNodeId();
        this.addTask(new StopAdmin(this, snid, aid, false));
        this.addTask(new StartAdmin(this, snid, aid, false));
        this.addTask(new WaitForAdminState(this, snid, aid, ConfigurableService.ServiceStatus.RUNNING));
    }

    ChangeAdminParamsPlan() {
    }

    private void validateParams(ParameterMap map) {
        ParameterUtils.validateParams(map);
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public void preExecutionSave() {
    }

    @Override
    public String getDefaultName() {
        return "Change Admin Params";
    }

    public AdminParams getNewParams() {
        return new AdminParams(this.newParams);
    }

    public Set<AdminId> getNeedsActionSet() {
        return this.needsAction;
    }

    public void interrupt() {
        this.planner.interruptPlan(this.getId());
    }

    @Override
    void stripForDisplay() {
        this.newParams = null;
    }
}

