/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.ChangeAdminParamsPlan;
import oracle.kv.impl.admin.plan.ChangeAllParamsPlan;
import oracle.kv.impl.admin.plan.ChangeGlobalSecurityParamsPlan;
import oracle.kv.impl.admin.plan.ChangeParamsPlan;
import oracle.kv.impl.admin.plan.ChangeSNParamsPlan;
import oracle.kv.impl.admin.plan.DeployAdminPlan;
import oracle.kv.impl.admin.plan.DeployDatacenterPlan;
import oracle.kv.impl.admin.plan.DeploySNPlan;
import oracle.kv.impl.admin.plan.DeployTableMetadataPlan;
import oracle.kv.impl.admin.plan.DeployTopoPlan;
import oracle.kv.impl.admin.plan.MigrateSNPlan;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.PlanExecutor;
import oracle.kv.impl.admin.plan.PlanRun;
import oracle.kv.impl.admin.plan.Planner;
import oracle.kv.impl.admin.plan.RemoveAdminPlan;
import oracle.kv.impl.admin.plan.RemoveDatacenterPlan;
import oracle.kv.impl.admin.plan.RemoveSNPlan;
import oracle.kv.impl.admin.plan.RepairPlan;
import oracle.kv.impl.admin.plan.SecurityMetadataPlan;
import oracle.kv.impl.admin.plan.StartAllRepNodesPlan;
import oracle.kv.impl.admin.plan.StartRepNodesPlan;
import oracle.kv.impl.admin.plan.StopAllRepNodesPlan;
import oracle.kv.impl.admin.plan.StopRepNodesPlan;
import oracle.kv.impl.admin.plan.TablePlanGenerator;
import oracle.kv.impl.admin.topo.TopologyCandidate;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.server.LoggerUtils;

public class BasicPlannerImpl
implements Planner {
    private final ExecutorService executor;
    private final Logger logger;
    private final PlannerAdmin plannerAdmin;
    private final AtomicInteger planIdGenerator;
    private final Catalog catalog;

    public BasicPlannerImpl(PlannerAdmin plannerAdmin, AdminServiceParams params, int nextPlanId) {
        this.plannerAdmin = plannerAdmin;
        this.logger = LoggerUtils.getLogger(this.getClass(), params);
        this.executor = Executors.newCachedThreadPool(new KVThreadFactory("Planner", this.logger));
        this.catalog = new Catalog();
        this.planIdGenerator = new AtomicInteger(nextPlanId);
    }

    public Plan recover(Plan inProgressPlan) {
        if (inProgressPlan == null) {
            return null;
        }
        Plan restart = null;
        Plan.State originalState = inProgressPlan.getState();
        if (inProgressPlan.getState() == Plan.State.RUNNING) {
            inProgressPlan.markAsInterrupted();
            restart = inProgressPlan;
        }
        if (inProgressPlan.getState() == Plan.State.INTERRUPT_REQUESTED) {
            inProgressPlan.markAsInterrupted();
        }
        this.logger.log(Level.INFO, "{0} originally in {1}, transitioned to {2}, {3} be restarted automatically", new Object[]{inProgressPlan, originalState, inProgressPlan.getState(), restart == null ? "will not" : "will"});
        this.catalog.addNewPlan(inProgressPlan);
        this.plannerAdmin.savePlan(inProgressPlan, "Plan Recovery");
        return restart;
    }

    public void register(Plan plan) {
        this.catalog.addNewPlan(plan);
    }

    @Override
    public void clearLocks(int planId) {
        this.catalog.clearLocks(planId);
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    @Override
    public synchronized DeployDatacenterPlan createDeployDatacenterPlan(String planName, String datacenterName, int repFactor, DatacenterType datacenterType) {
        DeployDatacenterPlan plan = new DeployDatacenterPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), datacenterName, repFactor, datacenterType);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized DeploySNPlan createDeploySNPlan(String planName, DatacenterId datacenterId, StorageNodeParams inputSNP) {
        DeploySNPlan plan = new DeploySNPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), datacenterId, inputSNP);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized DeployAdminPlan createDeployAdminPlan(String name, StorageNodeId snid, int httpPort) {
        DeployAdminPlan plan = new DeployAdminPlan(this.planIdGenerator, name, this, snid, httpPort);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized RemoveAdminPlan createRemoveAdminPlan(String name, DatacenterId dcid, AdminId victim) {
        RemoveAdminPlan plan = new RemoveAdminPlan(this.planIdGenerator, name, this, dcid, victim);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized DeployTopoPlan createDeployTopoPlan(String planName, TopologyCandidate candidate) {
        DeployTopoPlan plan = new DeployTopoPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), candidate);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized StopAllRepNodesPlan createStopAllRepNodesPlan(String planName) {
        StopAllRepNodesPlan plan = new StopAllRepNodesPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology());
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized StartAllRepNodesPlan createStartAllRepNodesPlan(String planName) {
        StartAllRepNodesPlan plan = new StartAllRepNodesPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology());
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized StopRepNodesPlan createStopRepNodesPlan(String planName, Set<RepNodeId> rnids) {
        StopRepNodesPlan plan = new StopRepNodesPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), rnids);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized StartRepNodesPlan createStartRepNodesPlan(String planName, Set<RepNodeId> rnids) {
        StartRepNodesPlan plan = new StartRepNodesPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), rnids);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized MigrateSNPlan createMigrateSNPlan(String planName, StorageNodeId oldNode, StorageNodeId newNode, int newHttpPort) {
        MigrateSNPlan plan = new MigrateSNPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), oldNode, newNode, newHttpPort);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized RemoveSNPlan createRemoveSNPlan(String planName, StorageNodeId targetNode) {
        RemoveSNPlan plan = new RemoveSNPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), targetNode);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized RemoveDatacenterPlan createRemoveDatacenterPlan(String planName, DatacenterId targetId) {
        RemoveDatacenterPlan plan = new RemoveDatacenterPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), targetId);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized Plan createAddTablePlan(String planName, String tableId, String parentName, FieldMap fieldMap, List<String> primaryKey, List<String> majorKey, boolean r2compat, int schemaId, String description) {
        DeployTableMetadataPlan plan = TablePlanGenerator.createAddTablePlan(this.planIdGenerator, planName, this, tableId, parentName, fieldMap, primaryKey, majorKey, r2compat, schemaId, description);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized Plan createEvolveTablePlan(String planName, String tableName, int tableVersion, FieldMap fieldMap) {
        DeployTableMetadataPlan plan = TablePlanGenerator.createEvolveTablePlan(this.planIdGenerator, planName, this, tableName, tableVersion, fieldMap);
        this.register(plan);
        return plan;
    }

    @Override
    public Plan createRemoveTablePlan(String planName, String tableName, boolean removeData) {
        DeployTableMetadataPlan plan = TablePlanGenerator.createRemoveTablePlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), tableName, removeData);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized Plan createAddIndexPlan(String planName, String indexName, String tableName, String[] indexedFields, String description) {
        DeployTableMetadataPlan plan = TablePlanGenerator.createAddIndexPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), indexName, tableName, indexedFields, description);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized Plan createRemoveIndexPlan(String planName, String indexName, String tableName) {
        DeployTableMetadataPlan plan = TablePlanGenerator.createRemoveIndexPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), indexName, tableName);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized Plan createChangeParamsPlan(String planName, ResourceId rid, ParameterMap newParams) {
        AbstractPlan plan = null;
        if (rid instanceof RepNodeId) {
            HashSet<RepNodeId> ids = new HashSet<RepNodeId>();
            ids.add((RepNodeId)rid);
            plan = new ChangeParamsPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), ids, newParams);
        } else if (rid instanceof StorageNodeId) {
            plan = new ChangeSNParamsPlan(this.planIdGenerator, planName, this, (StorageNodeId)rid, newParams);
        } else if (rid instanceof AdminId) {
            plan = new ChangeAdminParamsPlan(this.planIdGenerator, planName, this, (AdminId)rid, newParams);
        }
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized Plan createChangeAllParamsPlan(String planName, DatacenterId dcid, ParameterMap newParams) {
        ChangeAllParamsPlan plan = new ChangeAllParamsPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), dcid, newParams, this.logger);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized Plan createChangeAllAdminsPlan(String planName, DatacenterId dcid, ParameterMap newParams) {
        ChangeAdminParamsPlan plan = new ChangeAdminParamsPlan(this.planIdGenerator, planName, this, null, dcid, this.plannerAdmin.getCurrentTopology(), newParams);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized Plan createChangeGlobalSecurityParamsPlan(String planName, ParameterMap newParams) {
        ChangeGlobalSecurityParamsPlan plan = new ChangeGlobalSecurityParamsPlan(this.planIdGenerator, planName, this, this.plannerAdmin.getCurrentTopology(), newParams);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized SecurityMetadataPlan createCreateUserPlan(String planName, String userName, boolean isEnabled, boolean isAdmin, char[] plainPassword) {
        SecurityMetadataPlan plan = SecurityMetadataPlan.createCreateUserPlan(this.planIdGenerator, planName, this, userName, isEnabled, isAdmin, plainPassword);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized SecurityMetadataPlan createChangeUserPlan(String planName, String userName, Boolean isEnabled, char[] plainPassword, boolean retainPassword, boolean clearRetainedPassword) {
        SecurityMetadataPlan plan = SecurityMetadataPlan.createChangeUserPlan(this.planIdGenerator, planName, this, userName, isEnabled, plainPassword, retainPassword, clearRetainedPassword);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized SecurityMetadataPlan createDropUserPlan(String planName, String userName) {
        SecurityMetadataPlan plan = SecurityMetadataPlan.createDropUserPlan(this.planIdGenerator, planName, this, userName);
        this.register(plan);
        return plan;
    }

    @Override
    public synchronized RepairPlan createRepairPlan(String planName) {
        RepairPlan plan = new RepairPlan(this.planIdGenerator, planName, this);
        this.register(plan);
        return plan;
    }

    @Override
    public PlanRun executePlan(Plan plan, boolean force) {
        if (!(plan instanceof AbstractPlan)) {
            throw new NonfatalAssertionException("Unknown Plan type: " + plan.getClass() + " cannot be executed");
        }
        AbstractPlan targetPlan = (AbstractPlan)plan;
        targetPlan.validateStartOfRun();
        this.catalog.validateStart(plan);
        PlanRun planRun = null;
        try {
            plan.getCatalogLocks();
            plan.preExecuteCheck(force, this.logger);
            planRun = targetPlan.startNewRun();
            PlanExecutor planExec = new PlanExecutor(this.plannerAdmin, this, targetPlan, planRun, this.logger);
            Future<Plan.State> future = this.executor.submit(planExec);
            this.catalog.addPlanFuture(targetPlan, future);
        }
        catch (RejectedExecutionException e) {
            String problem = "Plan did not start, insufficient resources for executing a plan";
            if (planRun != null) {
                plan.saveFailure(planRun, e, "Plan did not start, insufficient resources for executing a plan", this.logger);
            }
            this.planFinished(targetPlan);
            throw new OperationFaultException("Plan did not start, insufficient resources for executing a plan", e);
        }
        return planRun;
    }

    void planFinished(Plan plan) {
        this.catalog.clearLocks(plan.getId());
        this.catalog.clearPlan(plan);
    }

    @Override
    public PlannerAdmin getAdmin() {
        return this.plannerAdmin;
    }

    @Override
    public void lockElasticity(int planId, String planName) {
        this.catalog.lockElasticityChange(planId, planName);
    }

    @Override
    public void lockRN(int planId, String planName, RepNodeId rnId) {
        this.catalog.lockRN(planId, planName, rnId);
    }

    @Override
    public void lockShard(int planId, String planName, RepGroupId rgId) {
        this.catalog.lockShard(planId, planName, rgId);
    }

    @Override
    public Plan getCachedPlan(int planId) {
        return this.catalog.getPlan(planId);
    }

    private Plan getFromCatalog(int planId) {
        Plan plan = this.getCachedPlan(planId);
        if (plan == null) {
            throw new IllegalCommandException("Plan " + planId + " is not an active plan");
        }
        return plan;
    }

    @Override
    public void approvePlan(int planId) {
        Plan plan = this.getFromCatalog(planId);
        try {
            ((AbstractPlan)plan).requestApproval();
        }
        catch (IllegalStateException e) {
            throw new IllegalCommandException(e.getMessage());
        }
    }

    @Override
    public void cancelPlan(int planId) {
        AbstractPlan plan = (AbstractPlan)this.getFromCatalog(planId);
        try {
            plan.requestCancellation();
            this.planFinished(plan);
        }
        catch (IllegalStateException e) {
            throw new IllegalCommandException(e.getMessage());
        }
    }

    @Override
    public void interruptPlan(int planId) {
        Plan plan = this.getFromCatalog(planId);
        AbstractPlan aplan = (AbstractPlan)plan;
        if (aplan.cancelIfNotStarted()) {
            return;
        }
        if (!plan.getState().checkTransition(Plan.State.INTERRUPT_REQUESTED)) {
            throw new IllegalCommandException("Can't interrupt plan " + plan + " in state " + (Object)((Object)plan.getState()));
        }
        this.logger.info("User requesting interrupt of " + plan);
        aplan.requestInterrupt();
    }

    private class Catalog {
        private Plan currentExclusivePlan;
        private Plan currentExecutingPlan;
        private final Map<Integer, Future<Plan.State>> futures;
        private final Map<Integer, Plan> planMap = new HashMap<Integer, Plan>();
        private final TopoLock elasticityLock;
        private final Map<RepNodeId, TopoLock> rnLocks;
        private final Map<RepGroupId, TopoLock> rgLocks;

        Catalog() {
            this.futures = new HashMap<Integer, Future<Plan.State>>();
            this.elasticityLock = new TopoLock();
            this.rnLocks = new HashMap<RepNodeId, TopoLock>();
            this.rgLocks = new HashMap<RepGroupId, TopoLock>();
        }

        public void lockElasticityChange(int planId, String planName) {
            if (!this.elasticityLock.get(planId, planName)) {
                throw this.cantLock(planId, planName, this.elasticityLock.lockingPlanId, this.elasticityLock.lockingPlanName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lockRN(int planId, String planName, RepNodeId rnId) {
            TopoLock topoLock = this.elasticityLock;
            synchronized (topoLock) {
                TopoLock rgl = this.rgLocks.get(new RepGroupId(rnId.getGroupId()));
                if (rgl != null && rgl.lockingPlanId != planId) {
                    throw this.cantLock(planId, planName, rgl.lockingPlanId, rgl.lockingPlanName);
                }
                TopoLock rnl = this.rnLocks.get(rnId);
                if (rnl == null) {
                    rnl = new TopoLock();
                    this.rnLocks.put(rnId, rnl);
                }
                if (!rnl.get(planId, planName)) {
                    throw this.cantLock(planId, planName, rnl.lockingPlanId, rnl.lockingPlanName);
                }
            }
        }

        private IllegalCommandException cantLock(int planId, String planName, int lockingId, String lockingName) {
            return new IllegalCommandException("Couldn't execute " + planId + "/" + planName + " because " + lockingId + "/" + lockingName + " is running. " + "Wait until that plan is finished or interrupted");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lockShard(int planId, String planName, RepGroupId rgId) {
            TopoLock topoLock = this.elasticityLock;
            synchronized (topoLock) {
                TopoLock rgl = this.rgLocks.get(rgId);
                if (rgl != null && rgl.locked) {
                    if (rgl.lockingPlanId == planId) {
                        return;
                    }
                    throw this.cantLock(planId, planName, rgl.lockingPlanId, rgl.lockingPlanName);
                }
                for (Map.Entry<RepNodeId, TopoLock> entry : this.rnLocks.entrySet()) {
                    if (!rgId.sameGroup(entry.getKey())) continue;
                    TopoLock l = entry.getValue();
                    if (l.lockingPlanId == planId || !l.locked) continue;
                    throw this.cantLock(planId, planName, l.lockingPlanId, l.lockingPlanName);
                }
                if (rgl == null) {
                    rgl = new TopoLock();
                    this.rgLocks.put(rgId, rgl);
                }
                rgl.get(planId, planName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearLocks(int planId) {
            TopoLock topoLock = this.elasticityLock;
            synchronized (topoLock) {
                TopoLock tl;
                Iterator<TopoLock> iter = this.rnLocks.values().iterator();
                while (iter.hasNext()) {
                    tl = iter.next();
                    if (tl.lockingPlanId != planId) continue;
                    iter.remove();
                }
                iter = this.rgLocks.values().iterator();
                while (iter.hasNext()) {
                    tl = iter.next();
                    if (tl.lockingPlanId != planId) continue;
                    iter.remove();
                }
            }
            this.elasticityLock.releaseForPlanId(planId);
        }

        synchronized void addNewPlan(Plan plan) {
            if (!plan.isExclusive()) {
                this.planMap.put(plan.getId(), plan);
                return;
            }
            if (this.currentExclusivePlan == null) {
                this.currentExclusivePlan = plan;
                this.planMap.put(plan.getId(), plan);
                return;
            }
            throw new IllegalCommandException(plan + " is an exclusive type plan, and cannot be created " + " because " + this.currentExclusivePlan + " is active. Consider canceling " + this.currentExclusivePlan + ".");
        }

        synchronized void addPlanFuture(Plan plan, Future<Plan.State> future) {
            if (!plan.getState().isTerminal()) {
                this.futures.put(plan.getId(), future);
            }
        }

        synchronized void validateStart(Plan plan) {
            if (BasicPlannerImpl.this.catalog.getPlan(plan.getId()) == null) {
                throw new NonfatalAssertionException(plan + " must be registered.");
            }
            if (!plan.isExclusive()) {
                return;
            }
            if (this.currentExecutingPlan != null) {
                if (this.currentExecutingPlan.equals(plan)) {
                    throw new IllegalCommandException(plan + " is already running");
                }
                throw new IllegalCommandException(this.currentExecutingPlan + " is running, can't start " + plan);
            }
            this.currentExecutingPlan = plan;
        }

        synchronized void clearPlan(Plan plan) {
            this.futures.remove(plan.getId());
            if (this.currentExecutingPlan == plan) {
                this.currentExecutingPlan = null;
            }
            if (!plan.getState().isTerminal()) {
                return;
            }
            this.planMap.remove(plan.getId());
            if (this.currentExclusivePlan == plan) {
                this.currentExclusivePlan = null;
            }
        }

        Plan getPlan(int planId) {
            return this.planMap.get(planId);
        }

        private class TopoLock {
            boolean locked;
            int lockingPlanId;
            String lockingPlanName;

            private TopoLock() {
            }

            boolean get(int planId, String planName) {
                if (this.locked && this.lockingPlanId != planId) {
                    return false;
                }
                this.locked = true;
                this.lockingPlanId = planId;
                this.lockingPlanName = planName;
                return true;
            }

            void releaseForPlanId(int planId) {
                if (!this.locked) {
                    return;
                }
                if (this.lockingPlanId == planId) {
                    this.locked = false;
                    this.lockingPlanId = 0;
                    this.lockingPlanName = null;
                }
            }
        }
    }
}

