/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.param;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.topo.StorageNodeId;

@Persistent
public class StorageNodePool
implements Serializable,
Iterable<StorageNodeId> {
    private static final long serialVersionUID = 1L;
    private String name;
    private Set<StorageNodeId> snIds;
    transient ReadWriteLock rwl = new ReentrantReadWriteLock();

    public StorageNodePool(String name) {
        this.name = name;
        this.snIds = new TreeSet<StorageNodeId>();
    }

    StorageNodePool() {
    }

    public String getName() {
        return this.name;
    }

    public List<StorageNodeId> getList() {
        return new ArrayList<StorageNodeId>(this.snIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(StorageNodeId snId) {
        Lock w = this.rwl.writeLock();
        try {
            w.lock();
            if (this.snIds.contains(snId)) {
                throw new IllegalCommandException("SN Pool " + this.name + " already contains SN " + snId);
            }
            this.snIds.add(snId);
        }
        finally {
            w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(StorageNodeId snId) {
        Lock w = this.rwl.writeLock();
        try {
            w.lock();
            if (!this.snIds.contains(snId)) {
                throw new IllegalCommandException("SN Pool " + this.name + " does not contain SN " + snId);
            }
            this.snIds.remove(snId);
        }
        finally {
            w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Lock w = this.rwl.writeLock();
        try {
            w.lock();
            this.snIds.clear();
        }
        finally {
            w.unlock();
        }
    }

    public void freeze() {
        this.rwl.readLock().lock();
    }

    public void thaw() {
        this.rwl.readLock().unlock();
    }

    public Iterator<StorageNodeId> getLoopIterator() {
        return new LoopIterator(this);
    }

    public int size() {
        return this.snIds.size();
    }

    public boolean contains(StorageNodeId snid) {
        return this.snIds.contains(snid);
    }

    @Override
    public Iterator<StorageNodeId> iterator() {
        return this.snIds.iterator();
    }

    private static class LoopIterator
    implements Iterator<StorageNodeId> {
        private Iterator<StorageNodeId> listIter;
        private final StorageNodePool pool;

        private LoopIterator(StorageNodePool pool) {
            if (pool.snIds.size() == 0) {
                throw new IllegalCommandException("Storage Node Pool " + pool.name + " is empty.");
            }
            this.pool = pool;
            this.listIter = pool.snIds.iterator();
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public StorageNodeId next() {
            if (!this.listIter.hasNext()) {
                this.listIter = this.pool.snIds.iterator();
            }
            return this.listIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Intentionally unsupported");
        }
    }
}

