/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.param;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.param.DefaultParameter;
import oracle.kv.impl.param.DurationParameter;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;
import oracle.kv.impl.param.ParameterUtils;
import oracle.kv.impl.test.TestStatus;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.PortRange;
import oracle.kv.impl.util.registry.ClearServerSocketFactory;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.registry.ServerSocketFactory;

@Persistent(version=1)
public class StorageNodeParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String REGISTRY_SSF_NAME = "registry";
    private static final String CSF_EMPTY_STORE_NAME = "$";
    public static final RNHeapAndCacheSize NO_CACHE_AND_HEAP_SPEC = new RNHeapAndCacheSize(0L, 0L);
    private ParameterMap map;
    private ParameterMap mountMap;
    public static final String[] REGISTRATION_PARAMS = new String[]{"haHostname", "haPortRange", "servicePortRange", "capacity", "numCPUs", "memoryMB", "mgmtClass", "mgmtPollPort", "mgmtTrapHost", "mgmtTrapPort", "rootDirPath"};

    public StorageNodeParams() {
    }

    public StorageNodeParams(ParameterMap map) {
        this(map, null);
    }

    public StorageNodeParams(ParameterMap map, ParameterMap mountMap) {
        this.map = map;
        map.setType("storageNodeParams");
        map.setName("storageNodeParams");
        this.mountMap = mountMap;
    }

    public StorageNodeParams(LoadParameters lp) {
        this.map = lp.getMap("storageNodeParams");
        this.mountMap = lp.getMap("mountPoints");
    }

    public StorageNodeParams(String hostname, int registryPort, String comment) {
        this(null, hostname, registryPort, comment);
    }

    public StorageNodeParams(StorageNodeId storageNodeId, String hostname, int registryPort, String comment) {
        this(new ParameterMap("storageNodeParams", "storageNodeParams"), storageNodeId, hostname, registryPort, comment);
    }

    public StorageNodeParams(ParameterMap map, StorageNodeId storageNodeId, String hostname, int registryPort, String comment) {
        this.map = map;
        map.setType("storageNodeParams");
        map.setName("storageNodeParams");
        if (storageNodeId != null) {
            this.setStorageNodeId(storageNodeId);
        }
        this.setHostname(hostname);
        this.setRegistryPort(registryPort);
        if (comment != null) {
            this.setComment(comment);
        }
        this.addDefaults();
        map = this.getFilteredMap();
    }

    private void addDefaults() {
        this.map.addServicePolicyDefaults(ParameterState.Info.SNA);
    }

    public ParameterMap getFilteredMap() {
        return this.map.filter(EnumSet.of(ParameterState.Info.SNA));
    }

    public ParameterMap getMap() {
        return this.map;
    }

    public ParameterMap getMountMap() {
        return this.mountMap;
    }

    public void setMountMap(ParameterMap mountMap) {
        this.mountMap = mountMap;
    }

    public List<String> getMountPoints() {
        if (this.mountMap == null) {
            return null;
        }
        return BootstrapParams.getMountPoints(this.mountMap);
    }

    public static ParameterMap changeMountMap(Parameters params, StorageNodeParams snp, boolean add, String mountPoint) throws IllegalCommandException {
        ParameterMap mountMap = snp.getMountMap();
        if (!(add || mountMap != null && mountMap.exists(mountPoint))) {
            throw new IllegalCommandException("Can't remove non-existent storage directory: " + mountPoint);
        }
        ParameterMap newMap = mountMap != null ? mountMap.copy() : BootstrapParams.createMountMap();
        if (add) {
            BootstrapParams.addMountPoint(newMap, mountPoint);
        } else {
            newMap.remove(mountPoint);
        }
        String badMapInfo = StorageNodeParams.validateMountMap(mountMap, params, snp.getStorageNodeId());
        if (badMapInfo != null) {
            throw new IllegalCommandException(badMapInfo);
        }
        return newMap;
    }

    public static String validateMountMap(ParameterMap mountMap, Parameters p, StorageNodeId snid) {
        for (RepNodeParams rnp : p.getRepNodeParams()) {
            String mp;
            if (!rnp.getStorageNodeId().equals(snid) || (mp = rnp.getMountPointString()) == null || mountMap.exists(mp)) continue;
            return "Cannot remove an in-use storage directory. Storage directory " + mp + " is in use by RepNode " + rnp.getRepNodeId();
        }
        return null;
    }

    public void setInstallationInfo(ParameterMap bootMap, ParameterMap mountMap, boolean hostingAdmin) {
        if (bootMap != null) {
            BootstrapParams bp = new BootstrapParams(bootMap, mountMap);
            this.setRootDirPath(bp.getRootdir());
            this.setHAHostname(bp.getHAHostname());
            String haPortRange = bp.getHAPortRange();
            PortRange.validateHA(haPortRange);
            this.setHAPortRange(haPortRange);
            String servicePortRange = bp.getServicePortRange();
            if (servicePortRange != null) {
                PortRange.validateService(servicePortRange);
                this.setServicePortRange(servicePortRange);
                PortRange.validateDisjoint(haPortRange, servicePortRange);
            }
            this.setCapacity(bp.getCapacity());
            if (servicePortRange != null) {
                boolean isSecure = bp.getSecurityDir() != null;
                PortRange.validateSufficientPorts(servicePortRange, bp.getCapacity(), isSecure, hostingAdmin, bp.getMgmtPorts());
            }
            this.setNumCPUs(bp.getNumCPUs());
            this.setMemoryMB(bp.getMemoryMB());
            this.setMgmtClass(bp.getMgmtClass());
            this.setMgmtPollingPort(bp.getMgmtPollingPort());
            this.setMgmtTrapHost(bp.getMgmtTrapHost());
            this.setMgmtTrapPort(bp.getMgmtTrapPort());
        }
        this.mountMap = mountMap.copy();
    }

    public boolean isRegistered() {
        return this.getHAHostname() != null && this.getRootDirPath() != null && this.getHAPortRange() != null;
    }

    public String getHostname() {
        return this.map.get("hostname").asString();
    }

    public void setHostname(String hostname) {
        this.map.setParameter("hostname", hostname);
    }

    public String getHAHostname() {
        return this.map.get("haHostname").asString();
    }

    public void setHAHostname(String hostname) {
        this.map.setParameter("haHostname", hostname);
    }

    public String getHAPortRange() {
        return this.map.get("haPortRange").asString();
    }

    public void setHAPortRange(String range) {
        this.map.setParameter("haPortRange", range);
    }

    public String getServicePortRange() {
        return this.map.getOrDefault("servicePortRange").asString();
    }

    public void setServicePortRange(String range) {
        this.map.setParameter("servicePortRange", range);
    }

    public String getRootDirPath() {
        return this.map.get("rootDirPath").asString();
    }

    public void setRootDirPath(String path) {
        this.map.setParameter("rootDirPath", path);
    }

    public void setNumCPUs(int ncpus) {
        this.map.setParameter("numCPUs", Integer.toString(ncpus));
    }

    public int getNumCPUs() {
        return this.map.getOrZeroInt("numCPUs");
    }

    public void setCapacity(int capacity) {
        this.map.setParameter("capacity", Integer.toString(capacity));
    }

    public void setMemoryMB(int memoryMB) {
        this.map.setParameter("memoryMB", Integer.toString(memoryMB));
    }

    public int getMemoryMB() {
        return this.map.getOrZeroInt("memoryMB");
    }

    public int getRegistryPort() {
        return this.map.getOrZeroInt("registryPort");
    }

    public void setRegistryPort(int port) {
        this.map.setParameter("registryPort", Integer.toString(port));
    }

    public StorageNodeId getStorageNodeId() {
        return new StorageNodeId(this.map.getOrZeroInt("storageNodeId"));
    }

    public void setStorageNodeId(StorageNodeId snid) {
        this.map.setParameter("storageNodeId", Integer.toString(snid.getStorageNodeId()));
    }

    public String getComment() {
        return this.map.get("comment").asString();
    }

    public void setComment(String c) {
        this.map.setParameter("comment", c);
    }

    public int getLogFileCount() {
        return this.map.getOrZeroInt("serviceLogFileCount");
    }

    public int getLogFileLimit() {
        return this.map.getOrZeroInt("serviceLogFileLimit");
    }

    public int getServiceWaitMillis() {
        return (int)ParameterUtils.getDurationMillis(this.map, "serviceStopWait");
    }

    public int getRepNodeStartSecs() {
        return (int)ParameterUtils.getDurationMillis(this.map, "repnodeStartWait") / 1000;
    }

    public int getLinkExecWaitSecs() {
        return (int)ParameterUtils.getDurationMillis(this.map, "linkExecWait") / 1000;
    }

    public int getMaxLinkCount() {
        return this.map.getOrZeroInt("maxLinkCount");
    }

    private int getDurationParamMillis(String param) {
        return (int)ParameterUtils.getDurationMillis(this.map, param);
    }

    private static int getDefaultDurationParamMillis(String param) {
        DurationParameter dp = (DurationParameter)DefaultParameter.getDefaultParameter(param);
        return (int)dp.toMillis();
    }

    public String displaySNIdAndHost() {
        return this.getStorageNodeId() + "(" + this.getHostname() + ":" + this.getRegistryPort() + ")";
    }

    public RMISocketPolicy.SocketFactoryPair getAdminCommandServiceSFP(RMISocketPolicy policy, String storeName) {
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        String csfName = ClientSocketFactory.factoryName(storeName == null ? CSF_EMPTY_STORE_NAME : storeName, AdminId.getPrefix(), RegistryUtils.InterfaceType.MAIN.interfaceName());
        args.setSsfName(RegistryUtils.InterfaceType.MAIN.interfaceName()).setSsfBacklog(this.map.getOrDefault("adminCommandServiceSOBacklog").asInt()).setSsfPortRange(this.getServicePortRange()).setCsfName(csfName);
        return policy.getBindPair(args);
    }

    public RMISocketPolicy.SocketFactoryPair getAdminLoginSFP(RMISocketPolicy policy, String storeName) {
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        String csfName = ClientSocketFactory.factoryName(storeName == null ? CSF_EMPTY_STORE_NAME : storeName, AdminId.getPrefix(), RegistryUtils.InterfaceType.LOGIN.interfaceName());
        args.setSsfName(RegistryUtils.InterfaceType.LOGIN.interfaceName()).setSsfBacklog(this.map.getOrDefault("adminLoginSOBacklog").asInt()).setSsfPortRange(this.getServicePortRange()).setCsfName(csfName);
        return policy.getBindPair(args);
    }

    public ServerSocketFactory getAdminListenerSSF() {
        return ClearServerSocketFactory.create(RegistryUtils.InterfaceType.MAIN.interfaceName(), this.map.getOrDefault("adminListenerSOBacklog").asInt(), this.getServicePortRange());
    }

    public RMISocketPolicy.SocketFactoryPair getStorageNodeAdminSFP(RMISocketPolicy policy, String csfName) {
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        args.setSsfName(RegistryUtils.InterfaceType.MAIN.interfaceName()).setSsfBacklog(this.map.getOrDefault("snAdminSOBacklog").asInt()).setSsfPortRange(this.getServicePortRange()).setCsfName(csfName).setUseCsf(this.getUseClientSocketFactory()).setCsfConnectTimeout(this.getDurationParamMillis("connectTimeout")).setCsfReadTimeout(this.getDurationParamMillis("readTimeout"));
        return policy.getBindPair(args);
    }

    public RMISocketPolicy.SocketFactoryPair getTrustedLoginSFP(RMISocketPolicy policy, String csfName) {
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        args.setSsfName(RegistryUtils.InterfaceType.TRUSTED_LOGIN.interfaceName()).setSsfBacklog(this.map.getOrDefault("snLoginSOBacklog").asInt()).setSsfPortRange(this.getServicePortRange()).setCsfName(csfName).setUseCsf(this.getUseClientSocketFactory()).setCsfConnectTimeout(this.getDurationParamMillis("snLoginSOConnectTimeout")).setCsfReadTimeout(this.getDurationParamMillis("snLoginSOReadTimeout"));
        return policy.getBindPair(args);
    }

    public RMISocketPolicy.SocketFactoryPair getMonitorSFP(RMISocketPolicy policy, String csfName) {
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        args.setSsfName(RegistryUtils.InterfaceType.MAIN.interfaceName()).setSsfBacklog(this.map.getOrDefault("snMonitorSOBacklog").asInt()).setSsfPortRange(this.getServicePortRange()).setCsfName(csfName).setUseCsf(this.getUseClientSocketFactory()).setCsfConnectTimeout(this.getDurationParamMillis("snMonitorSOConnectTimeout")).setCsfReadTimeout(this.getDurationParamMillis("snMonitorSOReadTimeout"));
        return policy.getBindPair(args);
    }

    public RMISocketPolicy.SocketFactoryPair getRegistrySFP(RMISocketPolicy policy) {
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        args.setSsfName(REGISTRY_SSF_NAME).setSsfBacklog(this.map.getOrDefault("snRegistrySOBacklog").asInt()).setSsfPortRange("0").setCsfName(ClientSocketFactory.registryFactoryName()).setUseCsf(this.getUseClientSocketFactory()).setCsfConnectTimeout(0).setCsfReadTimeout(0);
        return policy.getRegistryPair(args);
    }

    public static RMISocketPolicy.SocketFactoryPair getDefaultRegistrySFP(RMISocketPolicy policy) {
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs();
        args.setSsfName(RegistryUtils.InterfaceType.MAIN.interfaceName()).setSsfBacklog(DefaultParameter.getDefaultParameter("adminListenerSOBacklog").asInt()).setSsfPortRange(DefaultParameter.getDefaultParameter("servicePortRange").asString()).setCsfName(ClientSocketFactory.registryFactoryName()).setCsfConnectTimeout(StorageNodeParams.getDefaultDurationParamMillis("snMonitorSOConnectTimeout")).setCsfReadTimeout(StorageNodeParams.getDefaultDurationParamMillis("snMonitorSOReadTimeout"));
        if (TestStatus.isActive() && policy.isPolicyOptional()) {
            return new RMISocketPolicy.SocketFactoryPair(null, null);
        }
        return policy.getRegistryPair(args);
    }

    public void setRegistryCSF(SecurityParams sp) {
        RMISocketPolicy rmiPolicy = sp.getRMISocketPolicy();
        RMISocketPolicy.SocketFactoryArgs args = new RMISocketPolicy.SocketFactoryArgs().setCsfName(ClientSocketFactory.registryFactoryName()).setUseCsf(this.getUseClientSocketFactory()).setCsfConnectTimeout(this.getDurationParamMillis("snRegistrySOConnectTimeout")).setCsfReadTimeout(this.getDurationParamMillis("snMonitorSOReadTimeout"));
        RegistryUtils.setServerRegistryCSF(rmiPolicy.getRegistryCSF(args));
    }

    public boolean getUseClientSocketFactory() {
        return !ClientSocketFactory.isDisabled() && this.map.exists("useClientSocketFactories") ? this.map.get("useClientSocketFactories").asBoolean() : false;
    }

    public int getCapacity() {
        return this.map.getOrDefault("capacity").asInt();
    }

    public boolean getMasterBalance() {
        return this.map.getOrDefault("masterBalance").asBoolean();
    }

    public void setMasterBalance(boolean masterBalance) {
        this.map.setParameter("masterBalance", masterBalance ? "true" : "false");
    }

    public String getMgmtClass() {
        return this.map.getOrDefault("mgmtClass").asString();
    }

    public void setMgmtClass(String mgmtClass) {
        this.map.setParameter("mgmtClass", mgmtClass);
    }

    public int getMgmtPollingPort() {
        return this.map.getOrZeroInt("mgmtPollPort");
    }

    public void setMgmtPollingPort(int port) {
        this.map.setParameter("mgmtPollPort", Integer.toString(port));
    }

    public String getMgmtTrapHost() {
        return this.map.get("mgmtTrapHost").asString();
    }

    public void setMgmtTrapHost(String hostname) {
        this.map.setParameter("mgmtTrapHost", hostname);
    }

    public int getMgmtTrapPort() {
        return this.map.getOrZeroInt("mgmtTrapPort");
    }

    public void setMgmtTrapPort(int port) {
        this.map.setParameter("mgmtTrapPort", Integer.toString(port));
    }

    public void validate() {
        String servicePortRange = this.map.get("servicePortRange").toString();
        if (servicePortRange != null) {
            PortRange.validateService(servicePortRange);
            String haRange = this.getHAPortRange();
            if (haRange != null) {
                PortRange.validateDisjoint(servicePortRange, haRange);
            }
        }
    }

    public int getGCThreadFloor() {
        return this.map.getOrDefault("gcThreadFloor").asInt();
    }

    public int getGCThreadThreshold() {
        return this.map.getOrDefault("gcThreadThreshold").asInt();
    }

    public int getGCThreadPercent() {
        return this.map.getOrDefault("gcThreadPercent").asInt();
    }

    public int calcGCThreads() {
        return StorageNodeParams.calcGCThreads(this.getNumCPUs(), this.getCapacity(), this.getGCThreadFloor(), this.getGCThreadThreshold(), this.getGCThreadPercent());
    }

    public static int calcGCThreads(int numCPUs, int capacity, int gcThreadFloor, int gcThreadThreshold, int gcThreadPercent) {
        int floor = gcThreadFloor < gcThreadThreshold ? gcThreadFloor : gcThreadThreshold;
        int minGCThreads = Math.min(numCPUs, floor);
        int numCPUsPerRN = numCPUs / capacity;
        if (numCPUs == 0) {
            return 0;
        }
        if (numCPUsPerRN <= minGCThreads) {
            return minGCThreads;
        }
        if (numCPUsPerRN <= gcThreadThreshold) {
            return numCPUsPerRN;
        }
        return Math.max(gcThreadThreshold, numCPUsPerRN * gcThreadPercent / 100);
    }

    public int getRNHeapPercent() {
        return this.map.getOrDefault("rnHeapPercent").asInt();
    }

    public RNHeapAndCacheSize calculateRNHeapAndCache(ParameterMap policyMap, int numRNsOnSN, int rnCachePercent) {
        return StorageNodeParams.calculateRNHeapAndCache(policyMap, this.getCapacity(), numRNsOnSN, this.getMemoryMB(), this.getRNHeapPercent(), rnCachePercent);
    }

    public static RNHeapAndCacheSize calculateRNHeapAndCache(ParameterMap policyMap, int capacity, int numRNsOnSN, int memoryMB, int rnHeapPercent, int rnCachePercent) {
        String jvmArgs = policyMap.getOrDefault("javaMiscParams").asString();
        long policyHeapBytes = RepNodeParams.parseJVMArgsForHeap("-Xmx", jvmArgs);
        long policyCacheBytes = policyMap.getOrDefault("cacheSize").asLong();
        if (memoryMB == 0) {
            if (policyCacheBytes != 0L || policyHeapBytes != 0L) {
                return new RNHeapAndCacheSize(policyHeapBytes >> 20, policyCacheBytes);
            }
            return NO_CACHE_AND_HEAP_SPEC;
        }
        long snaMem = memoryMB;
        long memoryForHeapBytes = (snaMem << 20) * (long)rnHeapPercent / 100L;
        int divisor = numRNsOnSN != 0 && numRNsOnSN > capacity ? numRNsOnSN : capacity;
        long perRNHeap = memoryForHeapBytes / (long)divisor;
        if (policyHeapBytes != 0L) {
            perRNHeap = policyHeapBytes;
        }
        if (perRNHeap < 0x2000000L) {
            return NO_CACHE_AND_HEAP_SPEC;
        }
        long perRNCacheBytes = perRNHeap * (long)rnCachePercent / 100L;
        if (policyCacheBytes != 0L) {
            perRNCacheBytes = policyCacheBytes;
        }
        if (perRNCacheBytes < 0x1600000L) {
            return NO_CACHE_AND_HEAP_SPEC;
        }
        return new RNHeapAndCacheSize(perRNHeap >> 20, perRNCacheBytes);
    }

    public String getProcessStartupPrefix() {
        return this.map.get("processStartupPrefix").asString();
    }

    public void setSessionLimit(String value) {
        this.map.setParameter("sessionLimit", value);
    }

    public int getSessionLimit() {
        return this.map.getOrDefault("sessionLimit").asInt();
    }

    public void setLoginCacheSize(String value) {
        this.map.setParameter("loginCacheSize", value);
    }

    public int getLoginCacheSize() {
        return this.map.getOrDefault("loginCacheSize").asInt();
    }

    public static class RNHeapAndCacheSize {
        final long heapMB;
        final long cacheBytes;

        private RNHeapAndCacheSize(long heapMB, long cacheBytes) {
            this.heapMB = heapMB;
            this.cacheBytes = cacheBytes;
        }

        public long getCacheBytes() {
            return this.cacheBytes;
        }

        public long getHeapMB() {
            return this.heapMB;
        }

        public String getHeapValAndUnit() {
            if (this.heapMB == 0L) {
                return null;
            }
            return this.heapMB + "M";
        }

        public String toString() {
            return "heapMB=" + this.heapMB + " cacheBytes=" + this.cacheBytes;
        }
    }
}

