/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.param;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.param.DefaultParameter;
import oracle.kv.impl.param.DurationParameter;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;

@Persistent
public class GlobalParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ParameterMap map;
    public static final String SNA_SERVICE_NAME = "snaService";
    public static final String COMMAND_SERVICE_NAME = "commandService";
    public static final String COMMAND_SERVICE_TEST_NAME = "commandServiceTest";
    public static final String ADMIN_LOGIN_SERVICE_NAME = "admin:LOGIN";
    public static final String SNA_LOGIN_SERVICE_NAME = "SNA:TRUSTED_LOGIN";

    public GlobalParams() {
    }

    public GlobalParams(ParameterMap map) {
        this.map = map;
    }

    public GlobalParams(String kvsName) {
        this.map = new ParameterMap("globalParams", "globalParams");
        this.map.setParameter("storeName", kvsName);
    }

    public ParameterMap getGlobalSecurityPolicies() {
        EnumSet<ParameterState.Info> set = EnumSet.of(ParameterState.Info.GLOBAL, ParameterState.Info.SECURITY);
        ParameterMap pmap = new ParameterMap();
        for (ParameterState ps : ParameterState.getMap().values()) {
            if (!ps.containsAll(set)) continue;
            String pName = DefaultParameter.getDefaultParameter(ps).getName();
            pmap.put(this.map.getOrDefault(pName));
        }
        return pmap;
    }

    public ParameterMap getMap() {
        return this.map;
    }

    public void setKVStoreName(String kvsName) {
        this.map.setParameter("storeName", kvsName);
    }

    public String getKVStoreName() {
        return this.map.get("storeName").asString();
    }

    public boolean isLoopbackSet() {
        return this.map.exists("isLoopback");
    }

    public boolean isLoopback() {
        return this.map.get("isLoopback").asBoolean();
    }

    public void setIsLoopback(boolean value) {
        this.map.setParameter("isLoopback", Boolean.toString(value));
    }

    public void setSessionTimeout(String value) {
        this.map.setParameter("sessionTimeout", value);
    }

    public long getSessionTimeout() {
        DurationParameter dp = (DurationParameter)this.map.getOrDefault("sessionTimeout");
        return dp.getAmount();
    }

    public TimeUnit getSessionTimeoutUnit() {
        DurationParameter dp = (DurationParameter)this.map.getOrDefault("sessionTimeout");
        return dp.getUnit();
    }

    public void setSessionExtendAllow(String value) {
        this.map.setParameter("sessionExtendAllowed", value);
    }

    public boolean getSessionExtendAllow() {
        return this.map.getOrDefault("sessionExtendAllowed").asBoolean();
    }

    public void setAcctErrLockoutThrCnt(String value) {
        this.map.setParameter("accountErrorLockoutThresholdCount", value);
    }

    public int getAcctErrLockoutThrCount() {
        return this.map.getOrDefault("accountErrorLockoutThresholdCount").asInt();
    }

    public void setAcctErrLockoutThrInt(String value) {
        this.map.setParameter("accountErrorLockoutThresholdInterval", value);
    }

    public long getAcctErrLockoutThrInt() {
        DurationParameter dp = (DurationParameter)this.map.getOrDefault("accountErrorLockoutThresholdInterval");
        return dp.getAmount();
    }

    public TimeUnit getAcctErrLockoutThrIntUnit() {
        DurationParameter dp = (DurationParameter)this.map.getOrDefault("accountErrorLockoutThresholdInterval");
        return dp.getUnit();
    }

    public void setAcctErrLockoutTimeout(String value) {
        this.map.setParameter("accountErrorLockoutTimeout", value);
    }

    public long getAcctErrLockoutTimeout() {
        DurationParameter dp = (DurationParameter)this.map.getOrDefault("accountErrorLockoutTimeout");
        return dp.getAmount();
    }

    public TimeUnit getAcctErrLockoutTimeoutUnit() {
        DurationParameter dp = (DurationParameter)this.map.getOrDefault("accountErrorLockoutTimeout");
        return dp.getUnit();
    }

    public void setLoginCacheTimeout(String value) {
        this.map.setParameter("loginCacheTimeout", value);
    }

    public long getLoginCacheTimeout() {
        DurationParameter dp = (DurationParameter)this.map.getOrDefault("loginCacheTimeout");
        return dp.getAmount();
    }

    public TimeUnit getLoginCacheTimeoutUnit() {
        DurationParameter dp = (DurationParameter)this.map.getOrDefault("loginCacheTimeout");
        return dp.getUnit();
    }

    public boolean equals(GlobalParams other) {
        return this.map.equals(other.getMap());
    }
}

