/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.param;

import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.param.DurationParameter;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;
import oracle.kv.impl.param.ParameterUtils;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.StorageNodeId;

@Persistent
public class AdminParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ParameterMap map;

    public AdminParams() {
    }

    public AdminParams(ParameterMap map) {
        this.map = map;
    }

    public AdminParams(AdminId adminId, StorageNodeId storageNodeId, int httpPort) {
        this(new ParameterMap(), adminId, storageNodeId, httpPort);
    }

    public AdminParams(ParameterMap newmap, AdminId adminId, StorageNodeId snid, int httpPort) {
        this.map = newmap.filter(EnumSet.of(ParameterState.Info.ADMIN));
        this.setAdminId(adminId);
        this.setStorageNodeId(snid);
        this.setHttpPort(httpPort);
        this.addDefaults();
        this.map.setName(adminId.getFullName());
        this.map.setType("adminParams");
    }

    private void addDefaults() {
        this.map.addServicePolicyDefaults(ParameterState.Info.ADMIN);
        this.setDisabled(false);
    }

    public ParameterMap getMap() {
        return this.map;
    }

    public void setAdminId(AdminId aid) {
        this.map.setParameter("adminId", Integer.toString(aid.getAdminInstanceId()));
    }

    public AdminId getAdminId() {
        return new AdminId(this.map.getOrZeroInt("adminId"));
    }

    public StorageNodeId getStorageNodeId() {
        return new StorageNodeId(this.map.getOrZeroInt("storageNodeId"));
    }

    public void setStorageNodeId(StorageNodeId snId) {
        this.map.setParameter("storageNodeId", Integer.toString(snId.getStorageNodeId()));
    }

    public void setHttpPort(int httpPort) {
        this.map.setParameter("adminHttpPort", Integer.toString(httpPort));
    }

    public int getHttpPort() {
        return this.map.getOrZeroInt("adminHttpPort");
    }

    public String getNodeHostPort() {
        return this.map.get("nodeHostPort").asString();
    }

    public int getWaitTimeout() {
        DurationParameter dp = (DurationParameter)this.map.get("waitTimeout");
        return (int)dp.getAmount();
    }

    public TimeUnit getWaitTimeoutUnit() {
        DurationParameter dp = (DurationParameter)this.map.get("waitTimeout");
        return dp.getUnit();
    }

    public void setDisabled(boolean disabled) {
        this.map.setParameter("disabled", Boolean.toString(disabled));
    }

    public boolean isDisabled() {
        return this.map.get("disabled").asBoolean();
    }

    public boolean createCSV() {
        return this.map.get("createCSV").asBoolean();
    }

    public int getLogFileCount() {
        return this.map.getOrZeroInt("adminLogFileCount");
    }

    public int getLogFileLimit() {
        return this.map.getOrZeroInt("adminLogFileLimit");
    }

    public long getPollPeriodMillis() {
        DurationParameter dp = (DurationParameter)this.map.get("collectorPollPeriod");
        return dp.toMillis();
    }

    public String getHelperHosts() {
        return this.map.get("helperHosts").asString();
    }

    public long getEventExpiryAge() {
        DurationParameter dp = (DurationParameter)this.map.get("eventExpiryAge");
        return dp.toMillis();
    }

    public void setEventExpiryAge(String age) {
        this.map.setParameter("eventExpiryAge", age);
    }

    public long getBroadcastTopoRetryDelayMillis() {
        return ParameterUtils.getDurationMillis(this.map, "broadcastTopoDelay");
    }

    public int getBroadcastTopoThreshold() {
        return this.map.getOrDefault("broadcastTopoThreshold").asInt();
    }

    public int getMaxTopoChanges() {
        return this.map.getOrDefault("maxTopoChanges").asInt();
    }

    public void setJEInfo(String nodeHostname, int haPort, String helperHostname, int helperPort) {
        this.setJEInfo(HostPortPair.getString(nodeHostname, haPort), HostPortPair.getString(helperHostname, helperPort));
    }

    public void setJEInfo(String nodeHostPort, String helperHost) {
        this.map.setParameter("nodeHostPort", nodeHostPort);
        this.map.setParameter("helperHosts", helperHost);
    }

    public int getAwaitRNConsistencyPeriod() {
        return (int)ParameterUtils.getDurationMillis(this.map, "waitRNConsistency");
    }

    public DurationParameter getServiceUnreachablePeriod() {
        return (DurationParameter)this.map.getOrDefault("waitUnreachableService");
    }

    public DurationParameter getAdminFailoverPeriod() {
        return (DurationParameter)this.map.getOrDefault("waitAdminFailover");
    }

    public DurationParameter getRNFailoverPeriod() {
        return (DurationParameter)this.map.getOrDefault("waitRNFailover");
    }

    public DurationParameter getCheckPartitionMigrationPeriod() {
        return (DurationParameter)this.map.getOrDefault("checkPartitionMigration");
    }

    public DurationParameter getCheckAddIndexPeriod() {
        return (DurationParameter)this.map.getOrDefault("checkAddIndex");
    }

    public void setHelperHost(String helpers) {
        this.map.setParameter("helperHosts", helpers);
    }

    public void setSessionLimit(String value) {
        this.map.setParameter("sessionLimit", value);
    }

    public int getSessionLimit() {
        return this.map.getOrDefault("sessionLimit").asInt();
    }

    public void setLoginCacheSize(String value) {
        this.map.setParameter("loginCacheSize", value);
    }

    public int getLoginCacheSize() {
        return this.map.getOrDefault("loginCacheSize").asInt();
    }
}

