/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.criticalevent;

import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.persist.model.Persistent;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.criticalevent.CriticalEvent;
import oracle.kv.impl.monitor.Monitor;
import oracle.kv.impl.monitor.Tracker;
import oracle.kv.impl.monitor.TrackerListenerImpl;
import oracle.kv.impl.monitor.views.LogTracker;
import oracle.kv.impl.monitor.views.PerfEvent;
import oracle.kv.impl.monitor.views.PerfTracker;
import oracle.kv.impl.monitor.views.ServiceChange;
import oracle.kv.impl.monitor.views.ServiceStatusTracker;
import oracle.kv.impl.util.registry.ServerSocketFactory;
import oracle.kv.impl.util.server.LoggerUtils;

public class EventRecorder {
    private final Admin admin;
    private final ServiceStatusTracker statusTracker;
    private final PerfTracker perfTracker;
    private final LogTracker logTracker;
    private final TrackerListenerImpl statusListener;
    private final TrackerListenerImpl perfListener;
    private final TrackerListenerImpl logListener;
    private Thread workerThread;
    private boolean workerThreadGo;
    private boolean isShutdown;
    private LatestEventTimestamps timestamps;
    private final List<SyncWaiter> syncWaiters = new ArrayList<SyncWaiter>();

    public EventRecorder(final Admin admin) {
        this.admin = admin;
        ServerSocketFactory ssf = admin.getParams().getStorageNodeParams().getAdminListenerSSF();
        try {
            this.statusListener = new Listener(ssf, 0L);
            this.perfListener = new Listener(ssf, 0L);
            this.logListener = new Listener(ssf, 0L);
        }
        catch (RemoteException re) {
            throw new IllegalStateException("Creating an event listener failed. ", re);
        }
        this.isShutdown = false;
        Monitor m = admin.getMonitor();
        this.statusTracker = m.getServiceChangeTracker();
        this.statusTracker.registerListener(this.statusListener);
        this.perfTracker = m.getPerfTracker();
        this.perfTracker.registerListener(this.perfListener);
        this.logTracker = m.getLogTracker();
        this.logTracker.registerListener(this.logListener);
        this.workerThread = new StoppableThread("eventRecorder"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    EventRecorder.this.eventRecorderWorker();
                }
                catch (Exception e) {
                    admin.shutdownForForeignThreadFault(e, "eventRecorder");
                }
                finally {
                    EventRecorder.this.workerThreadGo = false;
                    for (SyncWaiter s : EventRecorder.this.syncWaiters) {
                        s.setNotified();
                    }
                }
            }

            @Override
            protected Logger getLogger() {
                return admin.getLogger();
            }
        };
        this.workerThreadGo = false;
    }

    public void start(LatestEventTimestamps let) {
        this.timestamps = let;
        this.statusListener.setInterestingTime(let.getStatusTimestamp());
        this.perfListener.setInterestingTime(let.getPerfTimestamp());
        this.logListener.setInterestingTime(let.getLogTimestamp());
        this.workerThreadGo = true;
        this.workerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void eventRecorderWorker() {
        while (true) {
            Tracker.RetrievedEvents<LogRecord> logEventsContainer;
            Tracker.RetrievedEvents<PerfEvent> perfEventsContainer;
            block13: {
                Tracker.RetrievedEvents<ServiceChange> statusEventsContainer;
                EventRecorder eventRecorder = this;
                synchronized (eventRecorder) {
                    while (true) {
                        if (!this.workerThreadGo) {
                            return;
                        }
                        int nEvents = 0;
                        statusEventsContainer = this.statusTracker.retrieveNewEvents(this.timestamps.getStatusTimestamp());
                        nEvents += statusEventsContainer.size();
                        perfEventsContainer = this.perfTracker.retrieveNewEvents(this.timestamps.getPerfTimestamp());
                        nEvents += perfEventsContainer.size();
                        logEventsContainer = this.logTracker.retrieveNewEvents(this.timestamps.getLogTimestamp());
                        if ((nEvents += logEventsContainer.size()) != 0) {
                            // MONITOREXIT @DISABLED, blocks:[2, 4, 5, 12] lbl15 : MonitorExitStatement: MONITOREXIT : var7_7
                            if (statusEventsContainer.size() != 0) {
                                break;
                            }
                            break block13;
                        }
                        for (SyncWaiter s : this.syncWaiters) {
                            s.setNotified();
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                }
                long statusSince = statusEventsContainer.getLastSyntheticTimestamp();
                this.timestamps.setStatusTimestamp(statusSince);
                this.statusListener.setInterestingTime(statusSince);
                List<Tracker.EventHolder<ServiceChange>> statusEvents = statusEventsContainer.getRecordableEvents();
                if (statusEvents.size() != 0) {
                    this.storeStatusEvents(statusEvents);
                }
            }
            if (perfEventsContainer.size() != 0) {
                long perfSince = perfEventsContainer.getLastSyntheticTimestamp();
                this.timestamps.setPerfTimestamp(perfSince);
                this.perfListener.setInterestingTime(perfSince);
                List<Tracker.EventHolder<PerfEvent>> perfEvents = perfEventsContainer.getRecordableEvents();
                if (perfEvents.size() != 0) {
                    this.storePerfEvents(perfEvents);
                }
            }
            if (logEventsContainer.size() == 0) continue;
            long logSince = logEventsContainer.getLastSyntheticTimestamp();
            this.timestamps.setLogTimestamp(logSince);
            this.logListener.setInterestingTime(logSince);
            List<Tracker.EventHolder<LogRecord>> logEvents = logEventsContainer.getRecordableEvents();
            if (logEvents.size() == 0) continue;
            this.storeLogEvents(logEvents);
        }
    }

    private void storeStatusEvents(List<Tracker.EventHolder<ServiceChange>> statusEvents) {
        ArrayList<CriticalEvent> pevents = new ArrayList<CriticalEvent>();
        for (Tracker.EventHolder<ServiceChange> eh : statusEvents) {
            pevents.add(new CriticalEvent(eh.getSyntheticTimestamp(), eh.getEvent()));
        }
        this.admin.storeEvents(pevents, this.timestamps, CriticalEvent.EventType.STAT);
    }

    private void storePerfEvents(List<Tracker.EventHolder<PerfEvent>> perfEvents) {
        ArrayList<CriticalEvent> pevents = new ArrayList<CriticalEvent>();
        for (Tracker.EventHolder<PerfEvent> eh : perfEvents) {
            pevents.add(new CriticalEvent(eh.getSyntheticTimestamp(), eh.getEvent()));
        }
        this.admin.storeEvents(pevents, this.timestamps, CriticalEvent.EventType.PERF);
    }

    private void storeLogEvents(List<Tracker.EventHolder<LogRecord>> logEvents) {
        ArrayList<CriticalEvent> pevents = new ArrayList<CriticalEvent>();
        for (Tracker.EventHolder<LogRecord> eh : logEvents) {
            pevents.add(new CriticalEvent(eh.getSyntheticTimestamp(), eh.getEvent()));
        }
        this.admin.storeEvents(pevents, this.timestamps, CriticalEvent.EventType.LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        SyncWaiter mySyncWaiter = new SyncWaiter();
        Object object = this;
        synchronized (object) {
            if (!this.workerThreadGo) {
                return;
            }
            this.syncWaiters.add(mySyncWaiter);
            this.notify();
        }
        object = mySyncWaiter;
        synchronized (object) {
            while (!mySyncWaiter.notified) {
                try {
                    mySyncWaiter.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = this;
        synchronized (object) {
            this.syncWaiters.remove(mySyncWaiter);
        }
    }

    public void shutdown() {
        if (this.isShutdown) {
            this.admin.getLogger().info("EventRecorder already shut down");
            return;
        }
        this.isShutdown = true;
        this.sync();
        if (this.workerThreadGo) {
            this.workerThreadGo = false;
            this.workerThread.interrupt();
            try {
                this.workerThread.join();
            }
            catch (InterruptedException e) {
                this.admin.getLogger().warning("Interrupted while joining the worker thread.");
            }
        }
        this.statusTracker.removeListener(this.statusListener);
        this.perfTracker.removeListener(this.perfListener);
        this.logTracker.removeListener(this.logListener);
        try {
            UnicastRemoteObject.unexportObject(this.statusListener, true);
            UnicastRemoteObject.unexportObject(this.perfListener, true);
            UnicastRemoteObject.unexportObject(this.logListener, true);
        }
        catch (NoSuchObjectException nsoe) {
            String msg = "Unexporting a listener failed.";
            this.admin.getLogger().warning(msg + LoggerUtils.getStackTrace(nsoe));
        }
    }

    @Persistent
    public static class LatestEventTimestamps {
        long latestStatusEventTimestamp;
        long latestPerfEventTimestamp;
        long latestLogEventTimestamp;

        public LatestEventTimestamps(long s, long p, long l) {
            this.latestStatusEventTimestamp = s;
            this.latestPerfEventTimestamp = p;
            this.latestLogEventTimestamp = l;
        }

        public LatestEventTimestamps() {
        }

        public long getStatusTimestamp() {
            return this.latestStatusEventTimestamp;
        }

        public long getPerfTimestamp() {
            return this.latestPerfEventTimestamp;
        }

        public long getLogTimestamp() {
            return this.latestLogEventTimestamp;
        }

        public void setStatusTimestamp(long statusTimestamp) {
            this.latestStatusEventTimestamp = statusTimestamp;
        }

        public void setPerfTimestamp(long perfTimestamp) {
            this.latestPerfEventTimestamp = perfTimestamp;
        }

        public void setLogTimestamp(long logTimestamp) {
            this.latestLogEventTimestamp = logTimestamp;
        }
    }

    private class Listener
    extends TrackerListenerImpl {
        private static final long serialVersionUID = 1L;

        Listener(ServerSocketFactory ssf, long interestingTime) throws RemoteException {
            super(ssf, interestingTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyOfNewEvents() {
            EventRecorder eventRecorder = EventRecorder.this;
            synchronized (eventRecorder) {
                EventRecorder.this.notify();
            }
        }
    }

    private static class SyncWaiter {
        public boolean notified = false;

        private SyncWaiter() {
        }

        public synchronized void setNotified() {
            this.notified = true;
            this.notify();
        }
    }
}

