/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.criticalevent;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.KeyField;
import com.sleepycat.persist.model.Persistent;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.LogRecord;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.monitor.views.PerfEvent;
import oracle.kv.impl.monitor.views.ServiceChange;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.LogFormatter;
import oracle.kv.impl.util.server.LoggerUtils;

@Entity
public class CriticalEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @PrimaryKey
    EventKey key;
    private byte[] serializedEvent;
    private static EventFormatter ef = new EventFormatter();

    private CriticalEvent(EventKey key, Object event) {
        this.key = key;
        try {
            ByteArrayOutputStream bastream = new ByteArrayOutputStream();
            ObjectOutputStream oostream = new ObjectOutputStream(bastream);
            oostream.writeObject(event);
            oostream.close();
            this.serializedEvent = bastream.toByteArray();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("IOException while serializing event", ioe);
        }
    }

    public CriticalEvent(long timestamp, ServiceChange event) {
        this(new EventKey(timestamp, EventType.STAT), (Object)event);
    }

    public CriticalEvent(long timestamp, PerfEvent event) {
        this(new EventKey(timestamp, EventType.PERF), (Object)event);
    }

    public CriticalEvent(long timestamp, LogRecord event) {
        this(new EventKey(timestamp, EventType.LOG), (Object)event);
    }

    public CriticalEvent() {
    }

    public EventType getEventType() {
        return EventType.fromInternalString(this.key.getCategory());
    }

    public long getSyntheticTimestamp() {
        return this.key.getSyntheticTimestamp();
    }

    public String toString() {
        EventType t = this.getEventType();
        String s = this.key.toString() + " ";
        switch (t) {
            case STAT: {
                return s + ef.format(this.getStatusEvent());
            }
            case LOG: {
                return s + ef.format(this.getLogEvent());
            }
            case PERF: {
                return s + ef.format(this.getPerfEvent());
            }
        }
        assert (false);
        return null;
    }

    public String getDetailString() {
        EventType t = this.getEventType();
        String s = this.key.toString() + " ";
        switch (t) {
            case STAT: {
                return s + ef.formatDetail(this.getStatusEvent());
            }
            case LOG: {
                return s + ef.formatDetail(this.getLogEvent());
            }
            case PERF: {
                return s + ef.formatDetail(this.getPerfEvent());
            }
        }
        assert (false);
        return null;
    }

    public ServiceChange getStatusEvent() {
        if (this.getEventType() != EventType.STAT) {
            throw new NonfatalAssertionException("Attempt to get wrong event type");
        }
        return (ServiceChange)this.decodeSerializedEvent();
    }

    public static String formatStatusEvent(ServiceChange statusEvent) {
        return ef.format(statusEvent);
    }

    public PerfEvent getPerfEvent() {
        if (this.getEventType() != EventType.PERF) {
            throw new NonfatalAssertionException("Attempt to get wrong event type");
        }
        return (PerfEvent)this.decodeSerializedEvent();
    }

    public LogRecord getLogEvent() {
        if (this.getEventType() != EventType.LOG) {
            throw new NonfatalAssertionException("Attempt to get wrong event type");
        }
        return (LogRecord)this.decodeSerializedEvent();
    }

    public static String formatLogEvent(LogRecord logRecord) {
        return ef.format(logRecord);
    }

    public void persist(EntityStore estore, Transaction txn) {
        PrimaryIndex<EventKey, CriticalEvent> pi = estore.getPrimaryIndex(EventKey.class, CriticalEvent.class);
        pi.put(txn, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CriticalEvent> fetch(EntityStore estore, Transaction txn, long startTime, long endTime, EventType type) {
        PrimaryIndex<EventKey, CriticalEvent> pi = estore.getPrimaryIndex(EventKey.class, CriticalEvent.class);
        EventKey startKey = new EventKey(startTime, type);
        EventKey endKey = new EventKey(endTime == 0L ? Long.MAX_VALUE : endTime, type);
        ArrayList<CriticalEvent> events = new ArrayList<CriticalEvent>();
        try (EntityCursor eventCursor = pi.entities(txn, startKey, true, endKey, false, CursorConfig.READ_UNCOMMITTED);){
            for (CriticalEvent ev : eventCursor) {
                if (type != EventType.ALL && !type.equals((Object)ev.getEventType())) continue;
                events.add(ev);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ageStore(EntityStore estore, Transaction txn, long pruningAge) {
        PrimaryIndex<EventKey, CriticalEvent> pi = estore.getPrimaryIndex(EventKey.class, CriticalEvent.class);
        long expiry = new Date().getTime() - pruningAge;
        EventKey startKey = new EventKey(0L, EventType.ALL);
        EventKey endKey = new EventKey(expiry, EventType.ALL);
        try (EntityCursor eventCursor = pi.entities(txn, startKey, true, endKey, true, CursorConfig.READ_UNCOMMITTED);){
            CriticalEvent ev = (CriticalEvent)eventCursor.first();
            while (ev != null) {
                eventCursor.delete();
                ev = (CriticalEvent)eventCursor.next();
            }
        }
    }

    public static CriticalEvent fetch(EntityStore estore, Transaction txn, String eventId) {
        PrimaryIndex<EventKey, CriticalEvent> pi = estore.getPrimaryIndex(EventKey.class, CriticalEvent.class);
        return pi.get(txn, EventKey.fromString(eventId), LockMode.READ_UNCOMMITTED);
    }

    public EventKey getKey() {
        return this.key;
    }

    private Object decodeSerializedEvent() {
        Object o = null;
        try {
            ObjectInputStream oistream = new ObjectInputStream(new ByteArrayInputStream(this.serializedEvent));
            o = oistream.readObject();
            oistream.close();
        }
        catch (Exception e) {
            throw new IllegalStateException("Trouble deserializing an event record.", e);
        }
        return o;
    }

    private static class EventFormatter
    extends LogFormatter {
        public EventFormatter() {
            super(null);
        }

        @Override
        public String format(LogRecord record) {
            return this.format(record, false);
        }

        public String formatDetail(LogRecord record) {
            return this.format(record, true);
        }

        private String format(LogRecord record, boolean detail) {
            int n;
            StringBuilder sb = new StringBuilder("LOG  ");
            sb.append(this.getDate(record.getMillis()));
            sb.append(" ");
            sb.append(record.getLevel().getLocalizedName());
            sb.append(" ");
            String formattedMessage = this.formatMessage(record);
            if (!detail && (n = formattedMessage.indexOf(10)) != -1) {
                formattedMessage = formattedMessage.substring(0, n);
            }
            sb.append(formattedMessage);
            Throwable t = record.getThrown();
            if (t != null && detail) {
                sb.append(LoggerUtils.getStackTrace(t));
            }
            return sb.toString();
        }

        public String format(ServiceChange record) {
            StringBuilder sb = new StringBuilder("STAT ");
            sb.append(this.getDate(record.getChangeTime()));
            sb.append(" ");
            ResourceId target = record.getTarget();
            sb.append(target.toString());
            sb.append(" ");
            sb.append(record.getStatus().toString());
            sb.append(" sev");
            sb.append(Integer.toString(record.getSeverity()));
            ResourceId reporter = record.getReporter();
            if (!target.equals(reporter)) {
                sb.append(" ");
                sb.append("(reported by " + reporter.toString() + ")");
            }
            return sb.toString();
        }

        public String formatDetail(ServiceChange record) {
            return this.format(record);
        }

        public String format(PerfEvent record) {
            StringBuilder sb = new StringBuilder("PERF ");
            sb.append(this.getDate(record.getChangeTime()));
            sb.append(" ");
            ResourceId target = record.getResourceId();
            sb.append(target.toString());
            sb.append(" ");
            sb.append(record.getSingleInt());
            sb.append(" ");
            sb.append("replicaLagMs=" + record.getCommitLagMs());
            sb.append(" ");
            sb.append(record.getMultiInt());
            return sb.toString();
        }

        public String formatDetail(PerfEvent record) {
            StringBuilder sb = new StringBuilder("PERF ");
            sb.append(record.getColumnFormatted());
            return sb.toString();
        }
    }

    @Persistent
    public static class EventKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @KeyField(value=1)
        long syntheticTimestamp;
        @KeyField(value=2)
        String category;
        private static final char[] ENCODING_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'L', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        private static final char[] DECODING_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        private static final int BASE = ENCODING_DIGITS.length;

        public EventKey(long syntheticTimeStamp, EventType category) {
            this.syntheticTimestamp = syntheticTimeStamp;
            this.category = category.toInternalString();
        }

        public EventKey() {
        }

        public long getSyntheticTimestamp() {
            return this.syntheticTimestamp;
        }

        public String getCategory() {
            return this.category;
        }

        public String toString() {
            return EventKey.encode(this.syntheticTimestamp) + this.category;
        }

        public static EventKey fromString(String s) {
            int len = s.length();
            String catInitial = s.substring(len - 1, len).toUpperCase();
            EventType type = EventType.fromInternalString(catInitial);
            String tstr = s.substring(0, len - 1);
            long tval = EventKey.decode(tstr);
            return new EventKey(tval, type);
        }

        private static String encode(long value) {
            StringBuilder sb = new StringBuilder();
            if (value == 0L) {
                sb.append("0");
            }
            while (value != 0L) {
                int remainder = (int)(value % (long)BASE);
                sb.insert(0, ENCODING_DIGITS[remainder]);
                value /= (long)BASE;
            }
            return sb.toString();
        }

        private static long decode(String s) {
            long value = 0L;
            long place = 1L;
            char[] c = s.toUpperCase().toCharArray();
            for (int i = c.length - 1; i >= 0; --i) {
                value += (long)Arrays.binarySearch(DECODING_DIGITS, c[i]) * place;
                place *= (long)BASE;
            }
            return value;
        }
    }

    public static enum EventType {
        ALL(""),
        STAT("S"),
        PERF("P"),
        LOG("L");

        private String internalValue;

        private EventType(String internalValue) {
            this.internalValue = internalValue;
        }

        public String toInternalString() {
            return this.internalValue;
        }

        public static EventType fromInternalString(String s) {
            EventType value = ALL;
            for (EventType et : EnumSet.allOf(EventType.class)) {
                if (!et.toInternalString().equals(s)) continue;
                value = et;
            }
            return value;
        }
    }
}

