/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.api.avro.AvroDdl;
import oracle.kv.impl.api.table.ArrayBuilder;
import oracle.kv.impl.api.table.MapBuilder;
import oracle.kv.impl.api.table.RecordBuilder;
import oracle.kv.impl.api.table.TableBuilder;
import oracle.kv.impl.api.table.TableBuilderBase;
import oracle.kv.impl.api.table.TableEvolver;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.table.FieldDef;
import oracle.kv.table.Table;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;

class TableCommand
extends CommandWithSubs {
    static final String TABLE_NAME_FLAG = "-name";
    static final String DESC_FLAG = "-desc";
    static final String CREATE_FLAG = "-create";
    static final String EVOLVE_FLAG = "-evolve";
    static final String R2_COMPAT = "-r2-compat";
    static final String ALL_FLAG = "-all";
    static final String ORIGINAL_FLAG = "-original";
    static final String FIELD_NAME_FLAG = "-name";
    static final String FIELD_FLAG = "-field";
    static final String TYPE_FLAG = "-type";
    static final String DEFAULT_FLAG = "-default";
    static final String NOT_NULLABLE_FLAG = "-not-nullable";
    static final String MAX_FLAG = "-max";
    static final String MIN_FLAG = "-min";
    static final String SIZE_FLAG = "-size";
    static final String MAXEXCL_FLAG = "-max-exclusive";
    static final String MINEXCL_FLAG = "-min-exclusive";
    static final String ENUM_VALUE_FLAG = "-enum-values";
    static final String SCHEMA_NAME_FLAG = "-name";
    static final String TABLE_NAME_FLAG_DESC = "-name <name>";
    static final String DESC_FLAG_DESC = "-desc <description>";
    static final String CREATE_FLAG_DESC = "-create";
    static final String EVOLVE_FLAG_DESC = "-evolve";
    static final String R2_COMPAT_DESC = "-r2-compat";
    static final String ALL_FLAG_DESC = "-all";
    static final String ORIGINAL_FLAG_DESC = "-original";
    static final String FIELD_NAME_FLAG_DESC = "-name <name>";
    static final String FIELD_FLAG_DESC = "-field <name>";
    static final String TYPE_FLAG_DESC = "-type <type>";
    static final String DEFAULT_FLAG_DESC = "-default <value>";
    static final String NOT_NULLABLE_FLAG_DESC = "-not-nullable";
    static final String MAX_FLAG_DESC = "-max <value>";
    static final String MIN_FLAG_DESC = "-min <value>";
    static final String SIZE_FLAG_DESC = "-size <size>";
    static final String MAXEXCL_FLAG_DESC = "-max-exclusive";
    static final String MINEXCL_FLAG_DESC = "-min-exclusive";
    static final String ENUM_VALUE_FLAG_DESC = "-enum-values <value[,value[,...]]>";
    static final String SCHEMA_NAME_FLAG_DESC = "-name <schema-name>";
    private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new TableClearSub(), new TableCreateSub(), new TableEvolveSub(), new TableListSub());

    TableCommand() {
        super(subs, "table", 3, 2);
    }

    @Override
    protected String getCommandOverview() {
        return "The table command encapsulates commands for building tables for addition or evolution. " + eol + "Tables are created and modified in two steps.  " + "The table command creates new tables or" + eol + "evolves existing tables and saves them in temporary, " + "non-persistent storage in the admin" + eol + "client.  These tables are kept by name when exiting the create " + "and evolve sub-commands. " + eol + "The second step is to use the plan command to deploy " + "the new and changed tables" + eol + "to the store itself.  The temporary list of tables " + "can be examined and cleared using" + eol + "the list and clear sub-commands.";
    }

    private static Table findTable(String tableName, boolean mustExist, Shell shell) throws ShellException {
        CommandShell cmd = (CommandShell)shell;
        CommandServiceAPI cs = cmd.getAdmin();
        TableMetadata meta = null;
        try {
            meta = cs.getMetadata(TableMetadata.class, Metadata.MetadataType.TABLE);
            if (meta != null) {
                return meta.getTable(tableName, mustExist);
            }
        }
        catch (RemoteException re) {
            cmd.noAdmin(re);
        }
        catch (IllegalStateException ise) {
            throw new ShellException(ise.getMessage(), ise);
        }
        catch (IllegalArgumentException iae) {
            throw new ShellException(iae.getMessage(), iae);
        }
        if (mustExist) {
            throw new ShellException("Table does not exist: " + TableCommand.makeTableFullName(null, tableName));
        }
        return null;
    }

    private static Object getCurrentCmdVariable(Shell shell, String varName) {
        return shell.getCurrentCommand().getVariable(varName);
    }

    private static String makeTableFullName(TableBuilderBase tb) {
        String tableName = null;
        String parentName = null;
        if (tb instanceof TableBuilder) {
            tableName = ((TableBuilder)tb).getName();
            if (((TableBuilder)tb).getParent() != null) {
                parentName = ((TableBuilder)tb).getParent().getFullName();
            }
            return TableCommand.makeTableFullName(tableName, parentName);
        }
        if (tb instanceof TableEvolver) {
            return ((TableEvolver)tb).getTable().getFullName();
        }
        return null;
    }

    private static String makeTableFullName(String name, String tableName) {
        return TableMetadata.makeQualifiedName(name, tableName);
    }

    static class TableBuildCancelSub
    extends TableBuildSubCommand {
        protected TableBuildCancelSub() {
            super("cancel", 4);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            if (args.length != 1) {
                shell.badArgCount(this);
            }
            shell.popCurrentCommand();
            return null;
        }

        @Override
        protected String getCommandDescription() {
            return "Exit the building operation, canceling the table(or field)" + eolt + "under construction.";
        }
    }

    static class TableBuildExitSub
    extends TableBuildSubCommand {
        protected TableBuildExitSub() {
            super("exit", 2);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            if (args.length != 1) {
                shell.badArgCount(this);
            }
            TableBuilderBase tb = this.getCurrentTableBuilder();
            String retString = null;
            retString = tb instanceof TableBuilder ? this.procAddTable((TableBuilder)tb, shell) : (tb instanceof TableEvolver ? this.procEvolveTable((TableEvolver)tb, shell) : this.procFieldBuilder(tb, this.getCurrentTableBuilderName(), shell));
            return retString;
        }

        private String procAddTable(TableBuilder tbr, Shell shell) throws ShellException {
            try {
                tbr.validate();
            }
            catch (IllegalArgumentException iae) {
                throw new ShellException(iae.getMessage(), iae);
            }
            catch (IllegalCommandException ice) {
                throw new ShellException(ice.getMessage(), ice);
            }
            shell.addVariable(TableCommand.makeTableFullName(tbr), tbr);
            shell.popCurrentCommand();
            return "Table " + TableCommand.makeTableFullName(tbr) + " built.";
        }

        private String procEvolveTable(TableEvolver te, Shell shell) throws ShellException {
            try {
                te.evolveTable();
            }
            catch (IllegalCommandException ice) {
                throw new ShellException(ice.getMessage(), ice);
            }
            shell.addVariable(TableCommand.makeTableFullName(te), te);
            shell.popCurrentCommand();
            return "Table " + TableCommand.makeTableFullName(te) + " built.";
        }

        private String procFieldBuilder(TableBuilderBase tb, String varName, Shell shell) throws ShellException {
            FieldDef fieldDef = null;
            try {
                fieldDef = tb.build();
            }
            catch (IllegalArgumentException iae) {
                throw new ShellException(iae.getMessage(), iae);
            }
            shell.popCurrentCommand();
            ShellCommand cmd = shell.getCurrentCommand();
            cmd.addVariable(varName, fieldDef);
            String ftype = this.getComplexFieldBuilderType(tb);
            if (ftype == null) {
                throw new ShellException("Unsupported field type.");
            }
            shell.runLine("add-field -name " + varName + " -type " + ftype);
            return null;
        }

        private String getComplexFieldBuilderType(TableBuilderBase tb) {
            if (tb instanceof MapBuilder) {
                return "map";
            }
            if (tb instanceof ArrayBuilder) {
                return "array";
            }
            if (tb instanceof RecordBuilder) {
                return "record";
            }
            return null;
        }

        @Override
        protected String getCommandDescription() {
            return "Exit the building operation, saving the table(or field) " + eolt + "for addition(or evolution) to the store.";
        }
    }

    static class TableBuildShowSub
    extends TableBuildSubCommand {
        protected TableBuildShowSub() {
            super("show", 2);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            boolean showOriginal = false;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-original".equals(arg)) {
                    showOriginal = true;
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            TableBuilderBase tb = this.getCurrentTableBuilder();
            try {
                if (tb instanceof TableBuilder) {
                    return ((TableBuilder)tb).toJsonString(true);
                }
                if (tb instanceof TableEvolver) {
                    if (showOriginal) {
                        return ((TableEvolver)tb).getTable().toJsonString(true);
                    }
                    return ((TableEvolver)tb).toJsonString(true);
                }
                if (tb instanceof MapBuilder) {
                    return ((MapBuilder)tb).toJsonString(true);
                }
                if (tb instanceof ArrayBuilder) {
                    return ((ArrayBuilder)tb).toJsonString(true);
                }
                if (tb instanceof RecordBuilder) {
                    return ((RecordBuilder)tb).toJsonString(true);
                }
            }
            catch (IllegalCommandException ice) {
                throw new ShellException("Could not create JSON representation:" + eolt + ice.getMessage(), ice);
            }
            catch (IllegalArgumentException iae) {
                throw new ShellException("Could not create JSON representation:" + eolt + iae.getMessage(), iae);
            }
            return "";
        }

        @Override
        protected String getCommandSyntax() {
            return "show [-original]";
        }

        @Override
        protected String getCommandDescription() {
            return "Display the table information, if building a table for evolution, " + eolt + "use " + "-original" + " flag to show the original table information, the flag " + eolt + "will be ignored for building table for addition.";
        }
    }

    static class TableBuildSetDescSub
    extends TableBuildSubCommand {
        protected TableBuildSetDescSub() {
            super("set-description", 5);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String description = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (TableCommand.DESC_FLAG.equals(arg)) {
                    description = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (description == null) {
                shell.requiredArg(TableCommand.DESC_FLAG, this);
            }
            this.getCurrentTableBuilder().setDescription(description);
            return null;
        }

        @Override
        protected String getCommandSyntax() {
            return "set-description -desc <description>";
        }

        @Override
        protected String getCommandDescription() {
            return "Set description for the table.";
        }
    }

    static class TableBuildShardKeySub
    extends TableBuildSubCommand {
        protected TableBuildShardKeySub() {
            super("shard-key", 4);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (TableCommand.FIELD_FLAG.equals(arg)) {
                    fields.add(Shell.nextArg(args, i++, this));
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (fields.size() == 0) {
                shell.requiredArg(TableCommand.FIELD_FLAG, this);
            }
            TableBuilderBase tb = this.getCurrentTableBuilder();
            try {
                tb.shardKey(fields.toArray(new String[fields.size()]));
            }
            catch (IllegalArgumentException iae) {
                throw new ShellException(iae.getMessage(), iae);
            }
            return null;
        }

        @Override
        protected String getCommandSyntax() {
            return "shard-key -field <name> [-field <name>]*";
        }

        @Override
        protected String getCommandDescription() {
            return "Set shard key.";
        }
    }

    static class TableBuildPrimaryKeySub
    extends TableBuildSubCommand {
        protected TableBuildPrimaryKeySub() {
            super("primary-key", 4);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (TableCommand.FIELD_FLAG.equals(arg)) {
                    fields.add(Shell.nextArg(args, i++, this));
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (fields.size() == 0) {
                shell.requiredArg(TableCommand.FIELD_FLAG, this);
            }
            TableBuilderBase tb = this.getCurrentTableBuilder();
            try {
                tb.primaryKey(fields.toArray(new String[fields.size()]));
            }
            catch (IllegalArgumentException iae) {
                throw new ShellException(iae.getMessage(), iae);
            }
            return null;
        }

        @Override
        protected String getCommandSyntax() {
            return "primary-key -field <name> [-field <name>]*";
        }

        @Override
        protected String getCommandDescription() {
            return "Set primary key.";
        }
    }

    static class TableBuildAddSchemaSub
    extends TableBuildSubCommand {
        protected TableBuildAddSchemaSub() {
            super("add-schema", 5);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String schemaName = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-name".equals(arg)) {
                    schemaName = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (schemaName == null) {
                shell.requiredArg("-name", this);
            }
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            AvroDdl.SchemaDetails schema = this.getSchemaDetails(cs, schemaName, cmd);
            TableBuilder tb = (TableBuilder)this.getCurrentTableBuilder();
            try {
                tb.setSchemaId(schema.getId());
                tb.addSchema(schema.getText());
            }
            catch (IllegalArgumentException iae) {
                throw new ShellException(iae.getMessage(), iae);
            }
            catch (IllegalCommandException ice) {
                throw new ShellException(ice.getMessage(), ice);
            }
            return null;
        }

        private AvroDdl.SchemaDetails getSchemaDetails(CommandServiceAPI cs, String schemaName, CommandShell shell) throws ShellException {
            try {
                SortedMap<String, AvroDdl.SchemaSummary> map = cs.getSchemaSummaries(false);
                AvroDdl.SchemaSummary summary = (AvroDdl.SchemaSummary)map.get(schemaName);
                if (summary != null) {
                    return cs.getSchemaDetails(summary.getId());
                }
            }
            catch (RemoteException re) {
                shell.noAdmin(re);
            }
            throw new ShellException("Schema does not exist or is disabled: " + schemaName);
        }

        @Override
        protected String getCommandSyntax() {
            return "add-schema -name <schema-name>";
        }

        @Override
        protected String getCommandDescription() {
            return "Build a table from Avro schema.";
        }
    }

    static class TableBuildRemoveFieldSub
    extends TableBuildSubCommand {
        protected TableBuildRemoveFieldSub() {
            super("remove-field", 4);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String field = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-name".equals(arg)) {
                    field = Shell.nextArg(args, i++, this);
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (field == null) {
                shell.requiredArg("-name", this);
            }
            try {
                this.getCurrentTableBuilder().removeField(field);
            }
            catch (IllegalArgumentException iae) {
                throw new ShellException(iae.getMessage());
            }
            return null;
        }

        @Override
        protected String getCommandSyntax() {
            return "remove-field -name <name>";
        }

        @Override
        protected String getCommandDescription() {
            return "Remove a field.";
        }
    }

    static class TableBuildAddRecordSub
    extends ComplexFieldBuilderSub {
        private static TableBuildCmdWithSubs builderSubs = new RecordBuilderSubs();

        TableBuildAddRecordSub() {
            super("add-record-field", 5);
        }

        @Override
        TableBuildCmdWithSubs getFieldBuilderSubs() {
            return builderSubs;
        }

        @Override
        TableBuilderBase createFieldBuilder(String fname, String desc) {
            return TableBuilder.createRecordBuilder(fname, desc);
        }

        @Override
        protected String getCommandSyntax() {
            return "add-record-field -name <name> -desc <description>";
        }

        @Override
        protected String getCommandDescription() {
            return "Build a record field.";
        }

        private static class RecordBuilderSubs
        extends TableBuildCmdWithSubs {
            private static final List<? extends CommandWithSubs.SubCommand> recordBuilderSubs = Arrays.asList(new TableBuildAddArraySub(), new TableBuildAddFieldSub(), new TableBuildAddMapSub(), new TableBuildAddRecordSub(), new TableBuildCancelSub(), new TableBuildExitSub(), new TableBuildSetDescSub(), new TableBuildShowSub());

            RecordBuilderSubs() {
                super(recordBuilderSubs, "", 0, 2);
            }

            @Override
            public String getCommandOverview() {
                return "Build a record field.";
            }
        }
    }

    static class TableBuildAddArraySub
    extends ComplexFieldBuilderSub {
        private static TableBuildCmdWithSubs builderSubs = new ArrayBuilderSubs();

        TableBuildAddArraySub() {
            super("add-array-field", 5);
        }

        @Override
        TableBuildCmdWithSubs getFieldBuilderSubs() {
            return builderSubs;
        }

        @Override
        TableBuilderBase createFieldBuilder(String fname, String desc) {
            return TableBuilder.createArrayBuilder(desc);
        }

        @Override
        protected String getCommandSyntax() {
            return "add-array-field -name <name> -desc <description>";
        }

        @Override
        protected String getCommandDescription() {
            return "Build a array field.";
        }

        private static class ArrayBuilderSubs
        extends TableBuildCmdWithSubs {
            private static final List<? extends CommandWithSubs.SubCommand> arraybuilderSubs = Arrays.asList(new TableBuildAddArraySub(), new TableBuildAddFieldSub(), new TableBuildAddMapSub(), new TableBuildAddRecordSub(), new TableBuildCancelSub(), new TableBuildExitSub(), new TableBuildSetDescSub(), new TableBuildShowSub());

            ArrayBuilderSubs() {
                super(arraybuilderSubs, "", 0, 2);
            }

            @Override
            public String getCommandOverview() {
                return "Build a array field.";
            }
        }
    }

    static class TableBuildAddMapSub
    extends ComplexFieldBuilderSub {
        private static TableBuildCmdWithSubs builderSubs = new MapBuilderSubs();

        TableBuildAddMapSub() {
            super("add-map-field", 5);
        }

        @Override
        TableBuildCmdWithSubs getFieldBuilderSubs() {
            return builderSubs;
        }

        @Override
        TableBuilderBase createFieldBuilder(String fname, String desc) {
            return TableBuilder.createMapBuilder(desc);
        }

        @Override
        protected String getCommandSyntax() {
            return "add-map-field -name <name> -desc <description>";
        }

        @Override
        protected String getCommandDescription() {
            return "Build a map field.";
        }

        private static class MapBuilderSubs
        extends TableBuildCmdWithSubs {
            private static final List<? extends CommandWithSubs.SubCommand> mapBuilderSubs = Arrays.asList(new TableBuildAddArraySub(), new TableBuildAddFieldSub(), new TableBuildAddMapSub(), new TableBuildAddRecordSub(), new TableBuildCancelSub(), new TableBuildExitSub(), new TableBuildSetDescSub(), new TableBuildShowSub());

            MapBuilderSubs() {
                super(mapBuilderSubs, "", 0, 2);
            }

            @Override
            public String getCommandOverview() {
                return "Build a map field.";
            }
        }
    }

    static abstract class ComplexFieldBuilderSub
    extends TableBuildSubCommand {
        private static final String VAR_BUILDER = "CurrentFieldBuilder";
        static final String commonUsage = "-name <name> -desc <description>";

        protected ComplexFieldBuilderSub(String name, int prefixMatchLength) {
            super(name, prefixMatchLength);
        }

        abstract TableBuildCmdWithSubs getFieldBuilderSubs();

        abstract TableBuilderBase createFieldBuilder(String var1, String var2);

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            TableBuilderVariable tbv = (TableBuilderVariable)this.getVariable(VAR_BUILDER);
            if (tbv == null) {
                Shell.checkHelp(args, this);
                String fname = null;
                String desc = null;
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if ("-name".equals(arg)) {
                        fname = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (TableCommand.DESC_FLAG.equals(arg)) {
                        desc = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                }
                if (fname == null) {
                    shell.requiredArg("-name", this);
                }
                tbv = new TableBuilderVariable(fname, this.createFieldBuilder(fname, desc));
                ShellCommand cmd = this.clone();
                cmd.addVariable(VAR_BUILDER, tbv);
                cmd.setPrompt(fname);
                shell.pushCurrentCommand(cmd);
                return null;
            }
            return this.getFieldBuilderSubs().execute(tbv, args, shell);
        }
    }

    static class TableBuildAddFieldSub
    extends TableBuildSubCommand {
        protected TableBuildAddFieldSub() {
            super("add-field", 5);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String fname = null;
            FieldDef.Type type = null;
            String defVal = null;
            Boolean nullable = null;
            String max = null;
            String min = null;
            Boolean maxExcl = null;
            Boolean minExcl = null;
            String size = null;
            String desc = null;
            String[] values = null;
            TableBuilderBase tb = this.getCurrentTableBuilder();
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-name".equals(arg)) {
                    fname = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (TableCommand.TYPE_FLAG.equals(arg)) {
                    String ftype;
                    if ((type = this.getType(ftype = Shell.nextArg(args, i++, this))) != null) continue;
                    shell.invalidArgument(ftype, this);
                    continue;
                }
                if (TableCommand.DESC_FLAG.equals(arg)) {
                    desc = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (TableCommand.DEFAULT_FLAG.equals(arg)) {
                    defVal = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-not-nullable".equals(arg)) {
                    nullable = false;
                    continue;
                }
                if (TableCommand.MAX_FLAG.equals(arg)) {
                    max = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (TableCommand.MIN_FLAG.equals(arg)) {
                    min = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-max-exclusive".equals(arg)) {
                    maxExcl = true;
                    continue;
                }
                if ("-min-exclusive".equals(arg)) {
                    minExcl = true;
                    continue;
                }
                if (TableCommand.SIZE_FLAG.equals(arg)) {
                    size = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (TableCommand.ENUM_VALUE_FLAG.equals(arg)) {
                    String str = Shell.nextArg(args, i++, this);
                    values = str.trim().split("\\,");
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (type == null) {
                shell.requiredArg(TableCommand.TYPE_FLAG, this);
            }
            if (!tb.isCollectionBuilder() || this.isComplexType(type)) {
                if (fname == null) {
                    shell.requiredArg("-name", this);
                }
            } else if (fname != null) {
                fname = null;
            }
            if (type == FieldDef.Type.ENUM && values == null) {
                shell.requiredArg(TableCommand.ENUM_VALUE_FLAG, this);
            }
            if (min != null || max != null) {
                this.validateProperty(tb, type, TableCommand.MIN_FLAG, shell);
            }
            if (nullable != null) {
                this.validateProperty(tb, type, "-not-nullable", shell);
            }
            if (defVal != null) {
                this.validateProperty(tb, type, TableCommand.DEFAULT_FLAG, shell);
            }
            if (minExcl != null || maxExcl != null) {
                this.validateProperty(tb, type, "-min-exclusive", shell);
            }
            if (size != null) {
                this.validateProperty(tb, type, TableCommand.SIZE_FLAG, shell);
            }
            if (values != null) {
                this.validateProperty(tb, type, TableCommand.ENUM_VALUE_FLAG, shell);
            }
            this.addField(shell, tb, fname, type, defVal, nullable, min, max, minExcl, maxExcl, size, desc, values);
            return null;
        }

        private void validateProperty(TableBuilderBase tabBuilder, FieldDef.Type type, String propFlag, Shell shell) throws ShellException {
            if (propFlag.equals(TableCommand.MIN_FLAG)) {
                if (type == FieldDef.Type.BOOLEAN || type == FieldDef.Type.BINARY || type == FieldDef.Type.ENUM || type == FieldDef.Type.FIXED_BINARY) {
                    shell.invalidArgument("-min and -max is not allowed for type " + (Object)((Object)type), this);
                }
            } else if (propFlag.equals(TableCommand.DEFAULT_FLAG) || propFlag.equals("-not-nullable")) {
                if (tabBuilder.isCollectionBuilder() || type == FieldDef.Type.BINARY || type == FieldDef.Type.FIXED_BINARY) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(propFlag);
                    sb.append(" is not allowed for ");
                    if (tabBuilder.isCollectionBuilder()) {
                        sb.append("the type field of ");
                        sb.append(tabBuilder.getBuilderType());
                    } else {
                        sb.append("type ");
                        sb.append((Object)type);
                    }
                    shell.invalidArgument(sb.toString(), this);
                }
            } else if (propFlag.equals("-min-exclusive")) {
                if (type != FieldDef.Type.STRING) {
                    shell.invalidArgument("-min-exclusive and -max-exclusive can only be used with " + (Object)((Object)FieldDef.Type.STRING), this);
                }
            } else if (propFlag.equals(TableCommand.SIZE_FLAG)) {
                if (type != FieldDef.Type.FIXED_BINARY) {
                    shell.invalidArgument("-size can only be used with " + (Object)((Object)FieldDef.Type.FIXED_BINARY), this);
                }
            } else if (propFlag.equals(TableCommand.ENUM_VALUE_FLAG) && type != FieldDef.Type.ENUM) {
                shell.invalidArgument("-enum-values can only be used with " + (Object)((Object)FieldDef.Type.ENUM), this);
            }
        }

        private FieldDef.Type getType(String type) {
            try {
                return FieldDef.Type.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }

        private void addField(Shell shell, TableBuilderBase tabBuilder, String fname, FieldDef.Type type, String defVal, Boolean nullable, String min, String max, Boolean minExcl, Boolean maxExcl, String size, String desc, String[] values) throws ShellException {
            switch (type) {
                case INTEGER: {
                    Integer idef = null;
                    Integer imax = null;
                    Integer imin = null;
                    if (defVal != null) {
                        idef = this.getValidIntVal(shell, defVal);
                    }
                    if (min != null) {
                        imin = this.getValidIntVal(shell, min);
                    }
                    if (max != null) {
                        imax = this.getValidIntVal(shell, max);
                    }
                    try {
                        tabBuilder.addInteger(fname, desc, nullable, idef, imin, imax);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ShellException(iae.getMessage(), iae);
                    }
                    catch (IllegalCommandException ice) {
                        throw new ShellException(ice.getMessage(), ice);
                    }
                }
                case LONG: {
                    Long ldef = null;
                    Long lmax = null;
                    Long lmin = null;
                    if (defVal != null) {
                        ldef = this.getValidLongVal(shell, defVal);
                    }
                    if (min != null) {
                        lmin = this.getValidLongVal(shell, min);
                    }
                    if (max != null) {
                        lmax = this.getValidLongVal(shell, max);
                    }
                    try {
                        tabBuilder.addLong(fname, desc, nullable, ldef, lmin, lmax);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ShellException(iae.getMessage(), iae);
                    }
                    catch (IllegalCommandException ice) {
                        throw new ShellException(ice.getMessage(), ice);
                    }
                }
                case DOUBLE: {
                    Double ddef = null;
                    Double dmax = null;
                    Double dmin = null;
                    if (defVal != null) {
                        ddef = this.getValidDoubleVal(shell, defVal);
                    }
                    if (min != null) {
                        dmin = this.getValidDoubleVal(shell, min);
                    }
                    if (max != null) {
                        dmax = this.getValidDoubleVal(shell, max);
                    }
                    try {
                        tabBuilder.addDouble(fname, desc, nullable, ddef, dmin, dmax);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ShellException(iae.getMessage(), iae);
                    }
                    catch (IllegalCommandException ice) {
                        throw new ShellException(ice.getMessage(), ice);
                    }
                }
                case FLOAT: {
                    Float fdef = null;
                    Float fmax = null;
                    Float fmin = null;
                    if (defVal != null) {
                        fdef = this.getValidFloatVal(shell, defVal);
                    }
                    if (min != null) {
                        fmin = this.getValidFloatVal(shell, min);
                    }
                    if (max != null) {
                        fmax = this.getValidFloatVal(shell, max);
                    }
                    try {
                        tabBuilder.addFloat(fname, desc, nullable, fdef, fmin, fmax);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ShellException(iae.getMessage(), iae);
                    }
                    catch (IllegalCommandException ice) {
                        throw new ShellException(ice.getMessage(), ice);
                    }
                }
                case STRING: {
                    try {
                        tabBuilder.addString(fname, desc, nullable, defVal, min, max, minExcl != null ? Boolean.valueOf(minExcl == false) : null, maxExcl != null ? Boolean.valueOf(maxExcl == false) : null);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ShellException(iae.getMessage(), iae);
                    }
                    catch (IllegalCommandException ice) {
                        throw new ShellException(ice.getMessage(), ice);
                    }
                }
                case BOOLEAN: {
                    boolean bdef = Boolean.valueOf(defVal);
                    try {
                        tabBuilder.addBoolean(fname, desc, nullable, bdef);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ShellException(iae.getMessage(), iae);
                    }
                    catch (IllegalCommandException ice) {
                        throw new ShellException(ice.getMessage(), ice);
                    }
                }
                case BINARY: {
                    try {
                        tabBuilder.addBinary(fname, desc);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ShellException(iae.getMessage(), iae);
                    }
                    catch (IllegalCommandException ice) {
                        throw new ShellException(ice.getMessage(), ice);
                    }
                }
                case FIXED_BINARY: {
                    int isize = 0;
                    if (size == null) {
                        throw new ShellException("FIXED_BINARY requires a size");
                    }
                    isize = this.getValidIntVal(shell, size);
                    try {
                        tabBuilder.addFixedBinary(fname, isize, desc);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ShellException(iae.getMessage(), iae);
                    }
                    catch (IllegalCommandException ice) {
                        throw new ShellException(ice.getMessage(), ice);
                    }
                }
                case ENUM: {
                    try {
                        if (tabBuilder.isCollectionBuilder()) {
                            tabBuilder.addEnum(fname, values, desc);
                            break;
                        }
                        tabBuilder.addEnum(fname, values, desc, nullable, defVal);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ShellException(iae.getMessage(), iae);
                    }
                    catch (IllegalCommandException ice) {
                        throw new ShellException(ice.getMessage(), ice);
                    }
                }
                case MAP: 
                case ARRAY: 
                case RECORD: {
                    Object obj = TableCommand.getCurrentCmdVariable(shell, fname);
                    try {
                        if (tabBuilder.isCollectionBuilder()) {
                            tabBuilder.addField((FieldDef)obj);
                        } else {
                            tabBuilder.addField(fname, (FieldDef)obj);
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ShellException(iae.getMessage(), iae);
                    }
                    catch (IllegalCommandException iae) {
                        throw new ShellException(iae.getMessage(), iae);
                    }
                    TableBuildAddFieldSub.removeCurrentCmdVariable(shell, fname);
                    break;
                }
                default: {
                    throw new ShellException("Unsupported datatype: " + (Object)((Object)type));
                }
            }
        }

        private Integer getValidIntVal(Shell shell, String val) throws ShellException {
            try {
                return Integer.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                shell.invalidArgument(val + ", not a valid integer number.", this);
                return null;
            }
        }

        private Long getValidLongVal(Shell shell, String val) throws ShellException {
            try {
                return Long.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                shell.invalidArgument(val + ", not a valid long number.", this);
                return null;
            }
        }

        private Double getValidDoubleVal(Shell shell, String val) throws ShellException {
            try {
                return Double.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                shell.invalidArgument(val + ", not a valid double.", this);
                return null;
            }
        }

        private Float getValidFloatVal(Shell shell, String val) throws ShellException {
            try {
                return Float.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                shell.invalidArgument(val + ", not a valid float.", this);
                return null;
            }
        }

        private boolean isComplexType(FieldDef.Type type) {
            return type.equals((Object)FieldDef.Type.ARRAY) || type.equals((Object)FieldDef.Type.MAP) || type.equals((Object)FieldDef.Type.RECORD) || type.equals((Object)FieldDef.Type.ENUM) || type.equals((Object)FieldDef.Type.FIXED_BINARY);
        }

        private static void removeCurrentCmdVariable(Shell shell, String varName) {
            shell.getCurrentCommand().removeVariable(varName);
        }

        @Override
        protected String getCommandSyntax() {
            return "add-field -type <type> [-name <name> ] [-not-nullable] " + eolt + "[" + TableCommand.DEFAULT_FLAG_DESC + "] " + "[" + TableCommand.MAX_FLAG_DESC + "] " + "[" + TableCommand.MIN_FLAG_DESC + "] " + eolt + "[" + "-max-exclusive" + "] " + "[" + "-min-exclusive" + "] " + "[" + TableCommand.DESC_FLAG_DESC + "] " + eolt + "[" + TableCommand.SIZE_FLAG_DESC + "] " + "[" + TableCommand.ENUM_VALUE_FLAG_DESC + "]" + eolt + "<type>: INTEGER, LONG, DOUBLE, FLOAT, STRING, BOOLEAN," + " BINARY," + eolt + "FIXED_BINARY, ENUM.";
        }

        @Override
        protected String getCommandDescription() {
            return "Add a field. Ranges are inclusive with the exception of " + eolt + "String, which will be set to exclusive.";
        }
    }

    static class TableClearSub
    extends CommandWithSubs.SubCommand {
        TableClearSub() {
            super("clear", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            String tableName = null;
            boolean removeAll = false;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-name".equals(arg)) {
                    tableName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-all".equals(arg)) {
                    removeAll = true;
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (tableName == null && !removeAll) {
                shell.requiredArg("-name|-all", this);
            }
            if (tableName != null) {
                Object obj = shell.getVariable(tableName);
                if (obj != null && obj instanceof TableBuilderBase) {
                    shell.removeVariable(tableName);
                    return "Table " + TableCommand.makeTableFullName((TableBuilderBase)obj) + " cleared.";
                }
                return "Can't found the table " + tableName + ".";
            }
            int count = 0;
            Set<Map.Entry<String, Object>> vars = shell.getAllVariables();
            String tinfo = "";
            Iterator<Map.Entry<String, Object>> iterator = vars.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                Object obj = entry.getValue();
                if (!(obj instanceof TableBuilderBase)) continue;
                if (tinfo.length() > 0) {
                    tinfo = tinfo + ", ";
                }
                tinfo = tinfo + TableCommand.makeTableFullName((TableBuilderBase)obj);
                iterator.remove();
                ++count;
            }
            if (count == 0) {
                return "No available table.";
            }
            return count + (count > 1 ? " tables" : " table") + " cleared: " + tinfo + ".";
        }

        @Override
        protected String getCommandSyntax() {
            return "table clear [-name <name> | -all]";
        }

        @Override
        protected String getCommandDescription() {
            return "Clear the tables built but not yet created or evolved. Use flag -name" + eolt + "to specify the table " + "to be clear.  The table name is a dot-separated name" + eolt + "with the format tableName[.childTableName]*.  Flag " + "-all" + " is used to clear" + eolt + "all the tables.";
        }
    }

    static class TableListSub
    extends CommandWithSubs.SubCommand {
        TableListSub() {
            super("list", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            boolean createOnly = false;
            boolean evolveOnly = false;
            String tableName = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-name".equals(arg)) {
                    tableName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-create".equals(arg)) {
                    createOnly = true;
                    continue;
                }
                if ("-evolve".equals(arg)) {
                    evolveOnly = true;
                    continue;
                }
                shell.unknownArgument(arg, this);
            }
            if (!createOnly && !evolveOnly) {
                evolveOnly = true;
                createOnly = true;
            }
            if (tableName != null) {
                Object obj = shell.getVariable(tableName);
                if (obj instanceof TableBuilder || obj instanceof TableEvolver) {
                    return this.getTableBuilderJsonString((TableBuilderBase)obj);
                }
                return "table " + tableName + " is not yet built";
            }
            StringBuilder sbCreateInfo = new StringBuilder();
            StringBuilder sbEvolveInfo = new StringBuilder();
            boolean verbose = shell.getVerbose();
            Set<Map.Entry<String, Object>> variables = shell.getAllVariables();
            for (Map.Entry<String, Object> entry : variables) {
                Object obj = entry.getValue();
                if (createOnly && obj instanceof TableBuilder) {
                    if (verbose) {
                        sbCreateInfo.append(this.getTableBuilderJsonString((TableBuilder)obj));
                    } else {
                        sbCreateInfo.append(eolt);
                        sbCreateInfo.append(this.getTableBuilderAbstractInfo((TableBuilder)obj));
                    }
                }
                if (!evolveOnly || !(obj instanceof TableEvolver)) continue;
                if (verbose) {
                    sbEvolveInfo.append(this.getTableBuilderJsonString((TableEvolver)obj));
                    continue;
                }
                sbEvolveInfo.append(eolt);
                sbEvolveInfo.append(this.getTableBuilderAbstractInfo((TableEvolver)obj));
            }
            if (sbCreateInfo.length() == 0 && sbEvolveInfo.length() == 0) {
                return "No tables available.";
            }
            String createInfo = sbCreateInfo.toString();
            String evolveInfo = sbEvolveInfo.toString();
            if (!verbose) {
                if (createInfo.length() > 0) {
                    createInfo = "Tables to be added: " + createInfo;
                }
                if (evolveInfo.length() > 0) {
                    evolveInfo = "Tables to be evolved: " + evolveInfo;
                    if (createInfo.length() > 0) {
                        evolveInfo = eol + evolveInfo;
                    }
                }
            }
            return createInfo + evolveInfo;
        }

        private String getTableBuilderJsonString(TableBuilderBase obj) {
            String CREATE_LABEL = "Add table ";
            String EVOLVE_LABEL = "Evolve table ";
            String retString = null;
            if (obj instanceof TableBuilder) {
                TableBuilder tb = (TableBuilder)obj;
                retString = "Add table " + TableCommand.makeTableFullName(tb) + ": " + eol + tb.toJsonString(true) + eol;
            } else if (obj instanceof TableEvolver) {
                TableEvolver te = (TableEvolver)obj;
                retString = "Evolve table " + TableCommand.makeTableFullName(te) + ": " + eol + te.toJsonString(true) + eol;
            }
            return retString;
        }

        private String getTableBuilderAbstractInfo(TableBuilderBase obj) {
            String retString = null;
            if (obj instanceof TableBuilder) {
                TableBuilder tb = (TableBuilder)obj;
                retString = TableCommand.makeTableFullName(tb);
                String desc = tb.getDescription();
                if (desc != null && desc.length() > 0) {
                    retString = retString + " -- " + desc;
                }
            } else if (obj instanceof TableEvolver) {
                TableEvolver te = (TableEvolver)obj;
                retString = TableCommand.makeTableFullName(te);
                String desc = te.getTable().getDescription();
                if (desc != null && desc.length() > 0) {
                    retString = retString + " -- " + desc;
                }
            }
            return retString;
        }

        @Override
        protected String getCommandSyntax() {
            return "table list [-name <name>] [-create | -evolve]";
        }

        @Override
        protected String getCommandDescription() {
            return "Lists all the tables built but not yet created or evolved.  Flag -name" + eolt + "is used to show the details of the named table.  The table " + "name is" + eolt + "a dot-separated name with the format " + "tableName[.childTableName]*." + eolt + "Use flag " + "-create" + " or " + "-evolve" + " to show the tables " + "for addition or evolution.";
        }
    }

    static class TableEvolveSub
    extends CommandWithSubs.SubCommand {
        private static final String VAR_TABLEEVOLVER = "CurrentTabEvolver";
        private static final TableEvolveSubs evolveSubs = new TableEvolveSubs();

        protected TableEvolveSub() {
            super("evolve", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            TableBuilderVariable tbv = (TableBuilderVariable)this.getVariable(VAR_TABLEEVOLVER);
            if (tbv == null) {
                Shell.checkHelp(args, this);
                String tableName = null;
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if ("-name".equals(arg)) {
                        tableName = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                }
                if (tableName == null) {
                    shell.requiredArg("-name", this);
                }
                Table table = TableCommand.findTable(tableName, true, shell);
                tbv = new TableBuilderVariable(tableName, TableEvolver.createTableEvolver(table));
                ShellCommand cmd = this.clone();
                cmd.addVariable(VAR_TABLEEVOLVER, tbv);
                cmd.setPrompt(table.getName());
                shell.pushCurrentCommand(cmd);
                return null;
            }
            return evolveSubs.execute(tbv, args, shell);
        }

        @Override
        protected String getCommandSyntax() {
            return "table evolve -name <name>";
        }

        @Override
        protected String getCommandDescription() {
            return "Build a table for evolution.  Tables are evolved using the plan" + eolt + "evolve-table command.  The table name " + "is a dot-separated name with the" + eolt + "format tableName[.childTableName]*.";
        }

        private static class TableEvolveSubs
        extends TableBuildCmdWithSubs {
            private static final List<? extends TableBuildSubCommand> tblEvolveSubs = Arrays.asList(new TableBuildAddArraySub(), new TableBuildAddFieldSub(), new TableBuildAddMapSub(), new TableBuildAddRecordSub(), new TableBuildCancelSub(), new TableBuildExitSub(), new TableBuildRemoveFieldSub(), new TableBuildShowSub());

            TableEvolveSubs() {
                super(tblEvolveSubs, "", 0, 2);
            }

            @Override
            public String getCommandOverview() {
                return "Build table for evolution.";
            }
        }
    }

    static class TableCreateSub
    extends CommandWithSubs.SubCommand {
        private static final String VAR_TABLEBUILDER = "CurrentTabBuilder";
        private static final TableCreateSubs createSubs = new TableCreateSubs();

        TableCreateSub() {
            super("create", 3);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            TableBuilderVariable tbv = (TableBuilderVariable)this.getVariable(VAR_TABLEBUILDER);
            if (tbv == null) {
                Shell.checkHelp(args, this);
                String tableName = null;
                String desc = null;
                Boolean r2Compat = null;
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if ("-name".equals(arg)) {
                        tableName = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if (TableCommand.DESC_FLAG.equals(arg)) {
                        desc = Shell.nextArg(args, i++, this);
                        continue;
                    }
                    if ("-r2-compat".equals(arg)) {
                        r2Compat = true;
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                }
                if (tableName == null) {
                    shell.requiredArg("-name", this);
                }
                String parentName = null;
                String[] names = TableCreateSub.parseName(tableName);
                String tableId = names[0];
                if (names.length == 2) {
                    parentName = names[1];
                }
                Table tbParent = null;
                if (parentName != null) {
                    tbParent = TableCommand.findTable(parentName, true, shell);
                }
                try {
                    TableBuilder tb = TableBuilder.createTableBuilder(tableId, desc, tbParent);
                    if (r2Compat != null) {
                        ((TableBuilderBase)tb).setR2compat(r2Compat);
                    }
                    tbv = new TableBuilderVariable(tableName, tb);
                }
                catch (IllegalArgumentException iae) {
                    throw new ShellException(iae.getMessage(), iae);
                }
                catch (IllegalCommandException ice) {
                    throw new ShellException(ice.getMessage(), ice);
                }
                ShellCommand cmd = this.clone();
                cmd.addVariable(VAR_TABLEBUILDER, tbv);
                cmd.setPrompt(tableName);
                shell.pushCurrentCommand(cmd);
                return null;
            }
            return createSubs.execute(tbv, args, shell);
        }

        private static String[] parseName(String tableName) {
            String[] retNames = null;
            int pos = tableName.lastIndexOf(".");
            retNames = pos > 0 ? new String[]{tableName.substring(pos + 1), tableName.substring(0, pos)} : new String[]{tableName};
            return retNames;
        }

        @Override
        protected String getCommandSyntax() {
            return "table create -name <name> [-desc <description>] [-r2-compat]";
        }

        @Override
        protected String getCommandDescription() {
            return "Build a new table to be added to the store.  New tables are added using" + eolt + "the plan add-table command.  " + "The table name is a dot-separated name with" + eolt + "the format tableName[.childTableName]*.  Flag " + "-r2-compat" + " is used to" + eolt + "create a table on top of " + "existing R2 Key/Value pairs.";
        }

        private static class TableCreateSubs
        extends TableBuildCmdWithSubs {
            private static final List<? extends TableBuildSubCommand> tblCreateSubs = Arrays.asList(new TableBuildAddArraySub(), new TableBuildAddFieldSub(), new TableBuildRemoveFieldSub(), new TableBuildAddMapSub(), new TableBuildAddRecordSub(), new TableBuildAddSchemaSub(), new TableBuildCancelSub(), new TableBuildExitSub(), new TableBuildShardKeySub(), new TableBuildPrimaryKeySub(), new TableBuildSetDescSub(), new TableBuildShowSub());

            TableCreateSubs() {
                super(tblCreateSubs, "", 0, 2);
            }

            @Override
            public String getCommandOverview() {
                return "Build a new table to be added to the store.";
            }
        }
    }

    static abstract class TableBuildSubCommand
    extends CommandWithSubs.SubCommand {
        private CommandWithSubs parentCommand = null;

        protected TableBuildSubCommand(String name, int prefixMatchLength) {
            super(name, prefixMatchLength);
        }

        protected void setParentCommand(CommandWithSubs command) {
            this.parentCommand = command;
        }

        protected TableBuilderBase getCurrentTableBuilder() {
            return ((TableBuildCmdWithSubs)this.parentCommand).getTableBuilder();
        }

        protected String getCurrentTableBuilderName() {
            return ((TableBuildCmdWithSubs)this.parentCommand).getTableBuilderName();
        }
    }

    static abstract class TableBuildCmdWithSubs
    extends CommandWithSubs {
        private TableBuilderVariable varBuilder = null;

        TableBuildCmdWithSubs(List<? extends CommandWithSubs.SubCommand> subCommands, String name, int prefixLength, int minArgCount) {
            super(subCommands, name, prefixLength, minArgCount);
            this.initSubs(subCommands);
        }

        private void initSubs(List<? extends CommandWithSubs.SubCommand> tblSubs) {
            for (CommandWithSubs.SubCommand subCommand : tblSubs) {
                ((TableBuildSubCommand)subCommand).setParentCommand(this);
            }
        }

        public String execute(TableBuilderVariable tbv, String[] args, Shell shell) throws ShellException {
            if (this.isHelpCommand(args[1], shell)) {
                String[] argsEx = new String[args.length - 1];
                argsEx[0] = args[0];
                System.arraycopy(args, 2, argsEx, 1, args.length - 2);
                return this.getHelp(argsEx, shell);
            }
            this.varBuilder = tbv;
            return this.execute(args, shell);
        }

        protected TableBuilderBase getTableBuilder() {
            return this.varBuilder.getTableBuilder();
        }

        protected String getTableBuilderName() {
            return this.varBuilder.getName();
        }

        private boolean isHelpCommand(String commandName, Shell shell) {
            ShellCommand cmd = shell.findCommand(commandName);
            return cmd instanceof Shell.HelpCommand;
        }
    }

    private static class TableBuilderVariable {
        private String name;
        private TableBuilderBase builder;

        TableBuilderVariable(String varName, TableBuilderBase tb) {
            this.name = varName;
            this.builder = tb;
        }

        public String getName() {
            return this.name;
        }

        public TableBuilderBase getTableBuilder() {
            return this.builder;
        }
    }
}

