/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.admin.client.CommandUtils;
import oracle.kv.impl.admin.client.SharedCommandWithSubs;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.api.table.TableBuilder;
import oracle.kv.impl.api.table.TableEvolver;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.util.SecurityUtils;
import oracle.kv.impl.security.util.ShellPasswordReader;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.util.shell.CommandWithSubs;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellUsageException;

class PlanCommand
extends SharedCommandWithSubs {
    private static final List<? extends CommandWithSubs.SubCommand> subs = Arrays.asList(new AddIndexSub(), new AddTableSub(), new ChangeMountPointSub(), new ChangeParamsSub(), new ChangeUserSub(), new CreateUserSub(), new DeployAdminSub(), new DeployDCSub(), new DeploySNSub(), new DeployZoneSub(), new DropUserSub(), new ExecuteSub(), new EvolveTableSub(), new InterruptSub(), new CancelSub(), new MigrateSNSub(), new RemoveAdminSub(), new RemoveSNSub(), new RemoveDatacenterSub(), new RemoveIndexSub(), new RemoveTableSub(), new RemoveZoneSub(), new StartServiceSub(), new StopServiceSub(), new DeployTopologySub(), new PlanWaitSub(), new RepairTopologySub());

    PlanCommand() {
        super(subs, "plan", 4, 0);
    }

    @Override
    protected String getCommandOverview() {
        return "Encapsulates operations, or jobs that modify store state." + eol + "All subcommands with the exception of " + "interrupt and wait change" + eol + "persistent state. Plans " + "are asynchronous jobs so they return immediately" + eol + "unless -wait is used.  Plan status can be checked using " + "\"show plans\"." + eol + "Optional arguments for all plans " + "include:" + eolt + "-wait -- wait for the plan to complete before returning" + eolt + "-plan-name -- name for a plan.  These are not unique" + eolt + "-noexecute -- do not execute the plan.  If specified " + "the plan" + eolt + "              " + "can be run later using \"plan execute\"" + eolt + "-force -- used to force plan execution and plan retry";
    }

    static final class RemoveIndexSub
    extends PlanSubCommand {
        static final String INDEX_NAME_FLAG = "-name";
        static final String TABLE_FLAG = "-table";

        RemoveIndexSub() {
            super("remove-index", 8);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String indexName = null;
            String tableName = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (INDEX_NAME_FLAG.equals(arg)) {
                    indexName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (TABLE_FLAG.equals(arg)) {
                    tableName = Shell.nextArg(args, i++, this);
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (indexName == null) {
                shell.requiredArg(INDEX_NAME_FLAG, this);
            }
            if (tableName == null) {
                shell.requiredArg(TABLE_FLAG, this);
            }
            try {
                int planId = cs.createRemoveIndexPlan(this.planName, indexName, tableName);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "plan remove-index -name <name> -table <name> " + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Remove an index from a table.  The table name is a dot-separated name" + eolt + "with the format " + "tableName[.childTableName]*.";
        }
    }

    static final class AddIndexSub
    extends PlanSubCommand {
        static final String INDEX_NAME_FLAG = "-name";
        static final String TABLE_FLAG = "-table";
        static final String FIELD_FLAG = "-field";
        static final String DESC_FLAG = "-desc";

        AddIndexSub() {
            super("add-index", 5);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String indexName = null;
            String tableName = null;
            String desc = null;
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (INDEX_NAME_FLAG.equals(arg)) {
                    indexName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (TABLE_FLAG.equals(arg)) {
                    tableName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (FIELD_FLAG.equals(arg)) {
                    fields.add(Shell.nextArg(args, i++, this));
                    continue;
                }
                if (DESC_FLAG.equals(arg)) {
                    desc = Shell.nextArg(args, i++, this);
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (indexName == null) {
                shell.requiredArg(INDEX_NAME_FLAG, this);
            }
            if (tableName == null) {
                shell.requiredArg(TABLE_FLAG, this);
            }
            if (fields.size() == 0) {
                shell.requiredArg(FIELD_FLAG, this);
            }
            try {
                int planId = cs.createAddIndexPlan(this.planName, indexName, tableName, fields.toArray(new String[0]), desc);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "plan add-index -name <name> -table <name> [-field <name>]* " + eolt + "[" + DESC_FLAG + " <description>]" + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Add an index to a table in the store.  The table name is a" + eolt + "dot-separated name with the " + "format tableName[.childTableName]*.";
        }
    }

    static final class RemoveTableSub
    extends PlanSubCommand {
        static final String TABLE_NAME_FLAG = "-name";
        static final String KEEP_DATA_FLAG = "-keep-data";

        RemoveTableSub() {
            super("remove-table", 8);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String tableName = null;
            boolean removeData = true;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (TABLE_NAME_FLAG.equals(arg)) {
                    tableName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (KEEP_DATA_FLAG.equals(arg)) {
                    removeData = false;
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (tableName == null) {
                shell.requiredArg(TABLE_NAME_FLAG, this);
            }
            try {
                int planId = cs.createRemoveTablePlan(this.planName, tableName, removeData);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "plan remove-table -name <name> [-keep-data]" + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Remove a table from the store.  The table name is a dot-separated name" + eolt + "with the format " + "tableName[.childTableName]*.  The named table must " + "exist " + eolt + "and must not have any child tables.  " + "Indexes on the table are automatically" + eolt + "removed.  By default data stored in this table is also " + "removed.  Table" + eolt + "data may be optionally saved by " + "specifying the -keep-data flag." + eolt + "Depending " + "on the indexes and amount of data stored in the table this" + eolt + "may be a long-running plan.";
        }
    }

    static final class EvolveTableSub
    extends PlanSubCommand {
        static final String TABLE_NAME_FLAG = "-name";

        EvolveTableSub() {
            super("evolve-table", 8);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Object obj;
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String tableName = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (TABLE_NAME_FLAG.equals(arg)) {
                    tableName = Shell.nextArg(args, i++, this);
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (tableName == null) {
                shell.requiredArg(TABLE_NAME_FLAG, this);
            }
            if ((obj = shell.getVariable(tableName)) == null || !(obj instanceof TableEvolver)) {
                shell.invalidArgument("table " + tableName + " is not yet built, please run command 'table evolve'" + " to build it first.", this);
            }
            TableEvolver te = (TableEvolver)obj;
            try {
                int planId = cs.createEvolveTablePlan(this.planName, te.getTable().getFullName(), te.getTableVersion(), te.getFieldMap());
                shell.removeVariable(tableName);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "plan evolve-table -name <name> " + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Evolve a table in the store.  The table name is a dot-separated name" + eolt + "with the format " + "tableName[.childTableName]*.  The named table must " + eolt + "have been evolved using the \"table evolve\" " + "command. Use" + eolt + "\"table list -evolve\" " + "to see the list of tables that can be evolved.";
        }
    }

    static final class AddTableSub
    extends PlanSubCommand {
        static final String TABLE_NAME_FLAG = "-name";

        AddTableSub() {
            super("add-table", 5);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Object obj;
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String tableName = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (TABLE_NAME_FLAG.equals(arg)) {
                    tableName = Shell.nextArg(args, i++, this);
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (tableName == null) {
                shell.requiredArg(TABLE_NAME_FLAG, this);
            }
            if ((obj = shell.getVariable(tableName)) == null || !(obj instanceof TableBuilder)) {
                shell.invalidArgument("table " + tableName + " is not yet built, please run the 'table create' " + "command to build it first.", this);
            }
            try {
                TableBuilder tb = (TableBuilder)obj;
                int planId = cs.createAddTablePlan(this.planName, tb.getName(), tb.getParent() != null ? tb.getParent().getFullName() : null, tb.getFieldMap(), tb.getPrimaryKey(), tb.getShardKey(), tb.isR2compatible(), tb.getSchemaId(), tb.getDescription());
                shell.removeVariable(tableName);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "plan add-table -name <name> " + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Add a new table to the store.  The table name is a dot-separated name" + eolt + "with the format " + "tableName[.childTableName]*.  Use the table create" + eolt + "command to create the named table.  " + "Use \"table list -create\" to see the" + eolt + "list of tables that can be added.";
        }
    }

    static class RemoveZoneSub
    extends PlanSubCommand {
        static final String ID_FLAG = "-zn";
        static final String NAME_FLAG = "-znname";

        RemoveZoneSub() {
            super("remove-zone", 9);
        }

        RemoveZoneSub(String name, int prefixMatchLength) {
            super(name, prefixMatchLength);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            DatacenterId id = null;
            String nameFlag = null;
            boolean deprecatedDcFlag = false;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (CommandUtils.isDatacenterIdFlag(arg)) {
                    String argVal = Shell.nextArg(args, i++, this);
                    id = this.parseDatacenterId(argVal);
                    if (!CommandUtils.isDeprecatedDatacenterId(arg, argVal)) continue;
                    deprecatedDcFlag = true;
                    continue;
                }
                if (CommandUtils.isDatacenterNameFlag(arg)) {
                    nameFlag = Shell.nextArg(args, i++, this);
                    if (!CommandUtils.isDeprecatedDatacenterName(arg)) continue;
                    deprecatedDcFlag = true;
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (id == null && nameFlag == null) {
                shell.requiredArg("-zn | -znname", this);
            }
            String deprecatedDcFlagPrefix = deprecatedDcFlag ? dcFlagsDeprecation : "";
            try {
                if (id != null) {
                    CommandUtils.ensureDatacenterExists(id, cs, this);
                } else {
                    id = CommandUtils.getDatacenterId(nameFlag, cs, this);
                }
                int planId = cs.createRemoveDatacenterPlan(this.planName, id);
                return deprecatedDcFlagPrefix + this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        public String getCommandSyntax() {
            return "plan " + this.name + " " + ID_FLAG + " <id> | " + NAME_FLAG + " <name>" + genericFlags;
        }

        @Override
        public String getCommandDescription() {
            return "Removes the specified zone from the store.";
        }
    }

    static final class RemoveDatacenterSub
    extends RemoveZoneSub {
        static final String dcCommandDeprecation = "The command:" + eol + eolt + "plan remove-datacenter" + eol + eol + "is deprecated and has been replaced by:" + eol + eolt + "plan remove-zone" + eol + eol;

        RemoveDatacenterSub() {
            super("remove-datacenter", 9);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            return dcCommandDeprecation + super.exec(args, shell);
        }

        @Override
        public String getCommandDescription() {
            return super.getCommandDescription() + eol + eolt + "This command is deprecated and has been replaced by:" + eol + eolt + "plan remove-zone";
        }
    }

    static final class PlanWaitSub
    extends PlanSubCommand {
        PlanWaitSub() {
            super("wait", 3);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            int planId = 0;
            int timeoutSecs = 0;
            try {
                for (int i = 1; i < args.length; ++i) {
                    String argString;
                    String arg = args[i];
                    if ("-id".equals(arg)) {
                        argString = Shell.nextArg(args, i++, this);
                        planId = this.parseInt(argString, "Invalid plan ID");
                        continue;
                    }
                    if ("-seconds".equals(arg)) {
                        argString = Shell.nextArg(args, i++, this);
                        timeoutSecs = this.parseInt(argString, "Invalid timeout value");
                        continue;
                    }
                    if ("-last".equals(arg)) {
                        planId = PlanWaitSub.getLastPlanId(cs);
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                }
                if (planId == 0) {
                    shell.requiredArg("-id", this);
                }
                CommandUtils.ensurePlanExists(planId, cs, this);
                Plan.State state = cs.awaitPlan(planId, timeoutSecs, TimeUnit.SECONDS);
                return state.getWaitMessage(planId);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "plan wait -id <id> | -last [-seconds <timeout in seconds>]";
        }

        @Override
        protected String getCommandDescription() {
            return "Waits for the specified plan to complete.  If the optional timeout" + eolt + "is specified, wait that long, " + "otherwise wait indefinitely.  Use -last" + eolt + "to reference the most recently created plan.";
        }
    }

    static abstract class StartStopServiceSub
    extends PlanSubCommand {
        private Set<RepNodeId> rnids;
        private final boolean isStart;

        protected StartStopServiceSub(String name, int prefixMatchLength, boolean isStart) {
            super(name, prefixMatchLength);
            this.isStart = isStart;
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            String cannotMixMsg = "Cannot mix -service and -all* arguments";
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            this.rnids = null;
            String serviceName = null;
            boolean allRN = false;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-service".equals(arg)) {
                    serviceName = Shell.nextArg(args, i++, this);
                    if (allRN) {
                        throw new ShellUsageException("Cannot mix -service and -all* arguments", this);
                    }
                    this.addService(serviceName);
                    continue;
                }
                if ("-all-rns".equals(arg)) {
                    if (this.rnids != null) {
                        throw new ShellUsageException("Cannot mix -service and -all* arguments", this);
                    }
                    allRN = true;
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (this.rnids == null && !allRN) {
                shell.requiredArg("-service|-all-rns", this);
            }
            try {
                int planId = 0;
                if (allRN) {
                    planId = this.isStart ? cs.createStartAllRepNodesPlan(this.planName) : cs.createStopAllRepNodesPlan(this.planName);
                } else {
                    this.validateRepNodes(cs, this.rnids);
                    planId = this.isStart ? cs.createStartRepNodesPlan(this.planName, this.rnids) : cs.createStopRepNodesPlan(this.planName, this.rnids);
                }
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        private void addService(String serviceName) throws ShellException {
            RepNodeId rnid = this.parseRnid(serviceName);
            if (this.rnids == null) {
                this.rnids = new HashSet<RepNodeId>();
            }
            this.rnids.add(rnid);
        }
    }

    static final class StopServiceSub
    extends StartStopServiceSub {
        StopServiceSub() {
            super("stop-service", 4, false);
        }

        @Override
        protected String getCommandSyntax() {
            return "plan stop-service -service <id> | -all-rns" + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Stops the specified service(s).";
        }
    }

    static final class StartServiceSub
    extends StartStopServiceSub {
        StartServiceSub() {
            super("start-service", 4, true);
        }

        @Override
        protected String getCommandSyntax() {
            return "plan start-service -service <id> | -all-rns" + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Starts the specified service(s).";
        }
    }

    static final class RemoveSNSub
    extends PlanSubCommand {
        RemoveSNSub() {
            super("remove-sn", 9);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            StorageNodeId snid = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-sn".equals(arg)) {
                    String argString = Shell.nextArg(args, i++, this);
                    snid = this.parseSnid(argString);
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (snid == null) {
                shell.requiredArg("-sn", this);
            }
            try {
                CommandUtils.ensureStorageNodeExists(snid, cs, this);
                int planId = cs.createRemoveSNPlan(this.planName, snid);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "plan remove-sn -sn <id>" + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Removes the specified storage node from the topology.";
        }
    }

    static final class MigrateSNSub
    extends PlanSubCommand {
        MigrateSNSub() {
            super("migrate-sn", 7);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            StorageNodeId fromSnid = null;
            StorageNodeId toSnid = null;
            int port = 0;
            for (int i = 1; i < args.length; ++i) {
                String argString;
                String arg = args[i];
                if ("-from".equals(arg)) {
                    argString = Shell.nextArg(args, i++, this);
                    fromSnid = this.parseSnid(argString);
                    continue;
                }
                if ("-to".equals(arg)) {
                    argString = Shell.nextArg(args, i++, this);
                    toSnid = this.parseSnid(argString);
                    continue;
                }
                if ("-admin-port".equals(arg)) {
                    argString = Shell.nextArg(args, i++, this);
                    port = this.parseInt(argString, "Invalid admin port");
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (fromSnid == null || toSnid == null) {
                shell.requiredArg(null, this);
            }
            try {
                Parameters p = cs.getParameters();
                for (AdminParams ap : p.getAdminParams()) {
                    if (!ap.getStorageNodeId().equals(fromSnid) || port != 0) continue;
                    throw new ShellUsageException("Admin port is required because the old storage node hosted an Admin service", this);
                }
                CommandUtils.ensureStorageNodeExists(fromSnid, cs, this);
                CommandUtils.ensureStorageNodeExists(toSnid, cs, this);
                int planId = cs.createMigrateSNPlan(this.planName, fromSnid, toSnid, port);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "plan migrate-sn -from <id> -to <id> [-admin-port <admin port>]" + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Migrates the services from one storage node to another. The old node" + eolt + "must not be running.  If the old " + "node hosted an admin service" + eolt + "the -admin-port argument is required.";
        }
    }

    static abstract class InterruptCancelSub
    extends PlanSubCommand {
        private final boolean isInterrupt;

        protected InterruptCancelSub(String name, int prefixMatchLength, boolean isInterrupt) {
            super(name, prefixMatchLength);
            this.isInterrupt = isInterrupt;
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            int planId = 0;
            try {
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if ("-id".equals(arg)) {
                        String argString = Shell.nextArg(args, i++, this);
                        planId = this.parseInt(argString, "Invalid plan ID");
                        continue;
                    }
                    if ("-last".equals(arg)) {
                        planId = InterruptCancelSub.getLastPlanId(cs);
                        continue;
                    }
                    shell.unknownArgument(arg, this);
                }
                if (planId == 0) {
                    shell.requiredArg("-id|-last", this);
                }
                CommandUtils.ensurePlanExists(planId, cs, this);
                if (this.isInterrupt) {
                    cs.interruptPlan(planId);
                    return "Plan " + planId + " was interrupted";
                }
                cs.cancelPlan(planId);
                return "Plan " + planId + " was canceled";
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }
    }

    static final class CancelSub
    extends InterruptCancelSub {
        CancelSub() {
            super("cancel", 3, false);
        }

        @Override
        protected String getCommandSyntax() {
            return "plan cancel -id <plan id> | -last";
        }

        @Override
        protected String getCommandDescription() {
            return "Cancels a plan that is not running.  A running plan must be" + eolt + "interrupted before it can be canceled. " + "Use -last to reference the most" + eolt + "recently " + "created plan.";
        }
    }

    static final class InterruptSub
    extends InterruptCancelSub {
        InterruptSub() {
            super("interrupt", 3, true);
        }

        @Override
        protected String getCommandSyntax() {
            return "plan interrupt -id <plan id> | -last";
        }

        @Override
        protected String getCommandDescription() {
            return "Interrupts a running plan. An interrupted plan can only be re-executed" + eolt + "or canceled.  Use -last " + "to reference the most recently" + eolt + "created plan.";
        }
    }

    static final class ExecuteSub
    extends PlanSubCommand {
        ExecuteSub() {
            super("execute", 3);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            int planId = 0;
            try {
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if ("-id".equals(arg)) {
                        String argString = Shell.nextArg(args, i++, this);
                        planId = this.parseInt(argString, "Invalid plan ID");
                        continue;
                    }
                    if ("-last".equals(arg)) {
                        planId = ExecuteSub.getLastPlanId(cs);
                        continue;
                    }
                    i += this.checkGenericArg(arg, args, i);
                }
                if (planId == 0) {
                    shell.requiredArg("-id|-last", this);
                }
                CommandUtils.ensurePlanExists(planId, cs, this);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "plan execute -id <id> | -last [-wait] [-force]";
        }

        @Override
        protected String getCommandDescription() {
            return "Executes a created, but not yet executed plan.  The plan must have" + eolt + "been previously created using the " + "-noexecute flag. Use -last to" + eolt + "reference the " + "most recently created plan.";
        }
    }

    static final class RepairTopologySub
    extends PlanSubCommand {
        RepairTopologySub() {
            super("repair-topology", 4);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                i += this.checkGenericArg(arg, args, i);
            }
            try {
                int planId = cs.createRepairPlan(this.planName);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "plan repair-topology " + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Inspects the store's deployed, current topology for inconsistencies" + eolt + "in location metadata that may have arisen from the " + "interruption" + eolt + "or cancellation of previous deploy-topology or migrate-sn " + "plans. Where " + eolt + "possible, inconsistencies are repaired. This operation can" + eolt + "take a while, depending on the size and state of " + "the store.";
        }
    }

    static final class DeployTopologySub
    extends PlanSubCommand {
        DeployTopologySub() {
            super("deploy-topology", 10);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String topoName = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-name".equals(arg)) {
                    topoName = Shell.nextArg(args, i++, this);
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (topoName == null) {
                shell.requiredArg("-name", this);
            }
            try {
                int planId = cs.createDeployTopologyPlan(this.planName, topoName);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "plan deploy-topology -name <topology name>" + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Deploys the specified topology to the store.  This operation can" + eolt + "take a while, depending on " + "the size and state of the store.";
        }
    }

    static final class DeploySNSub
    extends PlanSubCommand {
        DeploySNSub() {
            super("deploy-sn", 9);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            String deprecatedDcFlagPrefix;
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            DatacenterId dcid = null;
            String host = null;
            String dcName = null;
            int port = 0;
            boolean deprecatedDcFlag = false;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-host".equals(arg)) {
                    host = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-port".equals(arg)) {
                    String argString = Shell.nextArg(args, i++, this);
                    port = this.parseInt(argString, "Invalid port");
                    continue;
                }
                if (CommandUtils.isDatacenterIdFlag(arg)) {
                    dcid = DatacenterId.parse(Shell.nextArg(args, i++, this));
                    if (!CommandUtils.isDeprecatedDatacenterId(arg, args[i])) continue;
                    deprecatedDcFlag = true;
                    continue;
                }
                if (CommandUtils.isDatacenterNameFlag(arg)) {
                    dcName = Shell.nextArg(args, i++, this);
                    if (!CommandUtils.isDeprecatedDatacenterName(arg)) continue;
                    deprecatedDcFlag = true;
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            String string = deprecatedDcFlagPrefix = deprecatedDcFlag ? dcFlagsDeprecation : "";
            if (dcid == null && dcName == null || host == null || port == 0) {
                shell.requiredArg(null, this);
            }
            try {
                if (dcid == null) {
                    dcid = CommandUtils.getDatacenterId(dcName, cs, this);
                }
                int planId = cs.createDeploySNPlan(this.planName, dcid, host, port, null);
                return deprecatedDcFlagPrefix + this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "plan deploy-sn -zn <id> | -znname <name> -host <host> -port <port>" + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Deploys the storage node at the specified host and port into the" + eolt + "specified zone.";
        }
    }

    static class DeployZoneSub
    extends PlanSubCommand {
        DeployZoneSub() {
            super("deploy-zone", 10);
        }

        DeployZoneSub(String name, int prefixMatchLength) {
            super(name, prefixMatchLength);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String dcName = null;
            int rf = 0;
            boolean rfSet = false;
            DatacenterType type = DatacenterType.PRIMARY;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-name".equals(arg)) {
                    dcName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-rf".equals(arg)) {
                    String argString = Shell.nextArg(args, i++, this);
                    rf = this.parseInt(argString, "Invalid replication factor");
                    rfSet = true;
                    continue;
                }
                if ("-type".equals(arg)) {
                    String typeValue = Shell.nextArg(args, i++, this);
                    type = this.parseDatacenterType(typeValue);
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (dcName == null || !rfSet) {
                shell.requiredArg(null, this);
            }
            try {
                int planId = cs.createDeployDatacenterPlan(this.planName, dcName, rf, type);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return "plan " + this.name + " -name <zone name>" + eolt + "-rf <replication factor>" + eolt + "[-type [primary | secondary]]" + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Deploys the specified zone to the store," + eolt + "creating a primary zone if -type is not specified.";
        }
    }

    static final class DeployDCSub
    extends DeployZoneSub {
        static final String dcCommandDeprecation = "The command:" + eol + eolt + "plan deploy-datacenter" + eol + eol + "is deprecated and has been replaced by:" + eol + eolt + "plan deploy-zone" + eol + eol;

        DeployDCSub() {
            super("deploy-datacenter", 10);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            return dcCommandDeprecation + super.exec(args, shell);
        }

        @Override
        public String getCommandDescription() {
            return super.getCommandDescription() + eol + eolt + "This command is deprecated and has been replaced by:" + eol + eolt + "plan deploy-zone";
        }
    }

    static final class RemoveAdminSub
    extends PlanSubCommand {
        final String adminDcError = "Invalid argument combination: -admin flag cannot be used with -zn, -znname, -dc, or -dcname flag";
        final String dcIdNameError = "Invalid argument combination: must use only one of the -zn, -znname, -dc, or -dcname flags";
        final String commandSyntax = "plan remove-admin -admin <id> | -zn <id> | -znname <name> [-force] " + genericFlags;
        final String commandDesc = "Removes the desired Admin instances; either the single" + eolt + "specified instance, or all instances deployed to the specified" + eolt + "zone. If the -admin flag is used and there are 3 or " + eolt + "fewer Admins running in the store, or if the -zn or -znname" + eolt + "flag is used and the removal of all Admins from the specified" + eolt + "zone would result in only one or two Admins in the store," + eolt + "then the desired Admins will be removed only if the -force" + eolt + "flag is also specified. Additionally, if the -admin flag is" + eolt + "used and there is only one Admin in the store, or if the -zn or" + eolt + "-znname flag is used and the removal of all Admins from the" + eolt + "specified zone would result in the removal of all Admins" + eolt + "from the store, then the desired Admins will not be removed.";
        final String noAdminError = "There is no Admin in the store with the specified id ";
        final String only1AdminError = "Only one Admin in the store, so cannot remove the sole Admin ";
        final String tooFewAdminError = "Removing the specified Admin will result in fewer than 3" + eolt + "Admins in the store; which is strongly discouraged because" + eolt + "the loss of one of the remaining Admins will cause quorum" + eolt + "to be lost. If you still wish to remove the desired Admin," + eolt + "specify the -force flag. ";
        final String noAdminDcError = "There are no Admins in the specified zone ";
        final String allAdminDcError = "The specified zone contains all the Admins in the store," + eolt + "and so cannot be removed from the specified zone ";
        final String tooFewAdminDcError = "Removing all Admins from the specified zone will result" + eolt + "in fewer than 3 Admins in the store; which is strongly" + eolt + "discouraged because the loss of one of the remaining Admins " + eolt + "will cause quorum to be lost. If you still wish to remove" + eolt + "all of the Admins from the desired zone, specify the" + eolt + "-force flag. ";

        RemoveAdminSub() {
            super("remove-admin", 10);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            AdminId aid = null;
            DatacenterId dcid = null;
            String dcName = null;
            boolean getDcId = false;
            boolean deprecatedDcFlag = false;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-admin".equals(arg)) {
                    String argString = Shell.nextArg(args, i++, this);
                    aid = this.parseAdminid(argString);
                    continue;
                }
                if (CommandUtils.isDatacenterIdFlag(arg)) {
                    dcid = DatacenterId.parse(Shell.nextArg(args, i++, this));
                    if (!CommandUtils.isDeprecatedDatacenterId(arg, args[i])) continue;
                    deprecatedDcFlag = true;
                    continue;
                }
                if (CommandUtils.isDatacenterNameFlag(arg)) {
                    dcName = Shell.nextArg(args, i++, this);
                    if (!CommandUtils.isDeprecatedDatacenterName(arg)) continue;
                    deprecatedDcFlag = true;
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (aid == null) {
                if (dcid == null) {
                    if (dcName == null) {
                        shell.requiredArg(null, this);
                    } else {
                        getDcId = true;
                    }
                } else if (dcName != null) {
                    throw new ShellUsageException("Invalid argument combination: must use only one of the -zn, -znname, -dc, or -dcname flags", this);
                }
            } else if (dcid != null || dcName != null) {
                throw new ShellUsageException("Invalid argument combination: -admin flag cannot be used with -zn, -znname, -dc, or -dcname flag", this);
            }
            String deprecatedDcFlagPrefix = deprecatedDcFlag ? dcFlagsDeprecation : "";
            Parameters parameters = null;
            try {
                parameters = cs.getParameters();
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
            int nAdmins = parameters.getAdminCount();
            if (aid != null) {
                if (parameters.get(aid) == null) {
                    return "There is no Admin in the store with the specified id [" + aid + "]";
                }
                if (nAdmins == 1) {
                    return "Only one Admin in the store, so cannot remove the sole Admin [" + aid + "]";
                }
                if (nAdmins < 4 && !this.force) {
                    return this.tooFewAdminError + "There are only " + nAdmins + " Admins in the store.";
                }
            } else {
                Set<AdminId> adminIdSet;
                try {
                    if (getDcId) {
                        dcid = CommandUtils.getDatacenterId(dcName, cs, this);
                    }
                    adminIdSet = parameters.getAdminIds(dcid, cs.getTopology());
                }
                catch (RemoteException re) {
                    cmd.noAdmin(re);
                    return "";
                }
                String dcErrStr = "";
                if (dcName != null) {
                    dcErrStr = dcName;
                } else if (dcid != null) {
                    dcErrStr = dcid.toString();
                }
                if (adminIdSet.size() == 0) {
                    return "There are no Admins in the specified zone [" + dcErrStr + "]";
                }
                if (adminIdSet.size() == nAdmins) {
                    return this.allAdminDcError + "[" + dcErrStr + "]";
                }
                if (nAdmins - adminIdSet.size() < 3 && !this.force) {
                    return this.tooFewAdminDcError + "There are " + nAdmins + " Admins in the store and " + adminIdSet.size() + " Admins in the specified zone " + "[" + dcErrStr + "]";
                }
            }
            try {
                int planId = cs.createRemoveAdminPlan(this.planName, dcid, aid);
                return deprecatedDcFlagPrefix + this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return this.commandSyntax;
        }

        @Override
        protected String getCommandDescription() {
            return this.commandDesc;
        }
    }

    static final class DropUserSub
    extends PlanSubCommand {
        static final String COMMAND_SYNTAX = "plan drop-user -name <user name>" + genericFlags;
        static final String COMMAND_DESC = "Drop a user with the specified name in the store. A" + eolt + "logged-in user may not drop itself.";

        DropUserSub() {
            super("drop-user", 7);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String userName = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-name".equals(arg)) {
                    userName = Shell.nextArg(args, i++, this);
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (userName == null) {
                shell.requiredArg("-name", this);
            }
            try {
                Map<String, KVStoreUser.UserDescription> userDescMap = cs.getUsersDescription();
                if (userDescMap == null || userDescMap.get(userName) == null) {
                    cmd.println("User " + userName + " does not exist.");
                }
                int planId = cs.createDropUserPlan(this.planName, userName);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return COMMAND_SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return COMMAND_DESC;
        }
    }

    static final class DeployAdminSub
    extends PlanSubCommand {
        static final String COMMAND_SYNTAX = "plan deploy-admin -sn <id> -port <http port>" + genericFlags;
        static final String COMMAND_DESC = "Deploys an Admin to the specified storage node.  Its graphical" + eolt + "interface will listen on the " + "specified port, or is diabled if the port is set to 0.";

        DeployAdminSub() {
            super("deploy-admin", 10);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            StorageNodeId snid = null;
            int port = 0;
            boolean portFound = false;
            for (int i = 1; i < args.length; ++i) {
                String argString;
                String arg = args[i];
                if ("-port".equals(arg)) {
                    argString = Shell.nextArg(args, i++, this);
                    port = this.parseInt(argString, "Invalid HTTP port");
                    portFound = true;
                    continue;
                }
                if ("-sn".equals(arg)) {
                    argString = Shell.nextArg(args, i++, this);
                    snid = this.parseSnid(argString);
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (snid == null || !portFound) {
                shell.requiredArg(null, this);
            }
            try {
                int planId = cs.createDeployAdminPlan(this.planName, snid, port);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return COMMAND_SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return COMMAND_DESC;
        }
    }

    static final class CreateUserSub
    extends PlanSubCommand {
        static final String COMMAND_SYNTAX = "plan create-user -name <user name> [-admin] [-disable]" + eolt + "[-password <new password>]" + genericFlags;
        static final String COMMAND_DESC = "Create a user with the specified name in the store." + eolt + "The -admin argument indicates that the created " + "user has full " + eolt + "administrative privileges.";
        static final String DISABLE_FLAG = "-disable";
        static final String ADMIN_FLAG = "-admin";
        static final String NAME_FLAG = "-name";
        static final String PASSWORD_FLAG = "-password";

        CreateUserSub() {
            super("create-user", 10);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            char[] plainPasswd;
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String userName = null;
            String password = null;
            boolean isAdmin = false;
            boolean isEnabled = true;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (NAME_FLAG.equals(arg)) {
                    userName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (PASSWORD_FLAG.equals(arg)) {
                    password = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (ADMIN_FLAG.equals(arg)) {
                    isAdmin = true;
                    continue;
                }
                if (DISABLE_FLAG.equals(arg)) {
                    isEnabled = false;
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (userName == null) {
                shell.requiredArg(NAME_FLAG, this);
            }
            if (password != null) {
                if (password.isEmpty()) {
                    return "Password may not be empty";
                }
                plainPasswd = password.toCharArray();
            } else {
                ShellPasswordReader READER = new ShellPasswordReader();
                plainPasswd = CommandUtils.getPasswordFromInput(READER, this);
            }
            try {
                int planId = cs.createCreateUserPlan(this.planName, userName, isEnabled, isAdmin, plainPasswd);
                SecurityUtils.clearPassword(plainPasswd);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return COMMAND_SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return COMMAND_DESC;
        }
    }

    static final class ChangeUserSub
    extends PlanSubCommand {
        static final String COMMAND_SYNTAX = "plan change-user -name <user name> [-disable | -enable]" + eolt + "[-set-password [-password <new password>] " + "[-retain-current-password]]" + eolt + "[-clear-retained-password]" + genericFlags;
        static final String COMMAND_DESC = "Change a user with the specified name in the store. The" + eolt + "-retain-current-password argument option " + "causes the current password to" + eolt + "be remembered " + "during the -set-password operation as a valid alternate " + eolt + "password for configured retention time or until" + " cleared using -clear-retained-password." + eolt + "If a retained password has already been set for the user," + eolt + "setting retained password again will cause an " + "error to be reported.";
        static final String RETAIN_FLAG = "-retain-current-password";
        static final String CLEAR_FLAG = "-clear-retained-password";
        static final String DISABLE_FLAG = "-disable";
        static final String ENABLE_FLAG = "-enable";
        static final String SET_PASSWORD_FLAG = "-set-password";
        static final String PASSWORD_FLAG = "-password";
        static final String NAME_FLAG = "-name";

        ChangeUserSub() {
            super("change-user", 10);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            String userName = null;
            String password = null;
            boolean retainPassword = false;
            boolean clearRetainedPassword = false;
            boolean changePassword = false;
            char[] newPlainPassword = null;
            Boolean isEnabled = null;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (NAME_FLAG.equals(arg)) {
                    userName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (PASSWORD_FLAG.equals(arg)) {
                    password = Shell.nextArg(args, i++, this);
                    continue;
                }
                if (SET_PASSWORD_FLAG.equals(arg)) {
                    changePassword = true;
                    continue;
                }
                if (DISABLE_FLAG.equals(arg)) {
                    isEnabled = false;
                    continue;
                }
                if (ENABLE_FLAG.equals(arg)) {
                    isEnabled = true;
                    continue;
                }
                if (RETAIN_FLAG.equals(arg)) {
                    retainPassword = true;
                    continue;
                }
                if (CLEAR_FLAG.equals(arg)) {
                    clearRetainedPassword = true;
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (userName == null) {
                shell.requiredArg(NAME_FLAG, this);
            }
            if (password != null && !changePassword) {
                return "Option -password is only valid inconjunction with -set-password.";
            }
            if (retainPassword && !changePassword) {
                return "Option -retain-current-password is only valid inconjunction with -set-password.";
            }
            if (isEnabled == null && !changePassword && !clearRetainedPassword) {
                return "Nothing changed for user " + userName;
            }
            if (changePassword) {
                if (password != null) {
                    if (password.isEmpty()) {
                        return "Password may not be empty";
                    }
                    newPlainPassword = password.toCharArray();
                } else {
                    ShellPasswordReader READER = new ShellPasswordReader();
                    newPlainPassword = CommandUtils.getPasswordFromInput(READER, this);
                }
            }
            try {
                int planId = cs.createChangeUserPlan(this.planName, userName, isEnabled, newPlainPassword, retainPassword, clearRetainedPassword);
                SecurityUtils.clearPassword(newPlainPassword);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return COMMAND_SYNTAX;
        }

        @Override
        protected String getCommandDescription() {
            return COMMAND_DESC;
        }
    }

    static final class ChangeParamsSub
    extends PlanSubCommand {
        final String incompatibleAllError = "Invalid argument combination: Only one of the flags -all-rns, -all-sns, -all-admins and -security may be used.";
        final String serviceAllError = "Invalid argument combination: -service flag cannot be used with -all-rns, -all-admins or -security flags";
        final String serviceDcError = "Invalid argument combination: -service flag cannot be used with -zn, -znname, -dc, or -dcname flag";
        final String commandSyntax = "plan change-parameters -security | -service <id> | -all-rns [-zn <id> | -znname <name>] | -all-admins [-zn <id> | -znname <name>] [-dry-run]" + genericFlags + " -params [name=value]*";
        final String commandDesc = "Changes parameters for either the specified service, or for" + eolt + "all service instances of the same type that are deployed to" + eolt + "the specified zone or all zones.  The -security" + eolt + "flag allows changing store-wide global security parameters," + eolt + "and should never be used with other flags. The -service" + eolt + "flag allows a single instance to be affected; and should" + eolt + "never be used with either the -zn or -znname flag.  One of" + eolt + "the -all-* flags can be combined with the -zn or -znname" + eolt + "flag to change all instances of the service type deployed" + eolt + "to the specified zone; leaving unchanged, any" + eolt + "instances of the specified type deployed to other" + eolt + "zones. If one of the -all-* flags is used without" + eolt + "also specifying the zone, then the desired parameter" + eolt + "change will be applied to all instances of the specified" + eolt + "type within the store, regardless of zone.  The" + eolt + "parameters to change are specified via the -params flag," + eolt + "and consist of name/value pairs separated by spaces; where" + eolt + "any parameter values with embedded spaces must be quoted" + eolt + "(for example, name=\"value with spaces\").  Finally, if the" + eolt + "-dry-run flag is specified, the new parameters are returned" + eolt + "without applying the specified change." + eol + eolt + "Use \"show parameters\" to see what parameters can be " + "modified";
        String serviceName;
        StorageNodeId snid;
        RepNodeId rnid;
        AdminId aid;
        boolean allAdmin;
        boolean allRN;
        boolean allSN;
        boolean security;
        boolean dryRun;

        ChangeParamsSub() {
            super("change-parameters", 10);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            int i;
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            this.serviceName = null;
            this.snid = null;
            this.aid = null;
            this.rnid = null;
            this.security = false;
            this.dryRun = false;
            this.allSN = false;
            this.allRN = false;
            this.allAdmin = false;
            boolean showHidden = cmd.showHidden();
            boolean foundParams = false;
            DatacenterId dcid = null;
            String dcName = null;
            boolean getDcId = false;
            boolean deprecatedDcFlag = false;
            for (i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-service".equals(arg)) {
                    this.serviceName = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-all-rns".equals(arg)) {
                    this.allRN = true;
                    continue;
                }
                if ("-all-admins".equals(arg)) {
                    this.allAdmin = true;
                    continue;
                }
                if ("-all-sns".equals(arg)) {
                    this.allSN = true;
                    continue;
                }
                if (CommandUtils.isDatacenterIdFlag(arg)) {
                    dcid = DatacenterId.parse(Shell.nextArg(args, i++, this));
                    if (!CommandUtils.isDeprecatedDatacenterId(arg, args[i])) continue;
                    deprecatedDcFlag = true;
                    continue;
                }
                if (CommandUtils.isDatacenterNameFlag(arg)) {
                    dcName = Shell.nextArg(args, i++, this);
                    if (!CommandUtils.isDeprecatedDatacenterName(arg)) continue;
                    deprecatedDcFlag = true;
                    continue;
                }
                if ("-security".equals(arg)) {
                    this.security = true;
                    continue;
                }
                if ("-hidden".equals(arg)) {
                    showHidden = true;
                    continue;
                }
                if ("-dry-run".equals(arg)) {
                    this.dryRun = true;
                    continue;
                }
                if ("-params".equals(arg)) {
                    ++i;
                    foundParams = true;
                    break;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (this.serviceName == null) {
                if (!(this.allAdmin || this.allRN || this.allSN || this.security)) {
                    shell.requiredArg(null, this);
                } else {
                    if ((this.allAdmin ? 1 : 0) + (this.allRN ? 1 : 0) + (this.allSN ? 1 : 0) + (this.security ? 1 : 0) > 1) {
                        throw new ShellUsageException("Invalid argument combination: Only one of the flags -all-rns, -all-sns, -all-admins and -security may be used.", this);
                    }
                    if (dcName != null) {
                        getDcId = true;
                    }
                }
            } else {
                if (this.allAdmin || this.allRN || this.allSN || this.security) {
                    throw new ShellUsageException("Invalid argument combination: -service flag cannot be used with -all-rns, -all-admins or -security flags", this);
                }
                if (dcid != null || dcName != null) {
                    throw new ShellUsageException("Invalid argument combination: -service flag cannot be used with -zn, -znname, -dc, or -dcname flag", this);
                }
            }
            if (!foundParams) {
                shell.requiredArg("-params", this);
            }
            if (args.length <= i) {
                return "No parameters were specified";
            }
            String deprecatedDcFlagPrefix = deprecatedDcFlag ? dcFlagsDeprecation : "";
            try {
                int planId = 0;
                ParameterMap map = this.createChangeMap(cs, args, i, showHidden);
                if (this.dryRun) {
                    return CommandUtils.formatParams(map, showHidden, null);
                }
                if (getDcId) {
                    dcid = CommandUtils.getDatacenterId(dcName, cs, this);
                }
                if (this.rnid != null) {
                    shell.verboseOutput("Changing parameters for " + this.rnid);
                    planId = cs.createChangeParamsPlan(this.planName, this.rnid, map);
                } else if (this.allRN) {
                    shell.verboseOutput("Changing parameters for all RepNodes" + (dcName != null ? " deployed to the " + dcName + " zone" : (dcid != null ? " deployed to the zone with id = " + dcid : "")));
                    planId = cs.createChangeAllParamsPlan(this.planName, dcid, map);
                } else if (this.snid != null) {
                    shell.verboseOutput("Changing parameters for " + this.snid);
                    planId = cs.createChangeParamsPlan(this.planName, this.snid, map);
                } else if (this.allAdmin) {
                    shell.verboseOutput("Changing parameters for all Admins" + (dcName != null ? " deployed to the " + dcName + " zone" : (dcid != null ? " deployed to the zone with id = " + dcid : "")));
                    planId = cs.createChangeAllAdminsPlan(this.planName, dcid, map);
                } else if (this.security) {
                    shell.verboseOutput("Changing global security parameters");
                    planId = cs.createChangeGlobalSecurityParamsPlan(this.planName, map);
                } else if (this.aid != null) {
                    shell.verboseOutput("Changing parameters for " + this.aid);
                    planId = cs.createChangeParamsPlan(this.planName, this.aid, map);
                } else if (this.allSN) {
                    return "Can't change all SN params at this time";
                }
                if (shell.getVerbose()) {
                    shell.verboseOutput("New parameters:" + eol + CommandUtils.formatParams(map, showHidden, null));
                }
                return deprecatedDcFlagPrefix + this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected String getCommandSyntax() {
            return this.commandSyntax;
        }

        @Override
        protected String getCommandDescription() {
            return this.commandDesc;
        }

        private ParameterMap getServiceMap(CommandServiceAPI cs) throws ShellException, RemoteException {
            ParameterMap map = null;
            Parameters p = cs.getParameters();
            try {
                this.rnid = RepNodeId.parse(this.serviceName);
                RepNodeParams rnp = p.get(this.rnid);
                if (rnp == null) {
                    throw new ShellUsageException("No such service: " + this.serviceName, this);
                }
                map = rnp.getMap();
            }
            catch (IllegalArgumentException ignored) {
                try {
                    this.snid = StorageNodeId.parse(this.serviceName);
                    StorageNodeParams snp = p.get(this.snid);
                    if (snp == null) {
                        throw new ShellUsageException("No such service: " + this.serviceName, this);
                    }
                    map = snp.getMap();
                }
                catch (IllegalArgumentException ignored1) {
                    try {
                        this.aid = AdminId.parse(this.serviceName);
                        AdminParams ap = p.get(this.aid);
                        if (ap == null) {
                            throw new ShellUsageException("No such service: " + this.serviceName, this);
                        }
                        map = ap.getMap();
                    }
                    catch (IllegalArgumentException ignored2) {
                        throw new ShellUsageException("Invalid service name: " + this.serviceName, this);
                    }
                }
            }
            return map;
        }

        private ParameterMap createChangeMap(CommandServiceAPI cs, String[] args, int i, boolean showHidden) throws ShellException, RemoteException {
            ParameterState.Scope scope;
            ParameterMap map = null;
            ParameterState.Info info = null;
            if (this.serviceName != null) {
                map = this.getServiceMap(cs);
                scope = null;
                info = map.getType().equals("repNodeParams") ? ParameterState.Info.REPNODE : (map.getType().equals("storageNodeParams") ? ParameterState.Info.SNA : ParameterState.Info.ADMIN);
            } else {
                scope = ParameterState.Scope.STORE;
                map = new ParameterMap();
                if (this.allRN) {
                    map.setType("repNodeParams");
                    info = ParameterState.Info.REPNODE;
                } else if (this.allSN) {
                    map.setType("storageNodeParams");
                    info = ParameterState.Info.SNA;
                } else if (this.security) {
                    map.setType("globalParams");
                    info = ParameterState.Info.GLOBAL;
                } else {
                    map.setType("adminParams");
                    info = ParameterState.Info.ADMIN;
                }
            }
            CommandUtils.parseParams(map, args, i, info, scope, showHidden, this);
            return map;
        }
    }

    static class ChangeMountPointSub
    extends PlanSubCommand {
        ChangeMountPointSub() {
            super("change-storagedir", 9);
        }

        @Override
        public String exec(String[] args, Shell shell) throws ShellException {
            Shell.checkHelp(args, this);
            CommandShell cmd = (CommandShell)shell;
            CommandServiceAPI cs = cmd.getAdmin();
            StorageNodeId snid = null;
            String path = null;
            boolean add = true;
            boolean addOrRemove = false;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-sn".equals(arg)) {
                    String argString = Shell.nextArg(args, i++, this);
                    snid = this.parseSnid(argString);
                    continue;
                }
                if ("-storagedir".equals(arg)) {
                    path = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-path".equals(arg)) {
                    path = Shell.nextArg(args, i++, this);
                    continue;
                }
                if ("-add".equals(arg)) {
                    add = true;
                    addOrRemove = true;
                    continue;
                }
                if ("-remove".equals(arg)) {
                    add = false;
                    addOrRemove = true;
                    continue;
                }
                i += this.checkGenericArg(arg, args, i);
            }
            if (snid == null || !addOrRemove) {
                shell.requiredArg(null, this);
            }
            try {
                Parameters p = cs.getParameters();
                StorageNodeParams snp = p.get(snid);
                ParameterMap mountMap = null;
                try {
                    mountMap = StorageNodeParams.changeMountMap(p, snp, add, path);
                }
                catch (IllegalCommandException e) {
                    throw new ShellUsageException(e.getMessage(), this);
                }
                int planId = cs.createChangeParamsPlan(this.planName, snid, mountMap);
                return this.executePlan(planId, cs, shell);
            }
            catch (RemoteException re) {
                cmd.noAdmin(re);
                return "";
            }
        }

        @Override
        protected boolean matches(String commandName) {
            return super.matches(commandName) || Shell.matches(commandName, "change-mountpoint", this.prefixMatchLength);
        }

        @Override
        protected String getCommandSyntax() {
            return "plan change-storagedir -sn <id> " + eolt + "-storagedir <path to storage directory> -add|-remove " + genericFlags;
        }

        @Override
        protected String getCommandDescription() {
            return "Adds or remove a storage directory on a Storage Node," + eolt + "for storing a Replication Node";
        }
    }

    static abstract class PlanSubCommand
    extends SharedCommandWithSubs.SharedSubCommand {
        protected boolean execute;
        protected boolean wait;
        protected boolean force;
        protected String planName;
        static final String genericFlags = eolt + "[-plan-name <name>] [-wait] [-noexecute] [-force]";
        static final String dcFlagsDeprecation = "The -dc and -dcname flags, and the dc<ID> ID format, are deprecated" + eol + "and have been replaced by -zn, -znname, and zn<ID>." + eol + eol;

        protected PlanSubCommand(String name, int prefixMatchLength) {
            super(name, prefixMatchLength);
        }

        @Override
        public String execute(String[] args, Shell shell) throws ShellException {
            this.wait = false;
            this.execute = true;
            this.force = false;
            this.planName = null;
            return this.exec(args, shell);
        }

        protected int checkGenericArg(String arg, String[] args, int i) throws ShellException {
            int rval = 0;
            if ("-plan-name".equals(arg)) {
                this.planName = Shell.nextArg(args, i, this);
                rval = 1;
            } else if ("-wait".equals(arg)) {
                this.wait = true;
            } else if ("-noexecute".equals(arg)) {
                this.execute = false;
            } else if ("-force".equals(arg)) {
                this.force = true;
            } else {
                throw new ShellUsageException("Invalid argument: " + arg, this);
            }
            return rval;
        }

        public abstract String exec(String[] var1, Shell var2) throws ShellException;

        protected static int getLastPlanId(CommandServiceAPI cs) throws RemoteException {
            int[] range = cs.getPlanIdRange(0L, new Date().getTime(), 1);
            return range[0];
        }

        protected String executePlan(int planId, CommandServiceAPI cs, Shell shell) throws RemoteException {
            cs.approvePlan(planId);
            if (this.execute) {
                cs.executePlan(planId, this.force);
                if (this.wait) {
                    shell.println("Executed plan " + planId + ", waiting for completion...");
                    Plan.State state = cs.awaitPlan(planId, 0, null);
                    return state.getWaitMessage(planId);
                }
                return "Started plan " + planId + ". Use show plan -id " + planId + " to check status." + eolt + "To wait for completion, use plan wait -id " + planId;
            }
            return "Created plan without execution: " + planId;
        }
    }
}

