/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.client;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.impl.topo.Topology;
import oracle.kv.util.Ping;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;

class PingCommand
extends ShellCommand {
    PingCommand() {
        super("ping", 3);
    }

    @Override
    public String execute(String[] args, Shell shell) throws ShellException {
        if (args.length != 1) {
            shell.badArgCount(this);
        }
        CommandShell cmd = (CommandShell)shell;
        CommandServiceAPI cs = cmd.getAdmin();
        try {
            Topology topo = cs.getTopology();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(os);
            Ping.pingTopology(topo, ps);
            return os.toString();
        }
        catch (RemoteException re) {
            cmd.noAdmin(re);
            return "";
        }
    }

    @Override
    public String getCommandDescription() {
        return "\"Ping\"s the runtime components of a store.  Only those" + eolt + "components available from the Topology are " + "contacted." + eolt + "This leaves out Admin services.";
    }
}

