/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.CommandServiceAPI;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebService {
    CommandServiceAPI aservice;
    Server jetty;
    Logger logger;
    WebAppContext wac = null;

    public WebService(CommandServiceAPI aservice, Logger logger) {
        this.aservice = aservice;
        this.logger = logger;
        Log.setLog(new KVLogFacade(logger));
    }

    public void start(int httpPort) throws Exception {
        this.jetty = new Server(httpPort);
        this.wac = new WebAppContext();
        this.wac.setContextPath("/");
        this.wac.setWar(this.getClass().getClassLoader().getResource("war/KVAdminUI").toExternalForm());
        this.wac.setAttribute("AdminService", this.aservice);
        this.wac.setAttribute("AdminLogger", this.logger);
        this.jetty.setHandler(this.wac);
        this.jetty.start();
    }

    public void stop() throws Exception {
        if (this.jetty != null) {
            this.jetty.stop();
        }
        this.logger.info("Stopped Jetty");
    }

    public void resetLog(Logger newLogger) {
        this.logger = newLogger;
        Log.setLog(new KVLogFacade(newLogger));
        if (this.wac == null) {
            this.logger.warning("Can't set logger for null WebAppContext");
        } else {
            this.wac.setAttribute("AdminLogger", newLogger);
        }
    }

    static class KVLogFacade
    implements org.eclipse.jetty.util.log.Logger {
        private final Logger julLogger;
        private final boolean isIgnored;

        public KVLogFacade(Logger logger) {
            this.julLogger = logger;
            this.isIgnored = Boolean.parseBoolean(System.getProperty("org.eclipse.jetty.util.log.IGNORED", "false"));
        }

        @Override
        public String getName() {
            return this.julLogger.getName();
        }

        @Override
        public void warn(String msg, Object ... args) {
            this.julLogger.log(Level.WARNING, this.format(msg, args));
        }

        @Override
        public void warn(Throwable thrown) {
            this.warn("", thrown);
        }

        @Override
        public void warn(String msg, Throwable thrown) {
            this.julLogger.log(Level.WARNING, msg, thrown);
        }

        @Override
        public void info(String msg, Object ... args) {
            this.julLogger.log(Level.INFO, this.format(msg, args));
        }

        @Override
        public void info(Throwable thrown) {
            this.info("", thrown);
        }

        @Override
        public void info(String msg, Throwable thrown) {
            this.julLogger.log(Level.INFO, msg, thrown);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.julLogger.isLoggable(Level.FINE);
        }

        @Override
        public void setDebugEnabled(boolean enabled) {
            this.julLogger.setLevel(Level.FINE);
        }

        @Override
        public void debug(String msg, Object ... args) {
            this.julLogger.log(Level.FINE, this.format(msg, args));
        }

        @Override
        public void debug(Throwable thrown) {
            this.debug("", thrown);
        }

        @Override
        public void debug(String msg, Throwable thrown) {
            this.julLogger.log(Level.FINE, msg, thrown);
        }

        @Override
        public org.eclipse.jetty.util.log.Logger getLogger(String name) {
            return this;
        }

        @Override
        public void ignore(Throwable ignored) {
            if (this.isIgnored) {
                this.warn("IGNORED", ignored);
            }
        }

        private String format(String msg, Object ... args) {
            if (msg == null) {
                msg = "";
            }
            String braces = "{}";
            StringBuilder builder = new StringBuilder();
            int start = 0;
            for (Object arg : args) {
                int bracesIndex = msg.indexOf(braces, start);
                if (bracesIndex < 0) {
                    builder.append(msg.substring(start));
                    builder.append(" ");
                    builder.append(arg);
                    start = msg.length();
                    continue;
                }
                builder.append(msg.substring(start, bracesIndex));
                builder.append(String.valueOf(arg));
                start = bracesIndex + braces.length();
            }
            builder.append(msg.substring(start));
            return builder.toString();
        }
    }
}

