/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.kv.impl.admin.VerifyConfiguration;

public class VerifyResults
implements Serializable {
    private static final String eol = System.getProperty("line.separator");
    private static final long serialVersionUID = 1L;
    private final List<VerifyConfiguration.Problem> violations;
    private final List<VerifyConfiguration.Problem> warnings;
    private final String progressReport;

    VerifyResults(String progressReport, List<VerifyConfiguration.Problem> violations, List<VerifyConfiguration.Problem> warnings) {
        this.progressReport = progressReport;
        this.violations = violations;
        this.warnings = warnings;
    }

    VerifyResults(List<VerifyConfiguration.Problem> violations, List<VerifyConfiguration.Problem> warnings) {
        this.progressReport = null;
        this.violations = violations;
        this.warnings = warnings;
    }

    public String getProgressReport() {
        return this.progressReport;
    }

    public int numWarnings() {
        return this.warnings.size();
    }

    public List<VerifyConfiguration.Problem> getViolations() {
        return this.violations;
    }

    public int numViolations() {
        return this.violations.size();
    }

    public List<VerifyConfiguration.Problem> getWarnings() {
        return this.warnings;
    }

    public boolean okay() {
        return this.violations.size() == 0 && this.warnings.size() == 0;
    }

    public String display() {
        int numWarnings;
        int numViolations = this.violations.size();
        if (numViolations + (numWarnings = this.warnings.size()) == 0) {
            return "Verification complete, no violations.";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Verification complete, ").append(numViolations);
        if (numViolations == 1) {
            sb.append(" violation, ");
        } else {
            sb.append(" violations, ");
        }
        sb.append(numWarnings);
        if (numWarnings == 1) {
            sb.append(" note");
        } else {
            sb.append(" notes");
        }
        sb.append(" found.").append(eol);
        Comparator<VerifyConfiguration.Problem> resourceComparator = new Comparator<VerifyConfiguration.Problem>(){

            @Override
            public int compare(VerifyConfiguration.Problem p1, VerifyConfiguration.Problem p2) {
                return p1.getResourceId().toString().compareTo(p2.getResourceId().toString());
            }
        };
        Collections.sort(this.violations, resourceComparator);
        Collections.sort(this.warnings, resourceComparator);
        for (VerifyConfiguration.Problem problem : this.violations) {
            sb.append("Verification violation: [").append(problem.getResourceId()).append("]\t").append(problem).append(eol);
        }
        for (VerifyConfiguration.Problem problem : this.warnings) {
            sb.append("Verification note: [").append(problem.getResourceId()).append("]\t").append(problem).append(eol);
        }
        return sb.toString();
    }
}

