/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.io.Serializable;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.TopologyCheck;
import oracle.kv.impl.admin.TopologyCheckUtils;
import oracle.kv.impl.admin.VerifyResults;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.topo.Rules;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterState;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.sna.StorageNodeStatus;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.FormatUtils;
import oracle.kv.impl.util.VersionUtil;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.util.Ping;

public class VerifyConfiguration {
    private static final String eol = System.getProperty("line.separator");
    private final Admin admin;
    private final boolean listAll;
    private final boolean showProgress;
    private final Logger logger;
    private final TopologyCheck topoChecker;
    private final StringBuilder progressReport;
    private final List<Problem> violations;
    private final List<Problem> warnings;
    private final Repairs repairs;

    public VerifyConfiguration(Admin admin, boolean showProgress, boolean listAll, Logger logger) {
        this.admin = admin;
        this.showProgress = showProgress;
        this.listAll = listAll;
        this.logger = logger;
        this.violations = new ArrayList<Problem>();
        this.warnings = new ArrayList<Problem>();
        this.progressReport = new StringBuilder();
        this.repairs = new Repairs();
        this.topoChecker = new TopologyCheck(logger, admin.getCurrentTopology(), admin.getCurrentParameters());
    }

    public boolean verifyTopology() {
        return this.verifyTopology(this.admin.getCurrentTopology(), this.admin.getLoginManager(), this.admin.getCurrentParameters(), true);
    }

    public boolean verifyUpgrade(KVVersion targetVersion, List<StorageNodeId> snIds) {
        this.admin.getLogger().log(Level.INFO, "Verifying upgrade to target version: {0}", targetVersion.getNumericVersionString());
        this.violations.clear();
        this.warnings.clear();
        this.repairs.clear();
        Topology topology = this.admin.getCurrentTopology();
        RegistryUtils registryUtils = new RegistryUtils(topology, this.admin.getLoginManager());
        if (snIds == null) {
            snIds = topology.getStorageNodeIds();
        }
        for (StorageNodeId snId : snIds) {
            this.verifySNUpgrade(snId, targetVersion, registryUtils, topology);
        }
        VerifyResults vResults = new VerifyResults(this.progressReport.toString(), this.violations, this.warnings);
        this.logger.log(Level.INFO, "{0}", vResults.display());
        return vResults.okay();
    }

    private void verifySNUpgrade(StorageNodeId snId, KVVersion targetVersion, RegistryUtils registryUtils, Topology topology) {
        StorageNodeStatus snStatus = null;
        try {
            snStatus = registryUtils.getStorageNodeAgent(snId).ping();
        }
        catch (RemoteException re) {
            this.violations.add(new RMIFailed(snId, re, "ping()", this.showProgress, this.logger, this.progressReport));
        }
        catch (NotBoundException nbe) {
            this.violations.add(new RMIFailed(snId, nbe, this.showProgress, this.logger, this.progressReport));
        }
        if (snStatus != null) {
            KVVersion snVersion = snStatus.getKVVersion();
            if (snVersion.compareTo(targetVersion) < 0) {
                this.warnings.add(new UpgradeNeeded(snId, snVersion, targetVersion, this.showProgress, this.logger, this.progressReport));
            } else {
                this.verifyRNUpgrade(snVersion, topology.getHostedRepNodeIds(snId), registryUtils);
            }
        }
        if (this.listAll) {
            String details = "Verify upgrade: " + Ping.displayStorageNode(topology, topology.get(snId), snStatus);
            this.logger.info(details);
            this.progressReport.append(details).append(eol);
        }
    }

    private void verifyRNUpgrade(KVVersion snVersion, Set<RepNodeId> hostedRepNodeIds, RegistryUtils registryUtils) {
        for (RepNodeId rnId : hostedRepNodeIds) {
            try {
                RepNodeAdminAPI rn = registryUtils.getRepNodeAdmin(rnId);
                KVVersion rnVersion = rn.getInfo().getSoftwareVersion();
                if (rnVersion.compareTo(snVersion) == 0) continue;
                this.warnings.add(new UpgradeNeeded(rnId, rnVersion, snVersion, this.showProgress, this.logger, this.progressReport));
            }
            catch (RemoteException re) {
                this.violations.add(new RMIFailed(rnId, re, "ping()", this.showProgress, this.logger, this.progressReport));
            }
            catch (NotBoundException nbe) {
                this.violations.add(new RMIFailed(rnId, nbe, this.showProgress, this.logger, this.progressReport));
            }
        }
    }

    public boolean verifyPrerequisite(KVVersion targetVersion, KVVersion prerequisiteVersion, List<StorageNodeId> snIds) {
        this.admin.getLogger().log(Level.INFO, "Checking upgrade to target version: {0}, prerequisite: {1}", new Object[]{targetVersion.getNumericVersionString(), prerequisiteVersion.getNumericVersionString()});
        Topology topology = this.admin.getCurrentTopology();
        RegistryUtils registryUtils = new RegistryUtils(topology, this.admin.getLoginManager());
        if (snIds == null) {
            snIds = topology.getStorageNodeIds();
        }
        for (StorageNodeId snId : snIds) {
            this.verifySNPrerequisite(snId, targetVersion, prerequisiteVersion, registryUtils, topology);
        }
        VerifyResults vResults = new VerifyResults(this.progressReport.toString(), this.violations, this.warnings);
        this.logger.log(Level.INFO, "{0}", vResults.display());
        return vResults.okay();
    }

    private void verifySNPrerequisite(StorageNodeId snId, KVVersion targetVersion, KVVersion prerequisiteVersion, RegistryUtils registryUtils, Topology topology) {
        StorageNodeStatus snStatus = null;
        try {
            StorageNodeAgentAPI sna = registryUtils.getStorageNodeAgent(snId);
            snStatus = sna.ping();
        }
        catch (RemoteException re) {
            this.violations.add(new RMIFailed(snId, re, "ping()", this.showProgress, this.logger, this.progressReport));
        }
        catch (NotBoundException nbe) {
            this.violations.add(new RMIFailed(snId, nbe, this.showProgress, this.logger, this.progressReport));
        }
        if (snStatus != null) {
            KVVersion snVersion = snStatus.getKVVersion();
            if (snVersion.compareTo(prerequisiteVersion) < 0) {
                this.violations.add(new UpgradeNeeded(snId, snVersion, prerequisiteVersion, this.showProgress, this.logger, this.progressReport));
            } else if (VersionUtil.compareMinorVersion(snVersion, targetVersion) > 0) {
                this.violations.add(new BadDowngrade(snId, snVersion, prerequisiteVersion, this.showProgress, this.logger, this.progressReport));
            }
        }
        if (this.listAll) {
            String details = "Verify prerequisite: " + Ping.displayStorageNode(topology, topology.get(snId), snStatus);
            this.logger.info(details);
            this.progressReport.append(details).append(eol);
        }
    }

    public static String displayTopology(Topology topology) {
        return "Verify: starting verification of " + topology.getKVStoreName() + " based upon topology sequence #" + topology.getSequenceNumber() + eol + topology.getPartitionMap().getNPartitions() + " partitions and " + topology.getStorageNodeMap().size() + " storage nodes. Version: " + KVVersion.CURRENT_VERSION.getNumericVersionString() + " Time: " + FormatUtils.formatDateAndTime(System.currentTimeMillis());
    }

    synchronized boolean verifyTopology(Topology topology, LoginManager loginMgr, Parameters currentParams, boolean topoIsDeployed) {
        RegistryUtils registryUtils = new RegistryUtils(topology, loginMgr);
        Rules.Results results = Rules.validate(topology, currentParams, topoIsDeployed);
        this.violations.clear();
        this.violations.addAll(results.getViolations());
        this.warnings.clear();
        this.warnings.addAll(results.getWarnings());
        this.repairs.clear();
        this.logger.info(VerifyConfiguration.displayTopology(topology));
        this.checkServices(topology, currentParams, registryUtils);
        VerifyResults vResults = new VerifyResults(this.progressReport.toString(), this.violations, this.warnings);
        this.logger.log(Level.INFO, "{0}", vResults.display());
        return vResults.okay();
    }

    private void checkServices(Topology topology, Parameters currentParams, RegistryUtils registryUtils) {
        Map<StorageNodeId, TopologyCheckUtils.SNServices> sortedResources = TopologyCheckUtils.groupServicesBySN(topology, currentParams);
        for (TopologyCheckUtils.SNServices nodeInfo : sortedResources.values()) {
            StorageNodeId snId = nodeInfo.getStorageNodeId();
            if (this.showProgress) {
                String msg = "Verify: == checking storage node " + snId + " ==";
                this.logger.info(msg);
                this.progressReport.append(msg).append(eol);
            }
            this.checkStorageNode(registryUtils, topology, currentParams, snId, nodeInfo);
            AdminId adminId = nodeInfo.getAdminId();
            if (adminId != null) {
                this.checkAdmin(currentParams, adminId);
            }
            for (RepNodeId rnId : nodeInfo.getAllRepNodeIds()) {
                this.checkRepNode(registryUtils, topology, snId, rnId, currentParams);
            }
        }
    }

    private void checkAdmin(Parameters params, AdminId aId) {
        StorageNodeId hostSN = params.get(aId).getStorageNodeId();
        StorageNodeParams snp = params.get(hostSN);
        boolean pingProblem = false;
        CommandServiceAPI cs = null;
        ConfigurableService.ServiceStatus status = ConfigurableService.ServiceStatus.UNREACHABLE;
        try {
            cs = RegistryUtils.getAdmin(snp.getHostname(), snp.getRegistryPort(), this.admin.getLoginManager());
            status = cs.ping();
        }
        catch (RemoteException re) {
            this.violations.add(new RMIFailed(aId, re, "ping()", this.showProgress, this.logger, this.progressReport));
            pingProblem = true;
        }
        catch (NotBoundException e) {
            this.violations.add(new RMIFailed(aId, e, this.showProgress, this.logger, this.progressReport));
            pingProblem = true;
        }
        TopologyCheck.Remedy remedy = this.topoChecker.checkAdminLocation(this.admin, aId);
        if (remedy.canFix()) {
            this.repairs.add(remedy);
        }
        if (!pingProblem) {
            if (status.equals((Object)ConfigurableService.ServiceStatus.RUNNING)) {
                this.checkAdminParams(cs, params, aId, hostSN);
            } else {
                this.violations.add(new StatusNotRight(aId, ConfigurableService.ServiceStatus.RUNNING, status, this.showProgress, this.logger, this.progressReport));
            }
        }
        if (this.listAll) {
            String details = "Verify: \tAdmin [" + aId + "]\t\tStatus: " + (Object)((Object)status);
            this.logger.info(details);
            this.progressReport.append(details).append(eol);
        }
    }

    private void checkStorageNode(RegistryUtils regUtils, Topology topology, Parameters currentParams, StorageNodeId snId, TopologyCheckUtils.SNServices nodeInfo) {
        boolean pingProblem = false;
        StorageNodeStatus snStatus = null;
        StorageNodeAgentAPI sna = null;
        ConfigurableService.ServiceStatus status = ConfigurableService.ServiceStatus.UNREACHABLE;
        try {
            sna = regUtils.getStorageNodeAgent(snId);
            snStatus = sna.ping();
            status = snStatus.getServiceStatus();
        }
        catch (RemoteException re) {
            this.violations.add(new RMIFailed(snId, re, "ping()", this.showProgress, this.logger, this.progressReport));
            pingProblem = true;
        }
        catch (NotBoundException e) {
            this.violations.add(new RMIFailed(snId, e, this.showProgress, this.logger, this.progressReport));
            pingProblem = true;
        }
        if (this.listAll) {
            String details = "Verify: " + Ping.displayStorageNode(topology, topology.get(snId), snStatus);
            this.logger.info(details);
            this.progressReport.append(details).append(eol);
        }
        if (!pingProblem) {
            if (status.equals((Object)ConfigurableService.ServiceStatus.RUNNING)) {
                this.checkSNParams(sna, snId, currentParams, nodeInfo);
            } else {
                this.violations.add(new StatusNotRight(snId, ConfigurableService.ServiceStatus.RUNNING, status, this.showProgress, this.logger, this.progressReport));
            }
            if (!KVVersion.CURRENT_VERSION.equals(snStatus.getKVVersion())) {
                this.violations.add(new VersionDifference(snId, snStatus.getKVVersion(), this.showProgress, this.logger, this.progressReport));
            }
        }
    }

    private void checkRepNode(RegistryUtils regUtils, Topology topology, StorageNodeId snId, RepNodeId rnId, Parameters currentParams) {
        boolean pingProblem = false;
        ConfigurableService.ServiceStatus status = ConfigurableService.ServiceStatus.UNREACHABLE;
        RepNodeStatus rnStatus = null;
        RepNodeAdminAPI rna = null;
        boolean isDisabled = currentParams.get(rnId).isDisabled();
        ConfigurableService.ServiceStatus expected = isDisabled ? ConfigurableService.ServiceStatus.UNREACHABLE : ConfigurableService.ServiceStatus.RUNNING;
        try {
            rna = regUtils.getRepNodeAdmin(rnId);
            rnStatus = rna.ping();
            status = rnStatus.getServiceStatus();
        }
        catch (RemoteException re) {
            if (!expected.equals((Object)ConfigurableService.ServiceStatus.UNREACHABLE)) {
                this.violations.add(new RMIFailed(rnId, re, "ping()", this.showProgress, this.logger, this.progressReport));
                pingProblem = true;
            } else {
                this.reportStoppedRN(rnId, snId);
            }
        }
        catch (NotBoundException e) {
            if (!expected.equals((Object)ConfigurableService.ServiceStatus.UNREACHABLE)) {
                this.violations.add(new RMIFailed(rnId, e, this.showProgress, this.logger, this.progressReport));
                pingProblem = true;
            }
            this.reportStoppedRN(rnId, snId);
        }
        if (!pingProblem) {
            if (status.equals((Object)expected)) {
                if (status.equals((Object)ConfigurableService.ServiceStatus.RUNNING)) {
                    this.checkRNParams(rna, rnId, topology, currentParams);
                }
            } else {
                this.violations.add(new StatusNotRight(rnId, expected, status, this.showProgress, this.logger, this.progressReport));
            }
        }
        if (this.listAll) {
            StringBuilder details = new StringBuilder();
            details.append("Verify: ").append(Ping.displayRepNode(topology.get(rnId), rnStatus));
            if (expected.equals((Object)ConfigurableService.ServiceStatus.UNREACHABLE)) {
                details.append("(Stopped)");
            }
            this.logger.info(details.toString());
            this.progressReport.append((CharSequence)details).append(eol);
        }
    }

    private void reportStoppedRN(RepNodeId rnId, StorageNodeId snId) {
        this.warnings.add(new ServiceStopped(rnId, snId, this.showProgress, this.logger, this.progressReport, true));
        boolean previousRepair = this.repairs.repairExists(rnId);
        if (!previousRepair) {
            this.repairs.add(new TopologyCheck.Remedy(new TopologyCheck.RNLocationInput(TopologyCheck.TOPO_STATUS.HERE, TopologyCheck.CONFIG_STATUS.HERE), snId, rnId, TopologyCheck.REMEDY_TYPE.CREATE_RN, null));
        }
    }

    private void checkSNParams(StorageNodeAgentAPI sna, StorageNodeId snId, Parameters currentParams, TopologyCheckUtils.SNServices nodeInfo) {
        LoadParameters remoteParams;
        try {
            remoteParams = sna.getParams();
        }
        catch (RemoteException re) {
            this.violations.add(new RMIFailed(snId, re, "getParams", this.showProgress, this.logger, this.progressReport));
            return;
        }
        if (!this.compareParams(snId, remoteParams, currentParams.get(snId).getMap())) {
            return;
        }
        ParameterMap mountMap = currentParams.get(snId).getMountMap();
        if (mountMap != null) {
            if (!this.compareParams(snId, remoteParams, mountMap)) {
                return;
            }
        } else if (remoteParams.getMap("mountPoints") != null) {
            this.violations.add(new ParamMismatch(snId, "Parameter collection mountPointsmissing", this.showProgress, this.logger, this.progressReport));
            return;
        }
        if (!this.compareParams(snId, remoteParams, currentParams.getGlobalParams().getMap())) {
            return;
        }
        this.topoChecker.saveSNRemoteParams(snId, remoteParams);
        Set<RepNodeId> rnsToCheck = this.topoChecker.getPossibleRNs(snId);
        for (RepNodeId rnId : rnsToCheck) {
            TopologyCheck.Remedy remedy = null;
            try {
                remedy = this.topoChecker.checkRNLocation(this.admin, snId, rnId, false, false);
                if (remedy.getType() == TopologyCheck.REMEDY_TYPE.OKAY) continue;
                this.logger.log(Level.INFO, "{0}", new Object[]{remedy});
                Problem p = remedy.getType() == TopologyCheck.REMEDY_TYPE.CREATE_RN ? new ServiceStopped(remedy.getRNId(), remedy.getSNId(), this.showProgress, this.logger, this.progressReport, false) : new ParamMismatch(remedy.getRNId(), remedy.problemDescription(), this.showProgress, this.logger, this.progressReport);
                this.violations.add(p);
                if (!remedy.canFix()) continue;
                this.repairs.add(remedy);
            }
            catch (RemoteException e) {
                this.violations.add(new RMIFailed(snId, e, "checkRNLocation", this.showProgress, this.logger, this.progressReport));
            }
            catch (NotBoundException e) {
                this.violations.add(new RMIFailed(snId, e, this.showProgress, this.logger, this.progressReport));
            }
        }
        ParameterMap adminMap = remoteParams.getMapByType("adminParams");
        if (adminMap != null) {
            AdminId aid = new AdminId(adminMap.getOrZeroInt("adminId"));
            if (nodeInfo.getAdminId() == null || !aid.equals(nodeInfo.getAdminId())) {
                this.violations.add(new ParamMismatch(snId, "Storage Node is managing admin " + aid + "but the admin does not know this", this.showProgress, this.logger, this.progressReport));
            }
        } else if (nodeInfo.getAdminId() != null) {
            this.violations.add(new ParamMismatch(snId, "Storage Node is not managing an Admin but the admin believes it is", this.showProgress, this.logger, this.progressReport));
        }
    }

    private void checkRNParams(RepNodeAdminAPI rna, RepNodeId rnId, Topology topology, Parameters currentParams) {
        LoadParameters remoteParams;
        try {
            remoteParams = rna.getParams();
        }
        catch (RemoteException re) {
            this.violations.add(new RMIFailed(rnId, re, "getParams", this.showProgress, this.logger, this.progressReport));
            return;
        }
        if (!this.compareParams(rnId, remoteParams, currentParams.get(rnId).getMap(), new ExcludeDisableFilter())) {
            return;
        }
        StorageNodeId snId = topology.get(rnId).getStorageNodeId();
        if (!this.compareParams(rnId, remoteParams, currentParams.get(snId).getMap(), new SNPFilter())) {
            return;
        }
        if (!this.compareParams(rnId, remoteParams, currentParams.getGlobalParams().getMap())) {
            return;
        }
    }

    private void checkAdminParams(CommandServiceAPI cs, Parameters currentParams, AdminId targetAdminId, StorageNodeId hostSN) {
        LoadParameters remoteParams;
        if (this.admin != null && targetAdminId.equals(this.admin.getParams().getAdminParams().getAdminId())) {
            return;
        }
        try {
            remoteParams = cs.getParams();
        }
        catch (RemoteException re) {
            this.violations.add(new RMIFailed(targetAdminId, re, "getParams", this.showProgress, this.logger, this.progressReport));
            return;
        }
        if (!this.compareParams(targetAdminId, remoteParams, currentParams.get(targetAdminId).getMap())) {
            return;
        }
        if (!this.compareParams(targetAdminId, remoteParams, currentParams.get(hostSN).getMap(), new SNPFilter())) {
            return;
        }
        if (!this.compareParams(targetAdminId, remoteParams, currentParams.getGlobalParams().getMap())) {
            return;
        }
    }

    private boolean compareParams(ResourceId rId, LoadParameters remoteParams, ParameterMap adminCopy) {
        return this.compareParams(rId, remoteParams, adminCopy, new MapFilter());
    }

    private boolean compareParams(ResourceId rId, LoadParameters remoteParams, ParameterMap adminCopy, MapFilter filter) {
        ParameterMap remoteCopy = remoteParams.getMapByType(adminCopy.getType());
        if (remoteCopy == null) {
            this.violations.add(new ParamMismatch(rId, "Parameter collection " + adminCopy.getType() + " missing", this.showProgress, this.logger, this.progressReport));
            return false;
        }
        if (!(remoteCopy = filter.filter(remoteCopy)).equals(adminCopy = filter.filter(adminCopy))) {
            this.violations.add(new ParamMismatch(rId, adminCopy, remoteCopy, this.showProgress, this.logger, this.progressReport));
            return false;
        }
        return true;
    }

    public String getProgressReport() {
        return this.progressReport.toString();
    }

    private static void recordProgress(boolean showProgress, Logger logger, StringBuilder progressReport, Problem problem) {
        if (showProgress) {
            String msg = "Verify:         " + problem.getResourceId() + ": " + problem;
            logger.info(msg);
            progressReport.append(msg).append(eol);
        }
    }

    public VerifyResults getResults() {
        if (this.showProgress) {
            return new VerifyResults(this.getProgressReport(), this.violations, this.warnings);
        }
        return new VerifyResults(this.violations, this.warnings);
    }

    public TopologyCheck getTopoChecker() {
        return this.topoChecker;
    }

    public List<TopologyCheck.Remedy> getRepairs() {
        return this.repairs.getRepairs();
    }

    private class Repairs {
        private final List<TopologyCheck.Remedy> creates = new ArrayList<TopologyCheck.Remedy>();
        private final List<TopologyCheck.Remedy> removes = new ArrayList<TopologyCheck.Remedy>();
        private final List<TopologyCheck.Remedy> other = new ArrayList<TopologyCheck.Remedy>();

        void clear() {
            this.creates.clear();
            this.removes.clear();
            this.other.clear();
        }

        void add(TopologyCheck.Remedy remedy) {
            switch (remedy.getType()) {
                case CREATE_RN: {
                    this.creates.add(remedy);
                    break;
                }
                case REMOVE_RN: {
                    this.removes.add(remedy);
                    break;
                }
                default: {
                    this.other.add(remedy);
                }
            }
        }

        List<TopologyCheck.Remedy> getRepairs() {
            ArrayList<TopologyCheck.Remedy> r = new ArrayList<TopologyCheck.Remedy>();
            r.addAll(this.creates);
            r.addAll(this.other);
            r.addAll(this.removes);
            return r;
        }

        boolean repairExists(RepNodeId rnId) {
            for (TopologyCheck.Remedy r : this.creates) {
                if (!r.getRNId().equals(rnId)) continue;
                return true;
            }
            for (TopologyCheck.Remedy r : this.other) {
                if (!r.getRNId().equals(rnId)) continue;
                return true;
            }
            for (TopologyCheck.Remedy r : this.removes) {
                if (!r.getRNId().equals(rnId)) continue;
                return true;
            }
            return false;
        }
    }

    public static class BadDowngrade
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ResourceId rId;
        private final String desc;

        BadDowngrade(ResourceId rId, KVVersion rVersion, KVVersion targetVersion, boolean showProgress, Logger logger, StringBuilder progressReport) {
            this.rId = rId;
            this.desc = "Node cannot be downgraded to " + targetVersion.getNumericVersionString() + " because it is already at a newer minor version " + rVersion.getNumericVersionString();
            VerifyConfiguration.recordProgress(showProgress, logger, progressReport, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.rId;
        }

        public String toString() {
            return this.desc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.rId == null ? 0 : this.rId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BadDowngrade)) {
                return false;
            }
            BadDowngrade other = (BadDowngrade)obj;
            if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
                return false;
            }
            return !(this.rId == null ? other.rId != null : !this.rId.equals(other.rId));
        }
    }

    public static class UpgradeNeeded
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ResourceId rId;
        private final String desc;

        UpgradeNeeded(ResourceId rId, KVVersion rVersion, KVVersion targetVersion, boolean showProgress, Logger logger, StringBuilder progressReport) {
            this.rId = rId;
            this.desc = "Node needs to be upgraded from " + rVersion.getNumericVersionString() + " to version " + targetVersion.getNumericVersionString() + " or newer";
            VerifyConfiguration.recordProgress(showProgress, logger, progressReport, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.rId;
        }

        public String toString() {
            return this.desc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.rId == null ? 0 : this.rId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof UpgradeNeeded)) {
                return false;
            }
            UpgradeNeeded other = (UpgradeNeeded)obj;
            if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
                return false;
            }
            return !(this.rId == null ? other.rId != null : !this.rId.equals(other.rId));
        }
    }

    public static class VersionDifference
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final StorageNodeId snId;
        private final String desc;

        VersionDifference(StorageNodeId snId, KVVersion snVersion, boolean showProgress, Logger logger, StringBuilder progressReport) {
            this.snId = snId;
            this.desc = "Admin service version is " + KVVersion.CURRENT_VERSION + " but storage node version is " + snVersion;
            VerifyConfiguration.recordProgress(showProgress, logger, progressReport, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.snId;
        }

        public String toString() {
            return this.desc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.snId == null ? 0 : this.snId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof VersionDifference)) {
                return false;
            }
            VersionDifference other = (VersionDifference)obj;
            if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
                return false;
            }
            return !(this.snId == null ? other.snId != null : !this.snId.equals(other.snId));
        }
    }

    public static class ParamMismatch
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ResourceId rId;
        private final String mismatch;

        private static String getMismatchMessage(ParameterMap adminCopy, ParameterMap remoteCopy, ResourceId resourceId) {
            ParameterMap onRemoteButNotAdmin = adminCopy.diff(remoteCopy, false);
            ParameterMap onAdminButNotRemote = remoteCopy.diff(adminCopy, false);
            return "  Param on Admin but not on " + resourceId + " = " + onAdminButNotRemote.showContents(true) + eol + "  Param on " + resourceId + " but not on Admin = " + onRemoteButNotAdmin.showContents(true);
        }

        ParamMismatch(ResourceId rId, ParameterMap adminCopy, ParameterMap remoteCopy, boolean showProgress, Logger logger, StringBuilder progressReport) {
            this(rId, ParamMismatch.getMismatchMessage(adminCopy, remoteCopy, rId), showProgress, logger, progressReport);
        }

        ParamMismatch(ResourceId rId, String msg, boolean showProgress, Logger logger, StringBuilder progressReport) {
            this.rId = rId;
            this.mismatch = msg;
            VerifyConfiguration.recordProgress(showProgress, logger, progressReport, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.rId;
        }

        public String toString() {
            return "Mismatch between metadata in admin service and " + this.rId + ": " + eol + this.mismatch;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mismatch == null ? 0 : this.mismatch.hashCode());
            result = 31 * result + (this.rId == null ? 0 : this.rId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ParamMismatch)) {
                return false;
            }
            ParamMismatch other = (ParamMismatch)obj;
            if (this.mismatch == null ? other.mismatch != null : !this.mismatch.equals(other.mismatch)) {
                return false;
            }
            return !(this.rId == null ? other.rId != null : !this.rId.equals(other.rId));
        }
    }

    public static class RMIFailed
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ResourceId rId;
        private final String desc;

        RMIFailed(ResourceId rId, RemoteException e, String methodName, boolean showProgress, Logger logger, StringBuilder progressReport) {
            this.rId = rId;
            this.desc = methodName + " failed for " + rId + " : " + e.getMessage();
            VerifyConfiguration.recordProgress(showProgress, logger, progressReport, this);
        }

        RMIFailed(ResourceId rId, NotBoundException e, boolean showProgress, Logger logger, StringBuilder progressReport) {
            this.rId = rId;
            this.desc = "No RMI service for " + rId + ": service name=" + e.getMessage();
            VerifyConfiguration.recordProgress(showProgress, logger, progressReport, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.rId;
        }

        public String toString() {
            return this.desc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.rId == null ? 0 : this.rId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RMIFailed)) {
                return false;
            }
            RMIFailed other = (RMIFailed)obj;
            if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
                return false;
            }
            return !(this.rId == null ? other.rId != null : !this.rId.equals(other.rId));
        }
    }

    public static class StatusNotRight
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ResourceId rId;
        private final ConfigurableService.ServiceStatus expected;
        private final ConfigurableService.ServiceStatus current;

        StatusNotRight(ResourceId rId, ConfigurableService.ServiceStatus expected, ConfigurableService.ServiceStatus current, boolean showProgress, Logger logger, StringBuilder progressReport) {
            this.rId = rId;
            this.expected = expected;
            this.current = current;
            VerifyConfiguration.recordProgress(showProgress, logger, progressReport, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.rId;
        }

        public String toString() {
            return "Expected status " + (Object)((Object)this.expected) + " but was " + (Object)((Object)this.current);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.current == null ? 0 : this.current.hashCode());
            result = 31 * result + (this.expected == null ? 0 : this.expected.hashCode());
            result = 31 * result + (this.rId == null ? 0 : this.rId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StatusNotRight)) {
                return false;
            }
            StatusNotRight other = (StatusNotRight)obj;
            if (this.current != other.current) {
                return false;
            }
            if (this.expected != other.expected) {
                return false;
            }
            return !(this.rId == null ? other.rId != null : !this.rId.equals(other.rId));
        }
    }

    public static class ServiceStopped
    implements Problem,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ResourceId rId;
        private final StorageNodeId snId;
        private final boolean isDisabled;

        ServiceStopped(ResourceId rId, StorageNodeId snId, boolean showProgress, Logger logger, StringBuilder progressReport, boolean isDisabled) {
            this.rId = rId;
            this.snId = snId;
            this.isDisabled = isDisabled;
            VerifyConfiguration.recordProgress(showProgress, logger, progressReport, this);
        }

        @Override
        public ResourceId getResourceId() {
            return this.rId;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.rId + " on " + this.snId);
            if (this.isDisabled) {
                sb.append(" was previously stopped and");
            }
            sb.append(" is not running. Consider restarting it with ");
            sb.append("'plan start-service'.");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.rId == null ? 0 : this.rId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ServiceStopped)) {
                return false;
            }
            ServiceStopped other = (ServiceStopped)obj;
            return !(this.rId == null ? other.rId != null : !this.rId.equals(other.rId));
        }
    }

    public static interface Problem {
        public ResourceId getResourceId();
    }

    private class ExcludeDisableFilter
    extends MapFilter {
        private ExcludeDisableFilter() {
        }

        @Override
        ParameterMap filter(ParameterMap map) {
            HashSet<String> disableName = new HashSet<String>();
            disableName.add("disabled");
            return map.filter(disableName, false);
        }
    }

    private class SNPFilter
    extends MapFilter {
        private SNPFilter() {
        }

        @Override
        ParameterMap filter(ParameterMap map) {
            return map.filter(ParameterState.serviceParams, true);
        }
    }

    private class MapFilter {
        private MapFilter() {
        }

        ParameterMap filter(ParameterMap map) {
            return map.filter(ParameterState.skipParams, false);
        }
    }
}

