/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.sna.StorageNodeStatus;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.VersionUtil;
import oracle.kv.impl.util.registry.RegistryUtils;

public class UpgradeUtil {
    private UpgradeUtil() {
    }

    static String generateUpgradeList(Admin admin, KVVersion targetVersion, KVVersion prerequisiteVersion) {
        StringBuilder sb = new StringBuilder();
        sb.append("Calculating upgrade order, target version: ");
        sb.append(targetVersion.getNumericVersionString());
        sb.append(", prerequisite: ");
        sb.append(prerequisiteVersion.getNumericVersionString());
        Logger logger = admin.getLogger();
        logger.info(sb.toString());
        sb.append("\n");
        Topology topology = admin.getCurrentTopology();
        RegistryUtils registryUtils = new RegistryUtils(topology, admin.getLoginManager());
        HashMap<StorageNodeId, AdminId> needsUpgrade = new HashMap<StorageNodeId, AdminId>();
        for (StorageNodeId snId : topology.getStorageNodeIds()) {
            StorageNodeStatus snStatus = null;
            logger.log(Level.FINE, "Checking {0}", snId);
            try {
                StorageNodeAgentAPI sna = registryUtils.getStorageNodeAgent(snId);
                snStatus = sna.ping();
            }
            catch (RemoteException re) {
                sb.append("Unable to contact ");
                sb.append(snId.toString());
                sb.append(" ");
                sb.append(re.getMessage());
                sb.append("\n");
                continue;
            }
            catch (NotBoundException nbe) {
                sb.append("Unable to contact ");
                sb.append(snId.toString());
                sb.append(" ");
                sb.append(nbe.getMessage());
                sb.append("\n");
                continue;
            }
            KVVersion snVersion = snStatus.getKVVersion();
            if (snVersion.compareTo(targetVersion) >= 0) {
                if (VersionUtil.compareMinorVersion(snVersion, targetVersion) <= 0) continue;
                sb.append("Cannot upgrade ");
                sb.append(snId.toString());
                sb.append(" which is at a newer minor version ");
                sb.append(snVersion.getNumericVersionString());
                sb.append("\n");
                continue;
            }
            if (snVersion.compareTo(prerequisiteVersion) < 0) {
                sb.append("Cannot upgrade ");
                sb.append(snId.toString());
                sb.append(" at version ");
                sb.append(snVersion.getNumericVersionString());
                sb.append(" which does not meet the prerequisite");
                sb.append("\n");
                continue;
            }
            String result = UpgradeUtil.checkRNs(snVersion, topology.getHostedRepNodeIds(snId), registryUtils);
            if (result != null) {
                sb.append(snId);
                sb.append(" needs upgrading, but there is an issue\n");
                sb.append(result);
                sb.append("\n");
                continue;
            }
            needsUpgrade.put(snId, null);
        }
        logger.log(Level.FINE, "{0} SNs need upgrading", needsUpgrade.size());
        if (needsUpgrade.isEmpty()) {
            sb.append("There are no nodes that need to be upgraded");
            return sb.toString();
        }
        Parameters p = admin.getCurrentParameters();
        for (AdminParams ap : p.getAdminParams()) {
            if (!needsUpgrade.containsKey(ap.getStorageNodeId())) continue;
            needsUpgrade.put(ap.getStorageNodeId(), ap.getAdminId());
        }
        while (!needsUpgrade.isEmpty()) {
            Iterator itr = needsUpgrade.entrySet().iterator();
            Map.Entry entry = itr.next();
            StorageNodeId snId = (StorageNodeId)entry.getKey();
            boolean hasAdmin = entry.getValue() != null;
            sb.append(snId.toString());
            itr.remove();
            HashSet<Integer> affectedShards = new HashSet<Integer>();
            for (RepNodeId rnId : topology.getHostedRepNodeIds(snId)) {
                affectedShards.add(rnId.getGroupId());
            }
            logger.log(Level.FINE, "Next upgrade is {0} has admin: {1}", new Object[]{snId, entry.getValue()});
            while (itr.hasNext()) {
                Map.Entry candidate = itr.next();
                StorageNodeId candidateId = (StorageNodeId)candidate.getKey();
                logger.log(Level.FINE, "Candidate is {0} has admin: {1}", new Object[]{candidateId, candidate.getValue()});
                if (hasAdmin && candidate.getValue() != null) continue;
                Set<RepNodeId> hostedRNs = topology.getHostedRepNodeIds(candidateId);
                boolean OK2 = true;
                for (RepNodeId rnId : hostedRNs) {
                    if (!affectedShards.contains(rnId.getGroupId())) continue;
                    OK2 = false;
                    break;
                }
                if (!OK2) continue;
                logger.log(Level.FINE, "Adding {0}", candidateId);
                itr.remove();
                sb.append(" ");
                sb.append(candidateId.toString());
                for (RepNodeId rnId : hostedRNs) {
                    affectedShards.add(rnId.getGroupId());
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String checkRNs(KVVersion snVersion, Set<RepNodeId> hostedRepNodeIds, RegistryUtils registryUtils) {
        for (RepNodeId rnId : hostedRepNodeIds) {
            try {
                RepNodeAdminAPI rn = registryUtils.getRepNodeAdmin(rnId);
                KVVersion rnVersion = rn.getInfo().getSoftwareVersion();
                if (rnVersion.compareTo(snVersion) == 0) continue;
                return "RepNode " + rn.toString() + " at " + rnVersion.getNumericVersionString() + " is not at the same software version as " + "its hosting Storage Node";
            }
            catch (RemoteException re) {
                return "Unable to contact " + rnId.toString() + " " + re.getMessage();
            }
            catch (NotBoundException nbe) {
                return "Unable to contact " + rnId.toString() + " " + nbe.getMessage();
            }
        }
        return null;
    }
}

