/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.utilint.HostPortPair;
import java.net.InetSocketAddress;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.TopologyCheckUtils;
import oracle.kv.impl.admin.VerifyConfiguration;
import oracle.kv.impl.admin.VerifyResults;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.DeploymentInfo;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.PortTracker;
import oracle.kv.impl.admin.plan.task.ChangeServiceAddresses;
import oracle.kv.impl.admin.plan.task.RelocateRN;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.admin.topo.Validations;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterUtils;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;

public class TopologyCheck {
    private static final String CHECK = "TopoCheck:";
    private static final int JE_HA_TIMEOUT_MS = 5000;
    private static Map<RNLocationInput, REMEDY_TYPE> RECOMMENDATIONS;
    private final Map<StorageNodeId, TopologyCheckUtils.SNServices> snRemoteParams;
    private final Map<StorageNodeId, TopologyCheckUtils.SNServices> topoGroupedBySN;
    private final Map<ResourceId, JEHAInfo> jeHAGroupDBInfo;
    private final Logger logger;

    public TopologyCheck(Logger logger, Topology topo, Parameters params) {
        this.logger = logger;
        this.snRemoteParams = new HashMap<StorageNodeId, TopologyCheckUtils.SNServices>();
        this.jeHAGroupDBInfo = new HashMap<ResourceId, JEHAInfo>();
        this.topoGroupedBySN = TopologyCheckUtils.groupServicesBySN(topo, params);
    }

    public void saveSNRemoteParams(StorageNodeId snId, LoadParameters lp) {
        this.snRemoteParams.put(snId, this.processRemoteInfo(snId, lp));
    }

    public Set<RepNodeId> getPossibleRNs(StorageNodeId snId) {
        HashSet<RepNodeId> rnsToCheck = new HashSet<RepNodeId>();
        rnsToCheck.addAll(this.snRemoteParams.get(snId).getAllRNs());
        rnsToCheck.addAll(this.topoGroupedBySN.get(snId).getAllRepNodeIds());
        return rnsToCheck;
    }

    public Remedy checkRNLocation(Admin admin, StorageNodeId snId, RepNodeId rnId, boolean calledByDeployNewRN, boolean makeRNEnabled) throws RemoteException, NotBoundException {
        TOPO_STATUS topoStatus = TOPO_STATUS.GONE;
        TopologyCheckUtils.SNServices servicesOnThisSN = this.topoGroupedBySN.get(snId);
        if (servicesOnThisSN != null && servicesOnThisSN.getAllRepNodeIds().contains(rnId)) {
            topoStatus = TOPO_STATUS.HERE;
        }
        if (this.snRemoteParams.get(snId) == null) {
            Topology current = admin.getCurrentTopology();
            RegistryUtils regUtils = new RegistryUtils(current, admin.getLoginManager());
            StorageNodeAgentAPI sna = regUtils.getStorageNodeAgent(snId);
            LoadParameters remoteParams = sna.getParams();
            this.snRemoteParams.put(snId, this.processRemoteInfo(snId, remoteParams));
        }
        CONFIG_STATUS configStatus = this.snRemoteParams.get(snId).contains(rnId) ? CONFIG_STATUS.HERE : CONFIG_STATUS.GONE;
        JEHAInfo jeHAInfo = this.jeHAGroupDBInfo.get(rnId);
        if (jeHAInfo == null) {
            this.populateRNJEHAGroupDB(admin, new RepGroupId(rnId.getGroupId()));
        }
        jeHAInfo = this.jeHAGroupDBInfo.get(rnId);
        RNLocationInput remedyKey = null;
        if (jeHAInfo == null) {
            if (calledByDeployNewRN) {
                remedyKey = new RNLocationInput(topoStatus, configStatus, OTHERSN_STATUS.GONE);
            } else if (this.readAllSNRemoteParams(admin.getCurrentTopology(), admin.getLoginManager())) {
                boolean foundRN = this.searchOtherSNs(snId, rnId);
                OTHERSN_STATUS otherSNStatus = foundRN ? OTHERSN_STATUS.HERE : OTHERSN_STATUS.GONE;
                remedyKey = new RNLocationInput(topoStatus, configStatus, otherSNStatus);
            } else {
                remedyKey = new RNLocationInput(topoStatus, configStatus);
            }
        } else {
            JEHA_STATUS jeHAStatus = jeHAInfo.getSNId().equals(snId) ? JEHA_STATUS.HERE : JEHA_STATUS.GONE;
            remedyKey = new RNLocationInput(topoStatus, configStatus, jeHAStatus);
        }
        REMEDY_TYPE remedyType = RECOMMENDATIONS.get(remedyKey);
        if (remedyType == null) {
            remedyType = REMEDY_TYPE.NO_FIX;
        }
        if (remedyType.equals((Object)REMEDY_TYPE.OKAY) && makeRNEnabled && topoStatus.equals((Object)TOPO_STATUS.HERE) && admin.getCurrentParameters().get(rnId).isDisabled()) {
            remedyType = REMEDY_TYPE.CREATE_RN;
        }
        return new Remedy(remedyKey, snId, rnId, remedyType, jeHAInfo);
    }

    public Remedy checkAdminMove(Admin admin, AdminId adminId, StorageNodeId oldSN, StorageNodeId newSN) {
        this.populateAdminJEHAGroupDB(admin);
        JEHAInfo jeHAInfo = this.jeHAGroupDBInfo.get(adminId);
        if (jeHAInfo == null) {
            throw new NonfatalAssertionException("Attempting to check location for admin " + adminId + " but could not obtain JE HA group db info");
        }
        Parameters params = admin.getCurrentParameters();
        Topology topo = admin.getCurrentTopology();
        StorageNodeId jeHASNId = jeHAInfo.getSNId();
        StorageNodeId adminParamsSNId = params.get(adminId).getStorageNodeId();
        TopologyCheckUtils.SNServices remoteInfo = this.readOneSNRemoteParams(topo, newSN, admin.getLoginManager());
        boolean remoteNewSNCorrect = false;
        if (remoteInfo != null) {
            AdminId remoteAdminId = remoteInfo.getAdminId();
            remoteNewSNCorrect = remoteAdminId == null || adminId.equals(remoteAdminId);
        }
        AdminLocationInput adminLoc = new AdminLocationInput(jeHASNId, adminParamsSNId, remoteNewSNCorrect);
        if (!jeHASNId.equals(oldSN) && !jeHASNId.equals(newSN) || !adminParamsSNId.equals(oldSN) && !adminParamsSNId.equals(newSN) || !remoteNewSNCorrect) {
            return new Remedy(adminLoc, adminId, REMEDY_TYPE.RUN_REPAIR, jeHAInfo);
        }
        return new Remedy(adminLoc, adminId, REMEDY_TYPE.OKAY, jeHAInfo);
    }

    public Remedy checkAdminLocation(Admin admin, AdminId adminId) {
        this.populateAdminJEHAGroupDB(admin);
        JEHAInfo jeHAInfo = this.jeHAGroupDBInfo.get(adminId);
        if (jeHAInfo == null) {
            throw new NonfatalAssertionException("Attempting to check location for admin " + adminId + " but could not obtain JE HA group db info");
        }
        Parameters params = admin.getCurrentParameters();
        Topology topo = admin.getCurrentTopology();
        StorageNodeId jeHASNId = jeHAInfo.getSNId();
        StorageNodeId adminParamsSNId = params.get(adminId).getStorageNodeId();
        TopologyCheckUtils.SNServices remoteInfo = this.readOneSNRemoteParams(topo, adminParamsSNId, admin.getLoginManager());
        boolean remoteSNCorrect = false;
        if (remoteInfo != null && adminId.equals(remoteInfo.getAdminId())) {
            remoteSNCorrect = true;
        }
        AdminLocationInput adminLoc = new AdminLocationInput(jeHASNId, adminParamsSNId, remoteSNCorrect);
        if (!jeHASNId.equals(adminParamsSNId) || !remoteSNCorrect) {
            return new Remedy(adminLoc, adminId, REMEDY_TYPE.FIX_ADMIN, jeHAInfo);
        }
        return new Remedy(adminLoc, adminId, REMEDY_TYPE.OKAY, jeHAInfo);
    }

    private boolean searchOtherSNs(StorageNodeId snId, RepNodeId rnId) {
        for (Map.Entry<StorageNodeId, TopologyCheckUtils.SNServices> e : this.snRemoteParams.entrySet()) {
            if (e.getKey().equals(snId) || !e.getValue().contains(rnId)) continue;
            return true;
        }
        return false;
    }

    private void populateRNJEHAGroupDB(Admin admin, RepGroupId rgId) {
        Topology topo = admin.getCurrentTopology();
        Parameters params = admin.getCurrentParameters();
        RepGroup rg = topo.get(rgId);
        if (rg == null) {
            return;
        }
        HashSet<InetSocketAddress> helperSockets = new HashSet<InetSocketAddress>();
        HashSet<StorageNodeId> snCheckSet = new HashSet<StorageNodeId>();
        for (RepNode member : rg.getRepNodes()) {
            RepNodeParams rnp = params.get((RepNodeId)member.getResourceId());
            snCheckSet.add(rnp.getStorageNodeId());
            helperSockets.addAll(HostPortPair.getSockets(rnp.getJEHelperHosts()));
            helperSockets.add(HostPortPair.getSocket(rnp.getJENodeHostPort()));
        }
        ReplicationNetworkConfig repNetConfig = admin.getRepNetConfig();
        Set<ReplicationNode> groupDB = TopologyCheckUtils.getJEHAGroupDB(rgId.getGroupName(), 5000, this.logger, helperSockets, repNetConfig);
        StringBuilder helperHosts = new StringBuilder();
        for (ReplicationNode rNode : groupDB) {
            if (helperHosts.length() > 0) {
                helperHosts.append(",");
            }
            helperHosts.append(HostPortPair.getString(rNode.getHostName(), rNode.getPort()));
        }
        for (ReplicationNode rNode : groupDB) {
            StorageNodeId foundSNId = TopologyCheckUtils.translateToSNId(topo, params, snCheckSet, rNode.getHostName(), rNode.getPort());
            if (foundSNId == null) {
                this.logger.severe("TopoCheck: couldn't find SN for " + rNode.getHostName() + ":" + rNode.getPort());
                continue;
            }
            this.jeHAGroupDBInfo.put(RepNodeId.parse(rNode.getName()), new JEHAInfo(foundSNId, rNode, helperHosts.toString()));
        }
    }

    private void populateAdminJEHAGroupDB(Admin admin) {
        Parameters params = admin.getCurrentParameters();
        HashSet<InetSocketAddress> helperSockets = new HashSet<InetSocketAddress>();
        HashSet<StorageNodeId> snCheckSet = new HashSet<StorageNodeId>();
        for (AdminParams ap : params.getAdminParams()) {
            snCheckSet.add(ap.getStorageNodeId());
            helperSockets.addAll(HostPortPair.getSockets(ap.getHelperHosts()));
            helperSockets.add(HostPortPair.getSocket(ap.getNodeHostPort()));
        }
        String kvstoreName = admin.getCurrentParameters().getGlobalParams().getKVStoreName();
        String groupName = Admin.getAdminRepGroupName(kvstoreName);
        ReplicationNetworkConfig repNetConfig = admin.getRepNetConfig();
        Set<ReplicationNode> groupDB = TopologyCheckUtils.getJEHAGroupDB(groupName, 5000, this.logger, helperSockets, repNetConfig);
        StringBuilder helperHosts = new StringBuilder();
        for (ReplicationNode rNode : groupDB) {
            if (helperHosts.length() > 0) {
                helperHosts.append(",");
            }
            helperHosts.append(HostPortPair.getString(rNode.getHostName(), rNode.getPort()));
        }
        Topology topo = admin.getCurrentTopology();
        for (ReplicationNode rNode : groupDB) {
            StorageNodeId foundSNId = TopologyCheckUtils.translateToSNId(topo, params, snCheckSet, rNode.getHostName(), rNode.getPort());
            if (foundSNId == null) {
                this.logger.severe("TopoCheck: couldn't find SN for " + rNode.getHostName() + ":" + rNode.getPort());
                continue;
            }
            this.jeHAGroupDBInfo.put(AdminId.parse(rNode.getName()), new JEHAInfo(foundSNId, rNode, helperHosts.toString()));
        }
    }

    private boolean readAllSNRemoteParams(Topology topo, LoginManager loginManager) {
        List<StorageNodeId> allSNs = topo.getStorageNodeIds();
        for (StorageNodeId snId : allSNs) {
            if (this.readOneSNRemoteParams(topo, snId, loginManager) != null) continue;
            return false;
        }
        return true;
    }

    private TopologyCheckUtils.SNServices readOneSNRemoteParams(Topology topo, StorageNodeId snId, LoginManager loginManager) {
        RegistryUtils regUtils = new RegistryUtils(topo, loginManager);
        TopologyCheckUtils.SNServices remoteInfo = this.snRemoteParams.get(snId);
        if (remoteInfo != null) {
            return remoteInfo;
        }
        try {
            StorageNodeAgentAPI sna = regUtils.getStorageNodeAgent(snId);
            LoadParameters remoteParams = sna.getParams();
            remoteInfo = this.processRemoteInfo(snId, remoteParams);
            this.snRemoteParams.put(snId, remoteInfo);
            this.logger.info("TopoCheck:loaded remote params for " + snId);
            return remoteInfo;
        }
        catch (NotBoundException re) {
            this.logger.info("TopoCheck: failed to reach " + snId + " to load SN params: " + re);
        }
        catch (RemoteException re) {
            this.logger.info("TopoCheck: failed to reach " + snId + " to load SN params: " + re);
        }
        return null;
    }

    private static void initRecommendations() {
        RECOMMENDATIONS = new HashMap<RNLocationInput, REMEDY_TYPE>();
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.HERE, CONFIG_STATUS.HERE, JEHA_STATUS.HERE), REMEDY_TYPE.OKAY);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.HERE, CONFIG_STATUS.HERE, JEHA_STATUS.GONE), REMEDY_TYPE.CLEAR_ADMIN_CONFIG);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.HERE, CONFIG_STATUS.GONE, JEHA_STATUS.HERE), REMEDY_TYPE.CREATE_RN);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.HERE, CONFIG_STATUS.GONE, JEHA_STATUS.GONE), REMEDY_TYPE.REVERT_RN);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.GONE, CONFIG_STATUS.HERE, JEHA_STATUS.HERE), REMEDY_TYPE.REVERT_RN);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.GONE, CONFIG_STATUS.HERE, JEHA_STATUS.GONE), REMEDY_TYPE.REMOVE_RN);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.GONE, CONFIG_STATUS.GONE, JEHA_STATUS.HERE), REMEDY_TYPE.NO_FIX);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.GONE, CONFIG_STATUS.GONE, JEHA_STATUS.GONE), REMEDY_TYPE.OKAY);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.HERE, CONFIG_STATUS.HERE, OTHERSN_STATUS.HERE), REMEDY_TYPE.DISABLE);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.HERE, CONFIG_STATUS.HERE, OTHERSN_STATUS.GONE), REMEDY_TYPE.CREATE_RN);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.HERE, CONFIG_STATUS.GONE, OTHERSN_STATUS.HERE), REMEDY_TYPE.NO_FIX);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.HERE, CONFIG_STATUS.GONE, OTHERSN_STATUS.GONE), REMEDY_TYPE.CLEAR_ADMIN_CONFIG);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.GONE, CONFIG_STATUS.HERE, OTHERSN_STATUS.HERE), REMEDY_TYPE.NO_FIX);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.GONE, CONFIG_STATUS.HERE, OTHERSN_STATUS.GONE), REMEDY_TYPE.NO_FIX);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.GONE, CONFIG_STATUS.GONE, OTHERSN_STATUS.GONE), REMEDY_TYPE.OKAY);
        TopologyCheck.addAction(new RNLocationInput(TOPO_STATUS.GONE, CONFIG_STATUS.GONE, OTHERSN_STATUS.HERE), REMEDY_TYPE.OKAY);
    }

    private static void addAction(RNLocationInput key, REMEDY_TYPE rType) {
        REMEDY_TYPE oldRemedy = RECOMMENDATIONS.put(key, rType);
        if (oldRemedy != null) {
            throw new IllegalStateException("Tried to overwrite remedy " + key + "/" + (Object)((Object)oldRemedy) + " with " + (Object)((Object)rType));
        }
    }

    private <T extends VerifyConfiguration.Problem> Set<T> filterViolations(VerifyResults results, Class<T> problemClass) {
        HashSet<T> found = new HashSet<T>();
        for (VerifyConfiguration.Problem p : results.getViolations()) {
            if (!p.getClass().equals(problemClass)) continue;
            found.add(problemClass.cast(p));
        }
        return found;
    }

    public void applyRemedies(List<Remedy> repairs, AbstractPlan plan) {
        for (Remedy r : repairs) {
            this.applyRemedy(r, plan, plan.getDeployedInfo(), null, null);
        }
    }

    public boolean applyRemedy(Remedy remedy, AbstractPlan plan, DeploymentInfo deploymentInfo, StorageNodeId oldSNId, String newMountPoint) {
        plan.getLogger().info("TopoCheck: applying " + remedy);
        boolean rnWorkDone = false;
        boolean adminWorkDone = false;
        switch (remedy.getType()) {
            case CLEAR_ADMIN_CONFIG: {
                rnWorkDone = this.repairWithClearRN(remedy, plan, deploymentInfo);
                break;
            }
            case CREATE_RN: {
                rnWorkDone = this.repairStartRN(remedy, plan);
                break;
            }
            case REVERT_RN: {
                rnWorkDone = this.repairRevertRN(remedy, plan, deploymentInfo, oldSNId, newMountPoint);
                break;
            }
            case REMOVE_RN: {
                rnWorkDone = this.repairRemoveRN(remedy, plan);
                break;
            }
            case FIX_ADMIN: {
                adminWorkDone = this.repairAdmin(remedy, plan);
                break;
            }
            case OKAY: {
                break;
            }
            default: {
                if (remedy.canFix()) {
                    this.logger.info("TopoCheck: did not act upon " + remedy);
                    throw new UnsupportedOperationException();
                }
                this.logger.info("TopoCheck: required manual intervention for " + remedy + remedy.problemDescription());
            }
        }
        if (rnWorkDone) {
            this.ensureAdminDBAndRNParams(plan, new RepGroupId(remedy.getRNId().getGroupId()));
        }
        return rnWorkDone || adminWorkDone;
    }

    private boolean repairAdmin(Remedy remedy, AbstractPlan plan) {
        PlannerAdmin admin = plan.getAdmin();
        Parameters params = admin.getCurrentParameters();
        Topology topo = admin.getCurrentTopology();
        AdminParams ap = params.get(remedy.getAdminId());
        try {
            ChangeServiceAddresses.changeAdminHAAddress(plan, "repair Admin location for " + remedy.getAdminId(), params, remedy.getAdminId());
            LoginManager loginMgr = admin.getLoginManager();
            RegistryUtils regUtils = new RegistryUtils(topo, loginMgr);
            StorageNodeAgentAPI sna = regUtils.getStorageNodeAgent(ap.getStorageNodeId());
            sna.createAdmin(ap.getMap());
            return true;
        }
        catch (OperationFaultException e) {
            plan.getLogger().info("Repair of Admin saw " + e);
            return false;
        }
        catch (RemoteException e) {
            plan.getLogger().info("Repair of Admin saw " + e);
            return false;
        }
        catch (NotBoundException e) {
            plan.getLogger().info("Repair of Admin saw " + e);
            return false;
        }
    }

    private boolean repairWithClearRN(Remedy remedy, AbstractPlan plan, DeploymentInfo deploymentInfo) {
        PlannerAdmin admin = plan.getAdmin();
        StorageNodeId snId = remedy.getSNId();
        RepNodeId rnId = remedy.getRNId();
        Topology topo = admin.getCurrentTopology();
        if (remedy.getRNLocationInput().presentInSNConfig) {
            this.logger.info("TopoCheck: trying to remove " + rnId + " from " + snId + " config");
            RegistryUtils regUtils = new RegistryUtils(topo, admin.getLoginManager());
            try {
                StorageNodeAgentAPI sna = regUtils.getStorageNodeAgent(snId);
                sna.destroyRepNode(rnId, true);
            }
            catch (NotBoundException re) {
                this.logger.info("TopoCheck: couldn't reach " + snId + " to remove " + rnId + " " + re);
                return false;
            }
            catch (RemoteException re) {
                this.logger.info("TopoCheck: couldn't reach " + snId + " to remove " + rnId + " " + re);
                return false;
            }
        }
        if (remedy.getRNLocationInput().presentInTopo) {
            topo.remove(rnId);
            admin.saveTopoAndRemoveRN(topo, deploymentInfo, rnId, plan);
            this.logger.info("TopoCheck: trying to remove " + rnId + " from topo and params");
        }
        return true;
    }

    private boolean repairRevertRN(Remedy remedy, AbstractPlan plan, DeploymentInfo deploymentInfo, StorageNodeId oldSNId, String newMountPoint) {
        PlannerAdmin admin = plan.getAdmin();
        RepNodeId rnId = remedy.getRNId();
        StorageNodeId correctSNId = null;
        String correctJEHAHostPort = null;
        String correctHelpers = null;
        JEHAInfo jeHAInfo = remedy.getJEHAInfo();
        Topology topo = admin.getCurrentTopology();
        Parameters params = admin.getCurrentParameters();
        if (jeHAInfo != null) {
            correctSNId = jeHAInfo.getSNId();
            correctHelpers = jeHAInfo.getHelpers();
            correctJEHAHostPort = jeHAInfo.getHostPort();
        } else if (oldSNId != null) {
            correctSNId = oldSNId;
            PortTracker portTracker = new PortTracker(topo, params, oldSNId);
            int haPort = portTracker.getNextPort(oldSNId);
            String haHostname = params.get(oldSNId).getHAHostname();
            correctJEHAHostPort = HostPortPair.getString(haHostname, haPort);
            correctHelpers = TopologyCheckUtils.findPeerRNHelpers(rnId, params, topo);
            correctHelpers = correctHelpers + "," + correctJEHAHostPort;
        }
        if (correctSNId == null) {
            this.logger.info("TopoCheck: could not find correct owning SN " + remedy);
            return false;
        }
        RepNode rn = topo.get(rnId);
        boolean topoUpdated = false;
        if (!rn.getStorageNodeId().equals(correctSNId)) {
            this.logger.info("TopoCheck: updating topology so " + correctSNId + " owns " + rnId);
            RepNode updatedRN = new RepNode(correctSNId);
            RepGroup rg = topo.get(rn.getRepGroupId());
            rg.update((RepNodeId)rn.getResourceId(), updatedRN);
            topoUpdated = true;
        }
        Set<RepNodeParams> needsUpdate = this.correctRNParams(topo, params, rnId, correctSNId, correctJEHAHostPort, correctHelpers, newMountPoint, correctSNId.equals(remedy.getSNId()), admin.getLoginManager());
        boolean peersNeedUpdate = false;
        boolean rnNeedsUpdate = false;
        for (RepNodeParams updatedRNP : needsUpdate) {
            if (updatedRNP.getRepNodeId().equals(rnId)) {
                rnNeedsUpdate = true;
                continue;
            }
            peersNeedUpdate = true;
        }
        if (topoUpdated) {
            admin.saveTopoAndParams(topo, deploymentInfo, needsUpdate, Collections.emptySet(), (Plan)plan);
            try {
                Utils.broadcastTopoChangesToRNs(this.logger, admin.getCurrentTopology(), "TopoCheck: updating topo", admin.getParams().getAdminParams(), plan);
            }
            catch (InterruptedException e) {
                this.logger.info("TopoCheck: couldn't update topo: " + e);
                return false;
            }
        } else if (!needsUpdate.isEmpty()) {
            plan.getAdmin().saveParams(needsUpdate, Collections.emptySet());
        }
        if (rnNeedsUpdate) {
            try {
                RelocateRN.startRN(plan, correctSNId, rnId);
            }
            catch (RemoteException e) {
                this.logger.info("TopoCheck: couldn't start " + rnId);
            }
            catch (NotBoundException e) {
                this.logger.info("TopoCheck: couldn't start " + rnId);
            }
        }
        if (peersNeedUpdate) {
            try {
                Utils.refreshParamsOnPeers(plan, rnId);
            }
            catch (RemoteException e) {
                this.logger.info(this + " couldn't update helper hosts at peers");
                return false;
            }
            catch (NotBoundException e) {
                this.logger.info(this + " couldn't update helper hosts at peers");
                return false;
            }
        }
        return true;
    }

    private boolean repairStartRN(Remedy remedy, AbstractPlan plan) {
        try {
            RelocateRN.startRN(plan, remedy.getSNId(), remedy.getRNId());
        }
        catch (RemoteException e) {
            return false;
        }
        catch (NotBoundException e) {
            return false;
        }
        return true;
    }

    private boolean repairRemoveRN(Remedy remedy, AbstractPlan plan) {
        try {
            return RelocateRN.destroyRepNode(plan, System.currentTimeMillis(), remedy.getSNId(), remedy.getRNId());
        }
        catch (InterruptedException e) {
            this.logger.info("TopoCheck: couldn't remove " + remedy.getRNId() + " from " + remedy.getSNId() + " because of " + e);
            return false;
        }
    }

    private Set<RepNodeParams> correctRNParams(Topology topo, Parameters params, RepNodeId rnId, StorageNodeId correctSNId, String correctJEHAHostPort, String correctHelpers, String newMountPoint, boolean correctSNIsNewSN, LoginManager loginManager) {
        RepNodeParams rnp = params.get(rnId);
        RepNodeParams fixedRNP = new RepNodeParams(rnp);
        boolean paramsChanged = false;
        HashSet<RepNodeParams> needUpdate = new HashSet<RepNodeParams>();
        if (!rnp.getStorageNodeId().equals(correctSNId)) {
            fixedRNP.setStorageNodeId(correctSNId);
            Utils.setRNPHeapCacheGC(params.copyPolicies(), params.get(correctSNId), fixedRNP, topo);
            if (correctSNIsNewSN) {
                fixedRNP.setMountPoint(newMountPoint);
            } else {
                TopologyCheckUtils.SNServices remoteInfo = this.readOneSNRemoteParams(topo, correctSNId, loginManager);
                LoadParameters lp = remoteInfo.remoteParams;
                ParameterMap rMap = lp.getMap(rnId.getFullName(), "repNodeParams");
                RepNodeParams remoteRNP = new RepNodeParams(rMap);
                fixedRNP.setMountPoint(remoteRNP.getMountPointString());
            }
            paramsChanged = true;
            this.logger.info("TopoCheck: repair of repNodeParams for " + correctSNId + "/" + rnId + " set storagedir " + fixedRNP.getMountPointString());
        }
        if (!rnp.getJENodeHostPort().equals(correctJEHAHostPort)) {
            fixedRNP.setJENodeHostPort(correctJEHAHostPort);
            paramsChanged = true;
        }
        if (this.helperMismatch(rnp.getJEHelperHosts(), correctHelpers)) {
            fixedRNP.setJEHelperHosts(correctHelpers);
            paramsChanged = true;
        }
        if (rnp.isDisabled()) {
            fixedRNP.setDisabled(false);
            paramsChanged = true;
        }
        RepNode rn = topo.get(rnId);
        for (RepNode peer : topo.get(rn.getRepGroupId()).getRepNodes()) {
            RepNodeParams peerRNP;
            if (((RepNodeId)peer.getResourceId()).equals(rnId) || !this.helperMismatch((peerRNP = params.get((RepNodeId)peer.getResourceId())).getJEHelperHosts(), correctHelpers)) continue;
            RepNodeParams newRNP = new RepNodeParams(peerRNP);
            newRNP.setJEHelperHosts(correctHelpers);
            needUpdate.add(newRNP);
        }
        if (paramsChanged) {
            needUpdate.add(fixedRNP);
        }
        return needUpdate;
    }

    private boolean helperMismatch(String helperListA, String helperListB) {
        List<String> helpersB;
        List<String> helpersA = ParameterUtils.helpersAsList(helperListA);
        if (!helpersA.containsAll(helpersB = ParameterUtils.helpersAsList(helperListB))) {
            return true;
        }
        return !helpersB.containsAll(helpersA);
    }

    private void ensureAdminDBAndRNParams(AbstractPlan plan, RepGroupId rgId) {
        PlannerAdmin admin = plan.getAdmin();
        Topology topo = admin.getCurrentTopology();
        RegistryUtils regUtils = new RegistryUtils(topo, admin.getLoginManager());
        Parameters currentParams = admin.getCurrentParameters();
        for (RepNode rn : topo.get(rgId).getRepNodes()) {
            RepNodeId rnId = (RepNodeId)rn.getResourceId();
            StorageNodeId snId = rn.getStorageNodeId();
            RepNodeParams rnp = currentParams.get(rnId);
            try {
                RepNodeAdminAPI rna = regUtils.getRepNodeAdmin(rnId);
                LoadParameters remoteParams = rna.getParams();
                if (remoteParams == null) {
                    this.logger.info("TopoCheck: admin/rn param check for " + plan + " did not find remote params for " + rnId);
                    continue;
                }
                ParameterMap remoteCopy = remoteParams.getMapByType("repNodeParams");
                if (remoteCopy.equals(rnp.getMap())) continue;
                StorageNodeAgentAPI sna = regUtils.getStorageNodeAgent(snId);
                sna.newRepNodeParameters(rnp.getMap());
                RepNodeAdminAPI rnAdmin = regUtils.getRepNodeAdmin(rnId);
                rnAdmin.newParameters();
            }
            catch (RemoteException ignore) {
                this.logger.info("TopoCheck: failed to reach " + snId + "/" + rnId + " to ensure admin/rn params");
            }
            catch (NotBoundException ignore) {
                this.logger.info("TopoCheck: failed to reach " + snId + "/" + rnId + " to ensure admin/rn params");
            }
        }
    }

    public void repairInitialEmptyShards(VerifyResults results, AbstractPlan plan, DeploymentInfo deploymentInfo) {
        Set<Validations.InsufficientRNs> insufficientRNs = this.filterViolations(results, Validations.InsufficientRNs.class);
        this.logger.log(Level.FINE, "{0} : RemoveInitialEmptyShards: insufficientRNs = {1}", new Object[]{CHECK, insufficientRNs});
        if (insufficientRNs.isEmpty()) {
            return;
        }
        Topology currentTopo = plan.getAdmin().getCurrentTopology();
        if (!currentTopo.getRepNodeIds().isEmpty()) {
            this.logger.log(Level.FINE, "{0} : RemoveInitialEmptyShards: {1} RNs exist, try another repair approach", new Object[]{CHECK, insufficientRNs});
            return;
        }
        Set<RepGroupId> shardIds = currentTopo.getRepGroupIds();
        boolean shardsRemoved = false;
        for (RepGroupId rgId : shardIds) {
            currentTopo.remove(rgId);
            shardsRemoved = true;
        }
        if (shardsRemoved) {
            this.logger.info("TopoCheck: for " + plan + " removed empty shards " + shardIds);
            plan.getAdmin().saveTopo(currentTopo, deploymentInfo, plan);
        }
    }

    private TopologyCheckUtils.SNServices processRemoteInfo(StorageNodeId snId, LoadParameters remoteParams) {
        List<ParameterMap> rnMaps = remoteParams.getAllMaps("repNodeParams");
        HashSet<RepNodeId> allRNs = new HashSet<RepNodeId>();
        for (ParameterMap map : rnMaps) {
            RepNodeId rnId = RepNodeId.parse(map.getName());
            allRNs.add(rnId);
        }
        ParameterMap adminMap = remoteParams.getMapByType("adminParams");
        AdminId aid = null;
        if (adminMap != null) {
            aid = new AdminId(adminMap.getOrZeroInt("adminId"));
        }
        return new TopologyCheckUtils.SNServices(snId, allRNs, aid, remoteParams);
    }

    static {
        TopologyCheck.initRecommendations();
    }

    public static class JEHAInfo {
        private final StorageNodeId translatedSNId;
        private final ReplicationNode jeReplicationNode;
        private final String groupWideHelperHosts;

        JEHAInfo(StorageNodeId translatedSNId, ReplicationNode jeReplicationNode, String groupWideHelperHosts) {
            this.translatedSNId = translatedSNId;
            this.jeReplicationNode = jeReplicationNode;
            this.groupWideHelperHosts = groupWideHelperHosts;
        }

        public StorageNodeId getSNId() {
            return this.translatedSNId;
        }

        String getHostPort() {
            return HostPortPair.getString(this.jeReplicationNode.getHostName(), this.jeReplicationNode.getPort());
        }

        String getHelpers() {
            return this.groupWideHelperHosts;
        }

        public String toString() {
            return "JE derivedSN = " + this.translatedSNId + " RepNode=" + this.jeReplicationNode + " helpers=" + this.groupWideHelperHosts;
        }
    }

    public static class Remedy {
        private final REMEDY_TYPE remedyType;
        private final JEHAInfo jeHAInfo;
        private final StorageNodeId snId;
        private final RepNodeId rnId;
        private final RNLocationInput rNLocationInput;
        private final AdminLocationInput adminLocationInput;
        private final AdminId adminId;

        public Remedy(RNLocationInput rNLocationInput, StorageNodeId snId, RepNodeId rnId, REMEDY_TYPE remedyType, JEHAInfo jeHAInfo) {
            this.rNLocationInput = rNLocationInput;
            this.snId = snId;
            this.rnId = rnId;
            this.remedyType = remedyType;
            this.jeHAInfo = jeHAInfo;
            this.adminLocationInput = null;
            this.adminId = null;
        }

        AdminId getAdminId() {
            return this.adminId;
        }

        public Remedy(AdminLocationInput adminLoc, AdminId adminId, REMEDY_TYPE remedyType, JEHAInfo jeHAInfo) {
            this.rNLocationInput = null;
            this.snId = null;
            this.rnId = null;
            this.remedyType = remedyType;
            this.jeHAInfo = jeHAInfo;
            this.adminLocationInput = adminLoc;
            this.adminId = adminId;
        }

        public JEHAInfo getJEHAInfo() {
            return this.jeHAInfo;
        }

        public String problemDescription() {
            return this.remedyType.problemDescription(this.rnId, this.snId, this.rNLocationInput);
        }

        public REMEDY_TYPE getType() {
            return this.remedyType;
        }

        public boolean canFix() {
            return this.remedyType.canFix();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Remedy [");
            builder.append("remedyType=").append((Object)this.remedyType).append(", ");
            if (this.jeHAInfo != null) {
                builder.append("jeHAInfo=").append(this.jeHAInfo).append(", ");
            }
            if (this.snId != null) {
                builder.append("snId=").append(this.snId).append(", ");
            }
            if (this.rnId != null) {
                builder.append("rnId=").append(this.rnId).append(", ");
            }
            if (this.rNLocationInput != null) {
                builder.append("rNLocationInput=").append(this.rNLocationInput).append(", ");
            }
            if (this.adminLocationInput != null) {
                builder.append("adminLocationInput=").append(this.adminLocationInput).append(", ");
            }
            if (this.adminId != null) {
                builder.append("adminId=").append(this.adminId);
            }
            builder.append("]");
            return builder.toString();
        }

        public StorageNodeId getSNId() {
            return this.snId;
        }

        public RepNodeId getRNId() {
            return this.rnId;
        }

        public RNLocationInput getRNLocationInput() {
            return this.rNLocationInput;
        }

        public AdminLocationInput getAdminLocationInput() {
            return this.adminLocationInput;
        }
    }

    public static enum REMEDY_TYPE {
        CLEAR_ADMIN_CONFIG(true),
        CREATE_RN(true),
        DISABLE(false),
        OKAY(false),
        NO_FIX(false),
        REMOVE_RN(true),
        REVERT_RN(true),
        RUN_REPAIR(false),
        FIX_ADMIN(true);

        private final boolean canFix;

        private REMEDY_TYPE(boolean canFix) {
            this.canFix = canFix;
        }

        public String problemDescription(RepNodeId rnId, StorageNodeId snId, RNLocationInput rnLocationInput) {
            switch (this) {
                case CLEAR_ADMIN_CONFIG: {
                    return rnId + " is present in Admin metadata and on " + snId + " configuration but has not been created. Must " + "be removed from metadata";
                }
                case CREATE_RN: {
                    return "Must create or start " + rnId + " on this SN.";
                }
                case DISABLE: {
                    return rnId + " should be stopped and disabled on " + snId;
                }
                case RUN_REPAIR: {
                    return "Please run plan repair-topology to fix inconsistent location metadata";
                }
                case NO_FIX: {
                    return "No automatic fix available for problem with " + rnId;
                }
                case OKAY: {
                    return "No problem with " + rnId;
                }
                case REMOVE_RN: {
                    return rnId + " must be removed from " + snId;
                }
                case REVERT_RN: {
                    return rnId + " must be moved back to its original hosting SN";
                }
                case FIX_ADMIN: {
                    return "Ensure that the Admin's location metadata is consistent";
                }
            }
            return "Metadata issue with " + rnId + "/" + snId + ": " + rnLocationInput;
        }

        public boolean canFix() {
            return this.canFix;
        }
    }

    public static class RNLocationInput {
        private final boolean presentInTopo;
        private final boolean presentInSNConfig;
        private final boolean jeHAKnown;
        private final boolean presentInJEHA;
        private final boolean otherSNKnown;
        private final boolean presentInOtherSNConfig;

        RNLocationInput(TOPO_STATUS topoStatus, CONFIG_STATUS configStatus) {
            this(topoStatus, configStatus, false, JEHA_STATUS.GONE, false, OTHERSN_STATUS.GONE);
        }

        RNLocationInput(TOPO_STATUS topoStatus, CONFIG_STATUS configStatus, JEHA_STATUS jeHAStatus) {
            this(topoStatus, configStatus, true, jeHAStatus, false, OTHERSN_STATUS.GONE);
        }

        RNLocationInput(TOPO_STATUS topoStatus, CONFIG_STATUS configStatus, OTHERSN_STATUS otherSNStatus) {
            this(topoStatus, configStatus, false, JEHA_STATUS.GONE, true, otherSNStatus);
        }

        RNLocationInput(TOPO_STATUS topoStatus, CONFIG_STATUS configStatus, boolean jeHAKnown, JEHA_STATUS jeHAStatus, boolean otherSNKnown, OTHERSN_STATUS otherConfigStatus) {
            this.presentInTopo = topoStatus.equals((Object)TOPO_STATUS.HERE);
            this.presentInSNConfig = configStatus.equals((Object)CONFIG_STATUS.HERE);
            this.jeHAKnown = jeHAKnown;
            this.presentInJEHA = jeHAStatus.equals((Object)JEHA_STATUS.HERE);
            this.otherSNKnown = otherSNKnown;
            this.presentInOtherSNConfig = otherConfigStatus.equals((Object)OTHERSN_STATUS.HERE);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.jeHAKnown ? 1231 : 1237);
            result = 31 * result + (this.otherSNKnown ? 1231 : 1237);
            result = 31 * result + (this.presentInJEHA ? 1231 : 1237);
            result = 31 * result + (this.presentInOtherSNConfig ? 1231 : 1237);
            result = 31 * result + (this.presentInSNConfig ? 1231 : 1237);
            result = 31 * result + (this.presentInTopo ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RNLocationInput)) {
                return false;
            }
            RNLocationInput other = (RNLocationInput)obj;
            if (this.jeHAKnown != other.jeHAKnown) {
                return false;
            }
            if (this.otherSNKnown != other.otherSNKnown) {
                return false;
            }
            if (this.presentInJEHA != other.presentInJEHA) {
                return false;
            }
            if (this.presentInOtherSNConfig != other.presentInOtherSNConfig) {
                return false;
            }
            if (this.presentInSNConfig != other.presentInSNConfig) {
                return false;
            }
            return this.presentInTopo == other.presentInTopo;
        }

        public String toString() {
            return "LocationInput [presentInTopo=" + this.presentInTopo + ", presentInSNConfig=" + this.presentInSNConfig + ", jeHAKnown=" + this.jeHAKnown + ", presentInJEHA=" + this.presentInJEHA + ", otherSNKnown=" + this.otherSNKnown + ", presentInOtherSNConfig=" + this.presentInOtherSNConfig + "]";
        }
    }

    static enum OTHERSN_STATUS {
        HERE,
        GONE;

    }

    static enum JEHA_STATUS {
        HERE,
        GONE;

    }

    static enum CONFIG_STATUS {
        HERE,
        GONE;

    }

    static enum TOPO_STATUS {
        HERE,
        GONE;

    }

    public static class AdminLocationInput {
        private final StorageNodeId jeHASNId;
        private final StorageNodeId adminParamsSNId;
        private final Boolean remoteNewSNCorrect;

        public AdminLocationInput(StorageNodeId jEHASNId, StorageNodeId adminParamsSNId, Boolean remoteNewSNCorrect) {
            this.jeHASNId = jEHASNId;
            this.adminParamsSNId = adminParamsSNId;
            this.remoteNewSNCorrect = remoteNewSNCorrect;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.adminParamsSNId == null ? 0 : this.adminParamsSNId.hashCode());
            result = 31 * result + (this.jeHASNId == null ? 0 : this.jeHASNId.hashCode());
            result = 31 * result + (this.remoteNewSNCorrect == null ? 0 : this.remoteNewSNCorrect.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AdminLocationInput)) {
                return false;
            }
            AdminLocationInput other = (AdminLocationInput)obj;
            if (this.adminParamsSNId == null ? other.adminParamsSNId != null : !this.adminParamsSNId.equals(other.adminParamsSNId)) {
                return false;
            }
            if (this.jeHASNId == null ? other.jeHASNId != null : !this.jeHASNId.equals(other.jeHASNId)) {
                return false;
            }
            return !(this.remoteNewSNCorrect == null ? other.remoteNewSNCorrect != null : !this.remoteNewSNCorrect.equals(other.remoteNewSNCorrect));
        }

        public String toString() {
            return "AdminLocationInput [jeHASNId=" + this.jeHASNId + ", adminParamsSNId=" + this.adminParamsSNId + ", remoteJEHASNCorrect=" + this.remoteNewSNCorrect + "]";
        }
    }
}

