/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.ExecutionListener;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.TaskRun;
import oracle.kv.impl.admin.plan.task.Task;

public class PlanWaiter
implements ExecutionListener {
    private final CountDownLatch done = new CountDownLatch(1);

    public boolean waitForPlanEnd() throws InterruptedException {
        return this.waitForPlanEnd(0, null);
    }

    public boolean waitForPlanEnd(int timeout, TimeUnit timeoutUnit) throws InterruptedException {
        if (timeout == 0) {
            this.done.await();
            return true;
        }
        return this.done.await(timeout, timeoutUnit);
    }

    @Override
    public void planStart(Plan plan) {
    }

    @Override
    public void planEnd(Plan plan) {
        this.done.countDown();
        Logger useLogger = ((AbstractPlan)plan).getLogger();
        if (useLogger != null) {
            useLogger.log(Level.FINE, "PlanWaiter.planEnd called for {0}, state={1}", new Object[]{plan, plan.getState()});
        }
    }

    @Override
    public void taskStart(Plan plan, Task task, int taskNum, int totalTasks) {
    }

    @Override
    public void taskEnd(Plan plan, Task task, TaskRun taskRun, int taskNum, int totalTasks) {
    }
}

