/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminLoginHandler;
import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.login.LoginUpdater;
import oracle.kv.impl.security.login.UserLogin;
import oracle.kv.impl.security.login.UserLoginHandler;
import oracle.kv.impl.security.login.UserLoginImpl;
import oracle.kv.impl.topo.AdminId;

public class LoginService
implements LoginUpdater.GlobalParamsUpdater,
LoginUpdater.ServiceParamsUpdater {
    private final AdminService aservice;
    private final UserLogin userLogin;
    private final AdminLoginHandler loginHandler;

    public LoginService(AdminService aservice) {
        this.aservice = aservice;
        this.loginHandler = AdminLoginHandler.create(aservice);
        this.userLogin = new UserLoginImpl(aservice.getFaultHandler(), this.loginHandler, aservice.getLogger());
    }

    public UserLogin getUserLogin() {
        return this.userLogin;
    }

    @Override
    public void newServiceParameters(ParameterMap map) {
        if (this.loginHandler == null) {
            return;
        }
        Logger logger = this.aservice.getLogger();
        int newLimit = map.getOrDefault("sessionLimit").asInt();
        if (this.loginHandler.updateSessionLimit(newLimit)) {
            logger.info("SessionLimit for AdminLoginHandler has been updated with " + newLimit);
        }
        AdminId adminId = new AdminParams(map).getAdminId();
        if (!this.loginHandler.getOwnerId().equals(adminId)) {
            this.loginHandler.updateOwner(adminId);
            logger.info("Owner of login handler has been updated with " + adminId);
        }
    }

    @Override
    public void newGlobalParameters(ParameterMap map) {
        if (this.loginHandler == null) {
            return;
        }
        GlobalParams gp = new GlobalParams(map);
        UserLoginHandler.LoginConfig config = UserLoginHandler.LoginConfig.buildLoginConfig(gp);
        this.loginHandler.updateConfig(config);
        Logger logger = this.aservice.getLogger();
        logger.info("Config for AdminLoginHandler has been updated with GlobalParams:" + gp.getMap());
    }
}

