/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogRecord;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.CommandService;
import oracle.kv.impl.admin.VerifyResults;
import oracle.kv.impl.admin.criticalevent.CriticalEvent;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.plan.Plan;
import oracle.kv.impl.admin.plan.PlanStateChange;
import oracle.kv.impl.admin.topo.TopologyCandidate;
import oracle.kv.impl.api.avro.AvroDdl;
import oracle.kv.impl.api.avro.AvroSchemaMetadata;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.mgmt.AdminStatusReceiver;
import oracle.kv.impl.monitor.Tracker;
import oracle.kv.impl.monitor.TrackerListener;
import oracle.kv.impl.monitor.views.PerfEvent;
import oracle.kv.impl.monitor.views.ServiceChange;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ContextProxy;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.registry.RemoteAPI;

public final class CommandServiceAPI
extends RemoteAPI {
    private static final short DATACENTER_TYPE_INITIAL_SERIAL_VERSION = 4;
    private static final AuthContext NULL_CTX = null;
    private final CommandService proxyRemote;
    private static final short UPGRADE_INITIAL_SERIAL_VERSION = 3;
    private static final short AVRO_INITIAL_SERIAL_VERSION = 2;

    private CommandServiceAPI(CommandService remote, LoginHandle loginHdl) throws RemoteException {
        super(remote);
        this.proxyRemote = ContextProxy.create(remote, loginHdl, this.getSerialVersion());
        if (this.getSerialVersion() < 2) {
            throw new AdminFaultException(new UnsupportedOperationException("The Admin service is incompatible with this client. Please upgrade the service, or use an older version of the client. (Internal local minimum version=2, internal service version=" + this.getSerialVersion() + ")"));
        }
    }

    public static CommandServiceAPI wrap(CommandService remote, LoginHandle loginHdl) throws RemoteException {
        return new CommandServiceAPI(remote, loginHdl);
    }

    private void checkMethodSupported(short expectVersion) throws UnsupportedOperationException {
        if (this.getSerialVersion() < expectVersion) {
            throw new AdminFaultException(new UnsupportedOperationException("Command not available because service has not yet been upgraded.  (Internal local version=" + expectVersion + ", internal service version=" + this.getSerialVersion() + ")"));
        }
    }

    public ConfigurableService.ServiceStatus ping() throws RemoteException {
        return this.proxyRemote.ping(NULL_CTX, this.getSerialVersion());
    }

    public List<String> getStorageNodePoolNames() throws RemoteException {
        return this.proxyRemote.getStorageNodePoolNames(NULL_CTX, this.getSerialVersion());
    }

    public void addStorageNodePool(String name) throws RemoteException {
        this.proxyRemote.addStorageNodePool(name, NULL_CTX, this.getSerialVersion());
    }

    public void removeStorageNodePool(String name) throws RemoteException {
        this.proxyRemote.removeStorageNodePool(name, NULL_CTX, this.getSerialVersion());
    }

    public List<StorageNodeId> getStorageNodePoolIds(String name) throws RemoteException {
        return this.proxyRemote.getStorageNodePoolIds(name, NULL_CTX, this.getSerialVersion());
    }

    public void addStorageNodeToPool(String name, StorageNodeId snId) throws RemoteException {
        this.proxyRemote.addStorageNodeToPool(name, snId, NULL_CTX, this.getSerialVersion());
    }

    public void replaceStorageNodePool(String name, List<StorageNodeId> ids) throws RemoteException {
        this.proxyRemote.replaceStorageNodePool(name, ids, NULL_CTX, this.getSerialVersion());
    }

    public String createTopology(String candidateName, String snPoolName, int numPartitions) throws RemoteException {
        return this.proxyRemote.createTopology(candidateName, snPoolName, numPartitions, NULL_CTX, this.getSerialVersion());
    }

    public String copyCurrentTopology(String candidateName) throws RemoteException {
        return this.proxyRemote.copyCurrentTopology(candidateName, NULL_CTX, this.getSerialVersion());
    }

    public String copyTopology(String candidateName, String sourceCandidate) throws RemoteException {
        return this.proxyRemote.copyTopology(candidateName, sourceCandidate, NULL_CTX, this.getSerialVersion());
    }

    public List<String> listTopologies() throws RemoteException {
        return this.proxyRemote.listTopologies(NULL_CTX, this.getSerialVersion());
    }

    public String deleteTopology(String candidateName) throws RemoteException {
        return this.proxyRemote.deleteTopology(candidateName, NULL_CTX, this.getSerialVersion());
    }

    public String rebalanceTopology(String candidateName, String snPoolName, DatacenterId dcId) throws RemoteException {
        return this.proxyRemote.rebalanceTopology(candidateName, snPoolName, dcId, NULL_CTX, this.getSerialVersion());
    }

    public String changeRepFactor(String candidateName, String snPoolName, DatacenterId dcId, int repFactor) throws RemoteException {
        return this.proxyRemote.changeRepFactor(candidateName, snPoolName, dcId, repFactor, NULL_CTX, this.getSerialVersion());
    }

    public String redistributeTopology(String candidateName, String snPoolName) throws RemoteException {
        return this.proxyRemote.redistributeTopology(candidateName, snPoolName, NULL_CTX, this.getSerialVersion());
    }

    public String preview(String targetTopoName, String startTopoName, boolean verbose) throws RemoteException {
        return this.proxyRemote.preview(targetTopoName, startTopoName, verbose, NULL_CTX, this.getSerialVersion());
    }

    public List<ParameterMap> getAdmins() throws RemoteException {
        return this.proxyRemote.getAdmins(NULL_CTX, this.getSerialVersion());
    }

    public Plan getPlanById(int planId) throws RemoteException {
        return this.proxyRemote.getPlanById(planId, NULL_CTX, this.getSerialVersion());
    }

    @Deprecated
    public Map<Integer, Plan> getPlans() throws RemoteException {
        return this.proxyRemote.getPlans(NULL_CTX, this.getSerialVersion());
    }

    public void approvePlan(int planId) throws RemoteException {
        this.proxyRemote.approvePlan(planId, NULL_CTX, this.getSerialVersion());
    }

    public void executePlan(int planId, boolean force) throws RemoteException {
        this.proxyRemote.executePlan(planId, force, NULL_CTX, this.getSerialVersion());
    }

    public Plan.State awaitPlan(int planId, int timeout, TimeUnit timeUnit) throws RemoteException {
        return this.proxyRemote.awaitPlan(planId, timeout, timeUnit, NULL_CTX, this.getSerialVersion());
    }

    public void assertSuccess(int planId) throws RemoteException {
        this.proxyRemote.assertSuccess(planId, NULL_CTX, this.getSerialVersion());
    }

    public void cancelPlan(int planId) throws RemoteException {
        this.proxyRemote.cancelPlan(planId, NULL_CTX, this.getSerialVersion());
    }

    public void interruptPlan(int planId) throws RemoteException {
        this.proxyRemote.interruptPlan(planId, NULL_CTX, this.getSerialVersion());
    }

    @Deprecated
    public void retryPlan(int planId) throws RemoteException {
        this.proxyRemote.retryPlan(planId, NULL_CTX, this.getSerialVersion());
    }

    public void createAndExecuteConfigurationPlan(String kvsName, String dcName, int repFactor) throws RemoteException {
        this.proxyRemote.createAndExecuteConfigurationPlan(kvsName, dcName, repFactor, NULL_CTX, this.getSerialVersion());
    }

    public int createDeployDatacenterPlan(String planName, String datacenterName, int repFactor, DatacenterType datacenterType) throws RemoteException {
        if (!datacenterType.isPrimary()) {
            this.checkMethodSupported((short)4);
        }
        if (this.getSerialVersion() < 4) {
            return this.proxyRemote.createDeployDatacenterPlan(planName, datacenterName, repFactor, (String)null, NULL_CTX, this.getSerialVersion());
        }
        return this.proxyRemote.createDeployDatacenterPlan(planName, datacenterName, repFactor, datacenterType, NULL_CTX, this.getSerialVersion());
    }

    public int createDeploySNPlan(String planName, DatacenterId datacenterId, String hostName, int registryPort, String comment) throws RemoteException {
        return this.proxyRemote.createDeploySNPlan(planName, datacenterId, hostName, registryPort, comment, NULL_CTX, this.getSerialVersion());
    }

    public int createDeployAdminPlan(String planName, StorageNodeId snid, int httpPort) throws RemoteException {
        return this.proxyRemote.createDeployAdminPlan(planName, snid, httpPort, NULL_CTX, this.getSerialVersion());
    }

    public int createRemoveAdminPlan(String planName, DatacenterId dcid, AdminId aid) throws RemoteException {
        if (dcid != null && aid != null) {
            throw new IllegalArgumentException("dcid and aid parameters cannot both be non-null");
        }
        if (dcid == null && aid == null) {
            throw new IllegalArgumentException("dcid and aid parameters cannot both be null");
        }
        return this.proxyRemote.createRemoveAdminPlan(planName, dcid, aid, NULL_CTX, this.getSerialVersion());
    }

    public int createStopAllRepNodesPlan(String planName) throws RemoteException {
        return this.proxyRemote.createStopAllRepNodesPlan(planName, NULL_CTX, this.getSerialVersion());
    }

    public int createStartAllRepNodesPlan(String planName) throws RemoteException {
        return this.proxyRemote.createStartAllRepNodesPlan(planName, NULL_CTX, this.getSerialVersion());
    }

    public int createStopRepNodesPlan(String planName, Set<RepNodeId> rnids) throws RemoteException {
        return this.proxyRemote.createStopRepNodesPlan(planName, rnids, NULL_CTX, this.getSerialVersion());
    }

    public int createStartRepNodesPlan(String planName, Set<RepNodeId> rnids) throws RemoteException {
        return this.proxyRemote.createStartRepNodesPlan(planName, rnids, NULL_CTX, this.getSerialVersion());
    }

    public int createChangeParamsPlan(String planName, ResourceId rid, ParameterMap newParams) throws RemoteException {
        return this.proxyRemote.createChangeParamsPlan(planName, rid, newParams, NULL_CTX, this.getSerialVersion());
    }

    public int createChangeAllParamsPlan(String planName, DatacenterId dcid, ParameterMap newParams) throws RemoteException {
        return this.proxyRemote.createChangeAllParamsPlan(planName, dcid, newParams, NULL_CTX, this.getSerialVersion());
    }

    public int createChangeAllAdminsPlan(String planName, DatacenterId dcid, ParameterMap newParams) throws RemoteException {
        return this.proxyRemote.createChangeAllAdminsPlan(planName, dcid, newParams, NULL_CTX, this.getSerialVersion());
    }

    public int createChangeGlobalSecurityParamsPlan(String planName, ParameterMap newParams) throws RemoteException {
        return this.proxyRemote.createChangeGlobalSecurityParamsPlan(planName, newParams, NULL_CTX, this.getSerialVersion());
    }

    public int createCreateUserPlan(String planName, String userName, boolean isEnabled, boolean isAdmin, char[] plainPassword) throws RemoteException {
        return this.proxyRemote.createCreateUserPlan(planName, userName, isEnabled, isAdmin, plainPassword, NULL_CTX, this.getSerialVersion());
    }

    public int createMigrateSNPlan(String planName, StorageNodeId oldNode, StorageNodeId newNode, int newHttpPort) throws RemoteException {
        return this.proxyRemote.createMigrateSNPlan(planName, oldNode, newNode, newHttpPort, NULL_CTX, this.getSerialVersion());
    }

    public int createRemoveSNPlan(String planName, StorageNodeId targetNode) throws RemoteException {
        return this.proxyRemote.createRemoveSNPlan(planName, targetNode, NULL_CTX, this.getSerialVersion());
    }

    public int createRemoveDatacenterPlan(String planName, DatacenterId targetId) throws RemoteException {
        return this.proxyRemote.createRemoveDatacenterPlan(planName, targetId, NULL_CTX, this.getSerialVersion());
    }

    public int createDeployTopologyPlan(String planName, String candidateName) throws RemoteException {
        return this.proxyRemote.createDeployTopologyPlan(planName, candidateName, NULL_CTX, this.getSerialVersion());
    }

    public int createRepairPlan(String planName) throws RemoteException {
        return this.proxyRemote.createRepairPlan(planName, NULL_CTX, this.getSerialVersion());
    }

    public int createAddTablePlan(String planName, String tableId, String parentName, FieldMap fieldMap, List<String> primaryKey, List<String> majorKey, boolean r2compat, int schemaId, String description) throws RemoteException {
        return this.proxyRemote.createAddTablePlan(planName, tableId, parentName, fieldMap, primaryKey, majorKey, r2compat, schemaId, description, NULL_CTX, this.getSerialVersion());
    }

    public int createRemoveTablePlan(String planName, String tableName, boolean removeData) throws RemoteException {
        return this.proxyRemote.createRemoveTablePlan(planName, tableName, removeData, NULL_CTX, this.getSerialVersion());
    }

    public int createAddIndexPlan(String planName, String indexName, String tableName, String[] indexedFields, String description) throws RemoteException {
        return this.proxyRemote.createAddIndexPlan(planName, indexName, tableName, indexedFields, description, NULL_CTX, this.getSerialVersion());
    }

    public int createRemoveIndexPlan(String planName, String indexName, String tableName) throws RemoteException {
        return this.proxyRemote.createRemoveIndexPlan(planName, indexName, tableName, NULL_CTX, this.getSerialVersion());
    }

    public int createEvolveTablePlan(String planName, String tableName, int tableVersion, FieldMap fieldMap) throws RemoteException {
        return this.proxyRemote.createEvolveTablePlan(planName, tableName, tableVersion, fieldMap, NULL_CTX, this.getSerialVersion());
    }

    public void configure(String storeName) throws RemoteException {
        this.proxyRemote.configure(storeName, NULL_CTX, this.getSerialVersion());
    }

    public String getStoreName() throws RemoteException {
        return this.proxyRemote.getStoreName(NULL_CTX, this.getSerialVersion());
    }

    public String getRootDir() throws RemoteException {
        return this.proxyRemote.getRootDir(NULL_CTX, this.getSerialVersion());
    }

    public Topology getTopology() throws RemoteException {
        return this.proxyRemote.getTopology(NULL_CTX, this.getSerialVersion());
    }

    public Map<String, KVStoreUser.UserDescription> getUsersDescription() throws RemoteException {
        return this.proxyRemote.getUsersDescription(NULL_CTX, this.getSerialVersion());
    }

    public <T extends Metadata<? extends MetadataInfo>> T getMetadata(Class<T> returnType, Metadata.MetadataType metadataType) throws RemoteException {
        return this.proxyRemote.getMetadata(returnType, metadataType, NULL_CTX, this.getSerialVersion());
    }

    public TopologyCandidate getTopologyCandidate(String candidateName) throws RemoteException {
        return this.proxyRemote.getTopologyCandidate(candidateName, NULL_CTX, this.getSerialVersion());
    }

    public Parameters getParameters() throws RemoteException {
        return this.proxyRemote.getParameters(NULL_CTX, this.getSerialVersion());
    }

    public ParameterMap getRepNodeParameters(RepNodeId id) throws RemoteException {
        return this.proxyRemote.getRepNodeParameters(id, NULL_CTX, this.getSerialVersion());
    }

    public ParameterMap getPolicyParameters() throws RemoteException {
        return this.proxyRemote.getPolicyParameters(NULL_CTX, this.getSerialVersion());
    }

    public void newParameters() throws RemoteException {
        this.proxyRemote.newParameters(NULL_CTX, this.getSerialVersion());
    }

    public void newGlobalParameters() throws RemoteException {
        this.proxyRemote.newGlobalParameters(NULL_CTX, this.getSerialVersion());
    }

    public void stop(boolean force) throws RemoteException {
        this.proxyRemote.stop(force, NULL_CTX, this.getSerialVersion());
    }

    public void setPolicies(ParameterMap policyParams) throws RemoteException {
        this.proxyRemote.setPolicies(policyParams, NULL_CTX, this.getSerialVersion());
    }

    public Map<ResourceId, ServiceChange> getStatusMap() throws RemoteException {
        return this.proxyRemote.getStatusMap(NULL_CTX, this.getSerialVersion());
    }

    public Map<ResourceId, PerfEvent> getPerfMap() throws RemoteException {
        return this.proxyRemote.getPerfMap(NULL_CTX, this.getSerialVersion());
    }

    public Tracker.RetrievedEvents<ServiceChange> getStatusSince(long since) throws RemoteException {
        return this.proxyRemote.getStatusSince(since, NULL_CTX, this.getSerialVersion());
    }

    public Tracker.RetrievedEvents<PerfEvent> getPerfSince(long since) throws RemoteException {
        return this.proxyRemote.getPerfSince(since, NULL_CTX, this.getSerialVersion());
    }

    public Tracker.RetrievedEvents<LogRecord> getLogSince(long since) throws RemoteException {
        return this.proxyRemote.getLogSince(since, NULL_CTX, this.getSerialVersion());
    }

    public Tracker.RetrievedEvents<PlanStateChange> getPlanSince(long since) throws RemoteException {
        return this.proxyRemote.getPlanSince(since, NULL_CTX, this.getSerialVersion());
    }

    public void registerLogTrackerListener(TrackerListener tl) throws RemoteException {
        this.proxyRemote.registerLogTrackerListener(tl, NULL_CTX, this.getSerialVersion());
    }

    public void removeLogTrackerListener(TrackerListener tl) throws RemoteException {
        this.proxyRemote.removeLogTrackerListener(tl, NULL_CTX, this.getSerialVersion());
    }

    public void registerStatusTrackerListener(TrackerListener tl) throws RemoteException {
        this.proxyRemote.registerStatusTrackerListener(tl, NULL_CTX, this.getSerialVersion());
    }

    public void removeStatusTrackerListener(TrackerListener tl) throws RemoteException {
        this.proxyRemote.removeStatusTrackerListener(tl, NULL_CTX, this.getSerialVersion());
    }

    public void registerPerfTrackerListener(TrackerListener tl) throws RemoteException {
        this.proxyRemote.registerPerfTrackerListener(tl, NULL_CTX, this.getSerialVersion());
    }

    public void removePerfTrackerListener(TrackerListener tl) throws RemoteException {
        this.proxyRemote.removePerfTrackerListener(tl, NULL_CTX, this.getSerialVersion());
    }

    public void registerPlanTrackerListener(TrackerListener tl) throws RemoteException {
        this.proxyRemote.registerPlanTrackerListener(tl, NULL_CTX, this.getSerialVersion());
    }

    public void removePlanTrackerListener(TrackerListener tl) throws RemoteException {
        this.proxyRemote.removePlanTrackerListener(tl, NULL_CTX, this.getSerialVersion());
    }

    public Map<String, Long> getLogFileNames() throws RemoteException {
        return this.proxyRemote.getLogFileNames(NULL_CTX, this.getSerialVersion());
    }

    public ReplicatedEnvironment.State getAdminState() throws RemoteException {
        return this.proxyRemote.getAdminState(NULL_CTX, this.getSerialVersion());
    }

    public URI getMasterRmiAddress() throws RemoteException {
        return this.proxyRemote.getMasterRmiAddress(NULL_CTX, this.getSerialVersion());
    }

    public URI getMasterHttpAddress() throws RemoteException {
        return this.proxyRemote.getMasterHttpAddress(NULL_CTX, this.getSerialVersion());
    }

    public List<CriticalEvent> getEvents(long startTime, long endTime, CriticalEvent.EventType type) throws RemoteException {
        return this.proxyRemote.getEvents(startTime, endTime, type, NULL_CTX, this.getSerialVersion());
    }

    public CriticalEvent getOneEvent(String eventId) throws RemoteException {
        return this.proxyRemote.getOneEvent(eventId, NULL_CTX, this.getSerialVersion());
    }

    public String[] startBackup() throws RemoteException {
        return this.proxyRemote.startBackup(NULL_CTX, this.getSerialVersion());
    }

    public long stopBackup() throws RemoteException {
        return this.proxyRemote.stopBackup(NULL_CTX, this.getSerialVersion());
    }

    public void updateMemberHAAddress(AdminId targetId, String targetHelperHosts, String newNodeHostPort) throws RemoteException {
        this.proxyRemote.updateMemberHAAddress(targetId, targetHelperHosts, newNodeHostPort, NULL_CTX, this.getSerialVersion());
    }

    public VerifyResults verifyConfiguration(boolean showProgress, boolean listAll) throws RemoteException {
        return this.proxyRemote.verifyConfiguration(showProgress, listAll, NULL_CTX, this.getSerialVersion());
    }

    public VerifyResults verifyUpgrade(KVVersion targetVersion, List<StorageNodeId> snIds, boolean showProgress, boolean listAll) throws RemoteException {
        this.checkMethodSupported((short)3);
        return this.proxyRemote.verifyUpgrade(targetVersion, snIds, showProgress, listAll, NULL_CTX, this.getSerialVersion());
    }

    public VerifyResults verifyPrerequisite(KVVersion targetVersion, KVVersion prerequisiteVersion, List<StorageNodeId> snIds, boolean showProgress, boolean listAll) throws RemoteException {
        this.checkMethodSupported((short)3);
        return this.proxyRemote.verifyPrerequisite(targetVersion, prerequisiteVersion, snIds, showProgress, listAll, NULL_CTX, this.getSerialVersion());
    }

    public String getUpgradeOrder(KVVersion targetVersion, KVVersion prerequisiteVersion) throws RemoteException {
        this.checkMethodSupported((short)3);
        return this.proxyRemote.getUpgradeOrder(targetVersion, prerequisiteVersion, NULL_CTX, this.getSerialVersion());
    }

    public LoadParameters getParams() throws RemoteException {
        return this.proxyRemote.getParams(NULL_CTX, this.getSerialVersion());
    }

    public String getStorewideLogName() throws RemoteException {
        return this.proxyRemote.getStorewideLogName(NULL_CTX, this.getSerialVersion());
    }

    public List<String> getTopologyHistory(boolean concise) throws RemoteException {
        return this.proxyRemote.getTopologyHistory(concise, NULL_CTX, this.getSerialVersion());
    }

    public SortedMap<String, AvroDdl.SchemaSummary> getSchemaSummaries(boolean includeDisabled) throws RemoteException {
        this.checkMethodSupported((short)2);
        return this.proxyRemote.getSchemaSummaries(includeDisabled, NULL_CTX, this.getSerialVersion());
    }

    public AvroDdl.SchemaDetails getSchemaDetails(int schemaId) throws RemoteException {
        this.checkMethodSupported((short)2);
        return this.proxyRemote.getSchemaDetails(schemaId, NULL_CTX, this.getSerialVersion());
    }

    public AvroDdl.AddSchemaResult addSchema(AvroSchemaMetadata metadata, String schemaText, AvroDdl.AddSchemaOptions options) throws RemoteException {
        this.checkMethodSupported((short)2);
        return this.proxyRemote.addSchema(metadata, schemaText, options, NULL_CTX, this.getSerialVersion());
    }

    public boolean updateSchemaStatus(int schemaId, AvroSchemaMetadata newMeta) throws RemoteException {
        this.checkMethodSupported((short)2);
        return this.proxyRemote.updateSchemaStatus(schemaId, newMeta, NULL_CTX, this.getSerialVersion());
    }

    public String getPlanStatus(int planId, long options) throws RemoteException {
        return this.proxyRemote.getPlanStatus(planId, options, NULL_CTX, this.getSerialVersion());
    }

    public String validateTopology(String candidateName) throws RemoteException {
        return this.proxyRemote.validateTopology(candidateName, NULL_CTX, this.getSerialVersion());
    }

    public String moveRN(String candidateName, RepNodeId rnId, StorageNodeId snId) throws RemoteException {
        return this.proxyRemote.moveRN(candidateName, rnId, snId, NULL_CTX, this.getSerialVersion());
    }

    public void installStatusReceiver(AdminStatusReceiver asr) throws RemoteException {
        this.proxyRemote.installStatusReceiver(asr, NULL_CTX, this.getSerialVersion());
    }

    public int createChangeUserPlan(String planName, String userName, Boolean isEnabled, char[] newPlainPassword, boolean retainPassword, boolean clearRetainedPassword) throws RemoteException {
        return this.proxyRemote.createChangeUserPlan(planName, userName, isEnabled, newPlainPassword, retainPassword, clearRetainedPassword, NULL_CTX, this.getSerialVersion());
    }

    public int createDropUserPlan(String planName, String userName) throws RemoteException {
        return this.proxyRemote.createDropUserPlan(planName, userName, NULL_CTX, this.getSerialVersion());
    }

    public boolean verifyUserPassword(String userName, char[] password) throws RemoteException {
        return this.proxyRemote.verifyUserPassword(userName, password, NULL_CTX, this.getSerialVersion());
    }

    public int[] getPlanIdRange(long startTime, long endTime, int howMany) throws RemoteException {
        return this.proxyRemote.getPlanIdRange(startTime, endTime, howMany, NULL_CTX, this.getSerialVersion());
    }

    public Map<Integer, Plan> getPlanRange(int firstPlanId, int howMany) throws RemoteException {
        return this.proxyRemote.getPlanRange(firstPlanId, howMany, NULL_CTX, this.getSerialVersion());
    }
}

