/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.fault.InternalFaultException;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.util.server.LoggerUtils;

public class AdminServiceFaultHandler
extends ProcessFaultHandler {
    final AdminService owner;
    private Throwable shutdownFault;
    private boolean suppressPrinting = false;

    public AdminServiceFaultHandler(Logger logger, AdminService owner) {
        super(logger, ProcessExitCode.RESTART);
        this.owner = owner;
    }

    @Override
    protected void queueShutdownInternal(Throwable fault, ProcessExitCode exitCode) {
        this.shutdownFault = fault;
        new AsyncShutdownThread(exitCode).start();
    }

    @Override
    protected RuntimeException getThrowException(RuntimeException fault) {
        if (fault instanceof InternalFaultException) {
            return fault;
        }
        if (fault instanceof ClientAccessException) {
            return ((ClientAccessException)fault).getCause();
        }
        return new AdminFaultException(fault);
    }

    @Override
    public ProcessExitCode getExitCode(RuntimeException fault, ProcessExitCode exitCode) {
        if (fault instanceof InternalFaultException) {
            return null;
        }
        if (this.owner.getAdmin() == null || this.owner.getAdmin().isClosing()) {
            return exitCode;
        }
        String msg = "Unanticipated exception encountered: " + LoggerUtils.getStackTrace(fault);
        this.logger.severe(msg);
        if (fault instanceof NonfatalAssertionException) {
            return null;
        }
        if (!this.suppressPrinting) {
            System.err.println(msg);
        }
        return exitCode;
    }

    void setSuppressPrinting() {
        this.suppressPrinting = true;
    }

    private class AsyncShutdownThread
    extends Thread {
        final ProcessExitCode exitCode;

        AsyncShutdownThread(ProcessExitCode exitCode) {
            this.exitCode = exitCode;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Thread.yield();
            System.err.println("Process exiting due to fault");
            if (AdminServiceFaultHandler.this.shutdownFault != null) {
                AdminServiceFaultHandler.this.shutdownFault.printStackTrace(System.err);
            }
            if (!AdminServiceFaultHandler.this.owner.getUsingThreads()) {
                LoggerUtils.closeAllHandlers();
                System.err.flush();
                System.exit(this.exitCode.getValue());
            }
        }
    }
}

