/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import java.util.logging.Logger;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.AdminService;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.AccessCheckerImpl;
import oracle.kv.impl.security.login.InternalLoginManager;
import oracle.kv.impl.security.login.LoginUpdater;
import oracle.kv.impl.security.login.ParamTopoResolver;
import oracle.kv.impl.security.login.TokenResolverImpl;
import oracle.kv.impl.security.login.TokenVerifier;

public class AdminSecurity
implements LoginUpdater.GlobalParamsUpdater,
LoginUpdater.ServiceParamsUpdater {
    private final AdminService adminService;
    private final AccessCheckerImpl accessChecker;
    private final TokenResolverImpl tokenResolver;
    private final AdminParamsHandle paramsHandle;
    private final ParamTopoResolver topoResolver;
    private final TokenVerifier tokenVerifier;
    private Logger logger;
    private InternalLoginManager loginMgr;

    public AdminSecurity(AdminService adminService, Logger logger) {
        this.logger = logger;
        this.adminService = adminService;
        AdminServiceParams params = adminService.getParams();
        SecurityParams secParams = params.getSecurityParams();
        String storeName = params.getGlobalParams().getKVStoreName();
        if (secParams.isSecure()) {
            StorageNodeParams snParams = params.getStorageNodeParams();
            String hostname = snParams.getHostname();
            int registryPort = snParams.getRegistryPort();
            this.paramsHandle = new AdminParamsHandle();
            this.topoResolver = new ParamTopoResolver(this.paramsHandle, logger);
            this.loginMgr = new InternalLoginManager(this.topoResolver);
            this.tokenResolver = new TokenResolverImpl(hostname, registryPort, storeName, this.topoResolver, this.loginMgr, logger);
            AdminParams ap = params.getAdminParams();
            int tokenCacheCapacity = ap.getLoginCacheSize();
            GlobalParams gp = params.getGlobalParams();
            long tokenCacheEntryLifetime = gp.getLoginCacheTimeoutUnit().toMillis(gp.getLoginCacheTimeout());
            TokenVerifier.CacheConfig tokenCacheConfig = new TokenVerifier.CacheConfig(tokenCacheCapacity, tokenCacheEntryLifetime);
            this.tokenVerifier = new TokenVerifier(tokenCacheConfig, this.tokenResolver);
            this.accessChecker = new AccessCheckerImpl(this.tokenVerifier, logger);
        } else {
            this.paramsHandle = null;
            this.topoResolver = null;
            this.tokenResolver = null;
            this.accessChecker = null;
            this.loginMgr = null;
            this.tokenVerifier = null;
        }
    }

    void configure(String storeName) {
        if (this.loginMgr == null) {
            return;
        }
        this.loginMgr.logout();
        this.loginMgr = new InternalLoginManager(this.topoResolver);
        this.logger = this.adminService.getLogger();
        this.topoResolver.setLogger(this.logger);
        this.tokenResolver.setLogger(this.logger);
        this.tokenResolver.setStoreName(storeName);
        this.accessChecker.setLogger(this.logger);
    }

    public AccessChecker getAccessChecker() {
        return this.accessChecker;
    }

    public InternalLoginManager getLoginManager() {
        return this.loginMgr;
    }

    @Override
    public void newServiceParameters(ParameterMap map) {
        if (this.tokenVerifier == null) {
            return;
        }
        AdminParams ap = new AdminParams(map);
        int newCapacity = ap.getLoginCacheSize();
        if (this.tokenVerifier.updateLoginCacheSize(newCapacity)) {
            this.logger.info(String.format("AdminSecurity: loginCacheSize has been updated to %d", newCapacity));
        }
    }

    @Override
    public void newGlobalParameters(ParameterMap map) {
        if (this.tokenVerifier == null) {
            return;
        }
        GlobalParams gp = new GlobalParams(map);
        long newLifeTime = gp.getLoginCacheTimeoutUnit().toMillis(gp.getLoginCacheTimeout());
        if (this.tokenVerifier.updateLoginCacheTimeout(newLifeTime)) {
            this.logger.info(String.format("AdminSecurity: loginCacheTimeout has been updated to %d ms", newLifeTime));
        }
    }

    private class AdminParamsHandle
    implements ParamTopoResolver.ParamsHandle {
        private AdminParamsHandle() {
        }

        @Override
        public Parameters getParameters() {
            Admin admin = AdminSecurity.this.adminService.getAdmin();
            if (admin == null) {
                return null;
            }
            return admin.getCurrentParameters();
        }
    }
}

