/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Durability;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.MasterTransferFailureException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.DeploymentInfo;
import oracle.kv.impl.admin.topo.RealizedTopology;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.impl.util.VersionUtil;

public class AdminSchemaVersion {
    private static final int SCHEMA_VERSION_3 = 3;
    public static final int CURRENT_SCHEMA = 3;
    private static final String DB_NAME = "AdminSchemaVersion";
    private static final String SCHEMA_VERSION_KEY = "schemaVersion";
    private static final String SOFTWARE_VERSION_KEY = "softwareVersion";
    private static final KVVersion FIRST_KV_VERSION = KVVersion.R1_2_123;
    private final Admin admin;
    private final ReplicatedEnvironment repEnv;
    private final Logger logger;

    public AdminSchemaVersion(Admin admin, Logger logger) {
        this.logger = logger;
        this.admin = admin;
        this.repEnv = admin.getEnv();
    }

    void checkAndUpdateVersion(Transaction txn) {
        this.checkAndUpdateVersion(txn, 3, true);
    }

    void checkVersion(Transaction txn) {
        this.checkAndUpdateVersion(txn, 3, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAndUpdateVersion(Transaction txn, int useSchemaVersion, boolean doUpdate) {
        KVVersion existingKVVersion;
        int existingVersion;
        List<String> dbNames = this.repEnv.getDatabaseNames();
        if (dbNames.isEmpty()) {
            if (doUpdate) {
                this.init(txn, useSchemaVersion);
            }
            return;
        }
        if (!dbNames.contains(DB_NAME)) {
            existingVersion = 1;
            existingKVVersion = FIRST_KV_VERSION;
        } else {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(false);
            dbConfig.setTransactional(true);
            dbConfig.setReadOnly(true);
            try (Database versionDb = null;){
                versionDb = this.repEnv.openDatabase(null, DB_NAME, dbConfig);
                existingVersion = this.readSchemaVersion(txn, versionDb);
                existingKVVersion = this.readSoftwareVersion(txn, versionDb);
                if (existingVersion > useSchemaVersion) {
                    throw new IllegalStateException("This Admin Service software is at " + KVVersion.CURRENT_VERSION.getNumericVersionString() + ", schema version " + useSchemaVersion + " but the stored schema is at version " + existingVersion + "/" + existingKVVersion.getNumericVersionString() + ". Please upgrade this node's NoSQL Database" + " software version to " + existingKVVersion.getNumericVersionString() + " or higher.");
                }
            }
        }
        if (existingKVVersion.equals(KVVersion.CURRENT_VERSION)) {
            assert (existingVersion == 3);
            return;
        }
        VersionUtil.checkUpgrade(existingKVVersion);
        if (existingKVVersion.compareTo(KVVersion.CURRENT_VERSION) < 0) {
            if (doUpdate) {
                this.update(existingVersion, existingKVVersion.toString(), txn, useSchemaVersion);
            } else {
                try {
                    ReplicationGroupAdmin repGroupAdmin = new ReplicationGroupAdmin(this.repEnv.getGroup().getName(), this.repEnv.getRepConfig().getHelperSockets(), this.admin.getRepNetConfig());
                    repGroupAdmin.transferMaster(Collections.singleton(this.repEnv.getNodeName()), 1, TimeUnit.MINUTES, false);
                    this.logger.log(Level.INFO, "Master transfer initiated due to upgrade to {0}", KVVersion.CURRENT_VERSION.getNumericVersionString());
                }
                catch (MasterTransferFailureException mtfe) {
                    this.logger.log(Level.INFO, "Attempt to transfer master to this node failed: {0}", mtfe.getMessage());
                }
                catch (Exception ex) {
                    this.logger.log(Level.INFO, "Attempt to transfer master to this node failed", ex);
                }
            }
        }
    }

    private void update(int existingVersion, String existingKVVersion, Transaction txn, int useSchemaVersion) {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(true);
        Database versionDb = this.repEnv.openDatabase(txn, DB_NAME, dbConfig);
        this.updateSchemaVersion(existingVersion, existingKVVersion, txn, versionDb, useSchemaVersion);
        versionDb.close();
    }

    private void init(Transaction txn, int useSchemaVersion) {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setExclusiveCreate(true);
        dbConfig.setTransactional(true);
        Database versionDb = this.repEnv.openDatabase(txn, DB_NAME, dbConfig);
        this.updateSchemaVersion(0, null, txn, versionDb, useSchemaVersion);
        versionDb.close();
    }

    private void updateSchemaVersion(int existingVersion, String existingKVVersion, Transaction txn, Database versionDb, int useSchemaVersion) {
        if (existingVersion == 0) {
            this.logger.info("Initializing Admin Schema to schema version " + useSchemaVersion + "/NoSQL DB " + KVVersion.CURRENT_VERSION);
        } else if (existingVersion < 3) {
            this.logger.info("Updating Admin Schema version from schema version " + existingVersion + "/NoSQL DB " + existingKVVersion + " to schema version " + useSchemaVersion + "/NoSQL DB " + KVVersion.CURRENT_VERSION);
            this.upgradeToV3(existingVersion, txn);
        }
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        StringBinding.stringToEntry(SCHEMA_VERSION_KEY, key);
        IntegerBinding.intToEntry(useSchemaVersion, value);
        versionDb.put(txn, key, value);
        StringBinding.stringToEntry(SOFTWARE_VERSION_KEY, key);
        StringBinding.stringToEntry(KVVersion.CURRENT_VERSION.toString(), value);
        versionDb.put(txn, key, value);
    }

    private int readSchemaVersion(Transaction txn, Database versionDb) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        StringBinding.stringToEntry(SCHEMA_VERSION_KEY, key);
        OperationStatus status = versionDb.get(txn, key, value, LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS) {
            return IntegerBinding.entryToInt(value);
        }
        return 1;
    }

    private KVVersion readSoftwareVersion(Transaction txn, Database versionDb) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        StringBinding.stringToEntry(SOFTWARE_VERSION_KEY, key);
        OperationStatus status = versionDb.get(txn, key, value, LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS) {
            return KVVersion.parseVersion(StringBinding.entryToString(value));
        }
        return FIRST_KV_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int openAndReadSchemaVersion() {
        int version;
        Transaction txn;
        block3: {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(false);
            dbConfig.setTransactional(true);
            dbConfig.setReadOnly(false);
            Database versionDb = null;
            txn = null;
            version = 0;
            try {
                txn = this.repEnv.beginTransaction(null, new TransactionConfig().setDurability(Durability.COMMIT_SYNC));
                versionDb = this.repEnv.openDatabase(txn, DB_NAME, dbConfig);
                version = this.readSchemaVersion(txn, versionDb);
                txn.commit();
                if (versionDb == null) break block3;
            }
            catch (Throwable throwable) {
                if (versionDb != null) {
                    versionDb.close();
                }
                TxnUtil.abort(txn);
                throw throwable;
            }
            versionDb.close();
        }
        TxnUtil.abort(txn);
        return version;
    }

    private void upgradeToV3(int existingVersion, Transaction txn) {
        if (existingVersion >= 3) {
            return;
        }
        EntityStore eStore = this.admin.initEstore();
        this.upgradeAdminTopologyToV3(eStore, txn);
        this.upgradeAllPlansToV3(eStore, txn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeAllPlansToV3(EntityStore eStore, Transaction txn) {
        this.logger.info("Upgrading all plans to Admin DB version 3.");
        PrimaryIndex<Integer, AbstractPlan> pi = eStore.getPrimaryIndex(Integer.class, AbstractPlan.class);
        try (EntityCursor cursor = pi.entities(txn, null);){
            AbstractPlan p = (AbstractPlan)cursor.first();
            while (p != null) {
                p.upgradeToV3();
                p.persist(eStore, txn);
                p = (AbstractPlan)cursor.next();
            }
        }
    }

    private void upgradeAdminTopologyToV3(EntityStore eStore, Transaction txn) {
        Topology oldTopo = Topology.fetchCommitted(eStore, txn);
        this.logger.info("Upgrading current topology to Admin DB version 3.");
        if (oldTopo.getVersion() != 0) {
            throw new IllegalStateException("Unexpected Topology version " + oldTopo.getVersion() + " found in legacy Admin database.");
        }
        if (!oldTopo.upgrade()) {
            this.logger.severe("Unable to upgrade the Topology from its earlier version. The store will continue to run with this Topology, But certain features that are new in R2, such as dynamic master rebalancing, and elasticity operations, will not be available. To enable these features will require dumping the database contents and restoring them to an R2 topology, using the snapshot and load commands.  Please see the NoSQL Database Administrator's Guide, chap. 7, for more information");
        }
        DeploymentInfo info = DeploymentInfo.makeStartupDeploymentInfo();
        RealizedTopology rt = new RealizedTopology(oldTopo, info);
        rt.setStartTime();
        this.admin.getTopoStore().save(txn, rt);
    }
}

